/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.mapper;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.DiscreteTransform;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.scale.GuideMapper;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMapperWithGuideBreaks;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMappers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005J7\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004\"\u0004\b\u0000\u0010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u0013\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005J7\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00150\r\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0015\u00a2\u0006\u0002\u0010\u001eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/builder/scale/mapper/GuideMappers;", "", "()V", "IDENTITY", "Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "", "getIDENTITY", "()Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "NUMERIC_UNDEFINED", "getNUMERIC_UNDEFINED", "asContinuous", "T", "mapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "asNotContinuous", "continuousToContinuous", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "range", "naValue", "continuousToDiscrete", "TargetT", "outputValues", "", "(Ljetbrains/datalore/base/interval/DoubleSpan;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "discreteToContinuous", "discreteTransform", "Ljetbrains/datalore/plot/base/DiscreteTransform;", "outputRange", "discreteToDiscrete", "(Ljetbrains/datalore/plot/base/DiscreteTransform;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/base/ScaleMapper;", "plot-builder-portable"})
public final class GuideMappers {
    @NotNull
    public static final GuideMappers INSTANCE = new GuideMappers();
    @NotNull
    private static final GuideMapper<Double> IDENTITY = new GuideMapper<Double>(Mappers.INSTANCE.getIDENTITY(), false);
    @NotNull
    private static final GuideMapper<Double> NUMERIC_UNDEFINED = new GuideMapper<Double>(Mappers.INSTANCE.getNUMERIC_UNDEFINED(), false);

    private GuideMappers() {
    }

    @NotNull
    public final GuideMapper<Double> getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final GuideMapper<Double> getNUMERIC_UNDEFINED() {
        return NUMERIC_UNDEFINED;
    }

    @NotNull
    public final <TargetT> ScaleMapper<TargetT> discreteToDiscrete(@NotNull DiscreteTransform discreteTransform, @NotNull List<? extends TargetT> outputValues, @Nullable TargetT naValue) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        return new GuideMapperWithGuideBreaks<Object, TargetT>(Mappers.INSTANCE.discrete(discreteTransform, outputValues, naValue), discreteTransform.getEffectiveDomain(), discreteToDiscrete.1.INSTANCE);
    }

    @NotNull
    public final <TargetT> GuideMapper<TargetT> continuousToDiscrete(@Nullable DoubleSpan domain, @NotNull List<? extends TargetT> outputValues, TargetT naValue) {
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        ScaleMapper<TargetT> mapper = Mappers.INSTANCE.quantized(domain, (Collection)outputValues, naValue);
        return this.asNotContinuous(mapper);
    }

    @NotNull
    public final ScaleMapper<Double> discreteToContinuous(@NotNull DiscreteTransform discreteTransform, @NotNull DoubleSpan outputRange, double naValue) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        Intrinsics.checkNotNullParameter((Object)outputRange, (String)"outputRange");
        ScaleMapper<Double> mapper = Mappers.INSTANCE.discreteToContinuous(discreteTransform.getEffectiveDomainTransformed(), outputRange, naValue);
        return new GuideMapperWithGuideBreaks<Object, Double>(mapper, discreteTransform.getEffectiveDomain(), discreteToContinuous.1.INSTANCE);
    }

    @NotNull
    public final GuideMapper<Double> continuousToContinuous(@NotNull DoubleSpan domain, @NotNull DoubleSpan range, double naValue) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.asContinuous(Mappers.INSTANCE.linear(domain, range, naValue));
    }

    @NotNull
    public final <T> GuideMapper<T> asNotContinuous(@NotNull ScaleMapper<T> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new GuideMapper<T>(mapper, false);
    }

    @NotNull
    public final <T> GuideMapper<T> asContinuous(@NotNull ScaleMapper<T> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new GuideMapper<T>(mapper, true);
    }
}

