/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalVerticalLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "labelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "getLabelHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "labelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;", "getLabelVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "", "axisMapper", "Lkotlin/Function1;", "labelBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelNormalSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "Companion", "plot-builder-portable"})
public final class HorizontalVerticalLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Text.VerticalAnchor labelVerticalAnchor;
    private static final double MIN_DISTANCE = 5.0;
    private static final double ROTATION_DEGREE = 90.0;

    public HorizontalVerticalLabelsLayout(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, breaks, theme);
        this.labelVerticalAnchor = Text.VerticalAnchor.CENTER;
    }

    @NotNull
    public final Text.HorizontalAnchor getLabelHorizontalAnchor() {
        Text.HorizontalAnchor horizontalAnchor;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                horizontalAnchor = Text.HorizontalAnchor.RIGHT;
                break;
            }
            case 2: {
                horizontalAnchor = Text.HorizontalAnchor.LEFT;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        return horizontalAnchor;
    }

    @NotNull
    public final Text.VerticalAnchor getLabelVerticalAnchor() {
        return this.labelVerticalAnchor;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper) {
        DoubleRectangle bounds;
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        double height = this.getLabelSpec().height();
        List<Double> ticks = this.mapToAxis$plot_builder_portable(this.getBreaks().getTransformedValues(), axisMapper);
        boolean overlap = false;
        if (this.getBreaks().getSize() >= 2) {
            double minTickDistance = height + 5.0;
            double tickDistance = Math.abs(((Number)ticks.get(0)).doubleValue() - ((Number)ticks.get(1)).doubleValue());
            overlap = tickDistance < minTickDistance;
        }
        DoubleRectangle doubleRectangle = bounds = this.labelsBounds(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return this.createAxisLabelsLayoutInfoBuilder(doubleRectangle, overlap).labelHorizontalAnchor(this.getLabelHorizontalAnchor()).labelVerticalAnchor(this.labelVerticalAnchor).labelRotationAngle(90.0).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        if (!(this.labelVerticalAnchor == Text.VerticalAnchor.CENTER)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        double w = labelNormalSize.getY();
        double h = labelNormalSize.getX();
        double x2 = -w / (double)2;
        double y2 = 0.0;
        return new DoubleRectangle(x2, y2, w, h);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalVerticalLabelsLayout$Companion;", "", "()V", "MIN_DISTANCE", "", "ROTATION_DEGREE", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

