/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.Margins;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.VerticalRotatedLabelsLayout;
import jetbrains.datalore.plot.builder.presentation.LabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJN\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002JG\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u00072\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00070\u0019\u00a2\u0006\u0002\u0010$J9\u0010%\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u00072\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00070\u0019\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020#J:\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0019J\u0016\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u0007J\u001e\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ8\u00103\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00192\u0006\u0010 \u001a\u00020\u0012H\u0002\u00a8\u00064"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/BreakLabelsLayoutUtil;", "", "()V", "alignToLabelMargin", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "bounds", "tickLength", "", "margins", "Ljetbrains/datalore/plot/builder/layout/Margins;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "applyLabelMargins", "doLayoutVerticalAxisLabels", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/LabelSpec;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "axisLength", "axisMapper", "Lkotlin/Function1;", "estimateBreakCount", "", "length", "labels", "", "", "tickLabelSpec", "rotationAngle", "side", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/util/List;DLjetbrains/datalore/plot/builder/presentation/LabelSpec;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;)I", "estimateBreakCountInitial", "(DLjetbrains/datalore/plot/builder/presentation/LabelSpec;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;)I", "getFlexBreaks", "breaksProvider", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProvider;", "maxCount", "horizontalCenteredLabelBounds", "labelSize", "mapToAxis", "rotatedLabelBounds", "labelNormalSize", "degreeAngle", "textBounds", "elementRect", "verticalAxisLabelsBounds", "plot-builder-portable"})
public final class BreakLabelsLayoutUtil {
    @NotNull
    public static final BreakLabelsLayoutUtil INSTANCE = new BreakLabelsLayoutUtil();

    private BreakLabelsLayoutUtil() {
    }

    @NotNull
    public final ScaleBreaks getFlexBreaks(@NotNull AxisBreaksProvider breaksProvider, int maxCount, double axisLength) {
        Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
        if (!(!breaksProvider.isFixedBreaks())) {
            boolean $i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$32 = false;
            String $i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$32 = "fixed breaks not expected";
            throw new IllegalArgumentException($i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$32.toString());
        }
        if (!(maxCount > 0)) {
            boolean $i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$42 = false;
            String $i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$42 = "maxCount=" + maxCount;
            throw new IllegalArgumentException($i$a$-require-BreakLabelsLayoutUtil$getFlexBreaks$42.toString());
        }
        ScaleBreaks breaks = breaksProvider.getBreaks(maxCount, axisLength);
        if (maxCount == 1 && !breaks.isEmpty()) {
            return new ScaleBreaks(breaks.getDomainValues().subList(0, 1), breaks.getTransformedValues().subList(0, 1), breaks.getLabels().subList(0, 1));
        }
        int count2 = maxCount;
        while (breaks.getSize() > maxCount) {
            int delta = Math.max(1, (breaks.getSize() - maxCount) / 2);
            if ((count2 -= delta) <= 1) {
                breaks = breaksProvider.getBreaks(1, axisLength);
                break;
            }
            breaks = breaksProvider.getBreaks(count2, axisLength);
        }
        return breaks;
    }

    @NotNull
    public final DoubleRectangle horizontalCenteredLabelBounds(@NotNull DoubleVector labelSize) {
        Intrinsics.checkNotNullParameter((Object)labelSize, (String)"labelSize");
        return new DoubleRectangle(-labelSize.getX() / 2.0, 0.0, labelSize.getX(), labelSize.getY());
    }

    @NotNull
    public final AxisLabelsLayoutInfo doLayoutVerticalAxisLabels(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull LabelSpec labelSpec, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme, double axisLength, @NotNull Function1<? super Double, Double> axisMapper) {
        DoubleRectangle doubleRectangle;
        DoubleRectangle labelsBounds;
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        if (!(!orientation.isHorizontal())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (theme.showLabels() && theme.rotateLabels()) {
            return new VerticalRotatedLabelsLayout(orientation, axisDomain, breaks, theme, theme.labelAngle()).doLayout(axisLength, axisMapper);
        }
        double tickLength = theme.showTickMarks() ? theme.tickMarkLength() : 0.0;
        if (theme.showLabels()) {
            labelsBounds = this.verticalAxisLabelsBounds(breaks, axisDomain, axisMapper, labelSpec);
            doubleRectangle = this.applyLabelMargins(labelsBounds, tickLength, theme.tickLabelMargins(), orientation);
        } else if (theme.showTickMarks()) {
            labelsBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
            doubleRectangle = this.applyLabelMargins(labelsBounds, tickLength, theme.tickLabelMargins(), orientation);
        } else {
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        }
        DoubleRectangle axisBounds = doubleRectangle;
        return new AxisLabelsLayoutInfo.Builder().breaks(breaks).bounds(axisBounds).build();
    }

    @NotNull
    public final List<Double> mapToAxis(@NotNull List<Double> breaks, @NotNull DoubleSpan axisDomain, @NotNull Function1<? super Double, Double> axisMapper) {
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        double axisMin = axisDomain.getLowerEnd();
        ArrayList<Double> axisBreaks = new ArrayList<Double>();
        Iterator<Double> iterator2 = breaks.iterator();
        while (iterator2.hasNext()) {
            Double mapped;
            double v = ((Number)iterator2.next()).doubleValue();
            Double d = mapped = (Double)axisMapper.invoke((Object)(v - axisMin));
            Intrinsics.checkNotNull((Object)d);
            axisBreaks.add(d);
        }
        return axisBreaks;
    }

    @NotNull
    public final DoubleRectangle applyLabelMargins(@NotNull DoubleRectangle bounds, double tickLength, @NotNull Margins margins, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        DoubleRectangle it = this.alignToLabelMargin(bounds, tickLength, margins, orientation);
        boolean bl = false;
        DoubleVector offset2 = orientation.isHorizontal() ? new DoubleVector(0.0, margins.getTop()) : new DoubleVector(margins.getLeft(), 0.0);
        DoubleVector origin = it.subtract(offset2).getOrigin();
        DoubleVector dimension = bounds.getDimension().add(orientation.isHorizontal() ? new DoubleVector(0.0, margins.height()) : new DoubleVector(margins.width(), 0.0));
        return new DoubleRectangle(origin, dimension);
    }

    @NotNull
    public final DoubleRectangle alignToLabelMargin(@NotNull DoubleRectangle bounds, double tickLength, @NotNull Margins margins, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        double d;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                d = margins.getRight() + bounds.getWidth();
                break;
            }
            case 2: {
                d = margins.getBottom() + bounds.getHeight();
                break;
            }
            case 3: {
                d = margins.getLeft();
                break;
            }
            case 4: {
                d = margins.getTop();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offset2 = tickLength + d;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(-offset2, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(offset2, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(0.0, -offset2);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, offset2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector offsetVector = doubleVector;
        return bounds.add(offsetVector);
    }

    @NotNull
    public final DoubleRectangle textBounds(@NotNull DoubleRectangle elementRect, @NotNull Margins margins, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)elementRect, (String)"elementRect");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        return orientation.isHorizontal() ? new DoubleRectangle(elementRect.getLeft(), elementRect.getTop() + margins.getTop(), elementRect.getWidth(), elementRect.getHeight() - margins.height()) : new DoubleRectangle(elementRect.getLeft() + margins.getLeft(), elementRect.getTop(), elementRect.getWidth() - margins.width(), elementRect.getHeight());
    }

    @NotNull
    public final DoubleRectangle rotatedLabelBounds(@NotNull DoubleVector labelNormalSize, double degreeAngle) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        double angle = MathKt.toRadians(degreeAngle);
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double w = Math.abs(labelNormalSize.getX() * cos) + Math.abs(labelNormalSize.getY() * sin);
        double h = Math.abs(labelNormalSize.getX() * sin) + Math.abs(labelNormalSize.getY() * cos);
        double x2 = -(Math.abs(labelNormalSize.getX() * cos) + Math.abs(labelNormalSize.getY() * sin));
        double y2 = 0.0;
        return new DoubleRectangle(x2, y2, w, h);
    }

    private final DoubleRectangle verticalAxisLabelsBounds(ScaleBreaks breaks, DoubleSpan axisDomain, Function1<? super Double, Double> axisMapper, LabelSpec tickLabelSpec) {
        Double d;
        Iterator iterator2 = ((Iterable)breaks.getLabels()).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            String p0 = (String)iterator2.next();
            boolean bl = false;
            double d2 = tickLabelSpec.width(p0);
            while (iterator2.hasNext()) {
                String p02 = (String)iterator2.next();
                $i$a$-maxOfOrNull-BreakLabelsLayoutUtil$verticalAxisLabelsBounds$maxLabelWidth$1 = false;
                double d3 = tickLabelSpec.width(p02);
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double maxLabelWidth = d != null ? d : 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (!breaks.isEmpty()) {
            List<Double> axisBreaks = this.mapToAxis(breaks.getTransformedValues(), axisDomain, axisMapper);
            y1 = Math.min(((Number)axisBreaks.get(0)).doubleValue(), ((Number)CollectionsKt.last(axisBreaks)).doubleValue());
            y2 = Math.max(((Number)axisBreaks.get(0)).doubleValue(), ((Number)CollectionsKt.last(axisBreaks)).doubleValue());
            y1 -= tickLabelSpec.height() / (double)2;
            y2 += tickLabelSpec.height() / (double)2;
        }
        DoubleVector origin = new DoubleVector(0.0, y1);
        DoubleVector dimensions = new DoubleVector(maxLabelWidth, y2 - y1);
        return new DoubleRectangle(origin, dimensions);
    }

    public final int estimateBreakCountInitial(double axisLength, @NotNull LabelSpec tickLabelSpec, @Nullable Double rotationAngle, @NotNull Function1<? super DoubleVector, Double> side) {
        Intrinsics.checkNotNullParameter((Object)tickLabelSpec, (String)"tickLabelSpec");
        Intrinsics.checkNotNullParameter(side, (String)"side");
        DoubleVector initialDim = tickLabelSpec.dimensions("0000");
        DoubleVector dimension = rotationAngle != null ? this.rotatedLabelBounds(initialDim, rotationAngle).getDimension() : initialDim;
        return this.estimateBreakCount(((Number)side.invoke((Object)dimension)).doubleValue(), axisLength);
    }

    /*
     * WARNING - void declaration
     */
    public final int estimateBreakCount(@NotNull List<String> labels, double axisLength, @NotNull LabelSpec tickLabelSpec, @Nullable Double rotationAngle, @NotNull Function1<? super DoubleVector, Double> side) {
        Double d;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)tickLabelSpec, (String)"tickLabelSpec");
        Intrinsics.checkNotNullParameter(side, (String)"side");
        Iterable $this$map$iv = labels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(rotationAngle != null ? INSTANCE.rotatedLabelBounds(tickLabelSpec.dimensions((String)label), rotationAngle).getDimension() : tickLabelSpec.dimensions((String)label));
        }
        List dims = (List)destination$iv$iv;
        Iterator iterator2 = ((Iterable)dims).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            double d2 = ((Number)side.invoke(iterator2.next())).doubleValue();
            while (iterator2.hasNext()) {
                double d3 = ((Number)side.invoke(iterator2.next())).doubleValue();
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double longestSide = d != null ? d : 0.0;
        return this.estimateBreakCount(longestSide, axisLength);
    }

    private final int estimateBreakCount(double length, double axisLength) {
        double tickDistance = length + 20.0;
        return (int)Math.max(1.0, axisLength / tickDistance);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

