/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.HorizontalAxisLayouter;
import jetbrains.datalore.plot.builder.layout.axis.VerticalAxisLayouter;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import jetbrains.datalore.plot.builder.layout.util.Insets;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00102\u0006\u0010\r\u001a\u00020\u000eH$J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "domainRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "labelsLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;)V", "getOrientation", "()Ljetbrains/datalore/plot/builder/guide/Orientation;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "axisLength", "", "toAxisMapper", "Lkotlin/Function1;", "toScaleMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "Companion", "plot-builder-portable"})
public abstract class AxisLayouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final DoubleSpan domainRange;
    @NotNull
    private final AxisLabelsLayout labelsLayout;

    public AxisLayouter(@NotNull Orientation orientation, @NotNull DoubleSpan domainRange, @NotNull AxisLabelsLayout labelsLayout) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)domainRange, (String)"domainRange");
        Intrinsics.checkNotNullParameter((Object)labelsLayout, (String)"labelsLayout");
        this.orientation = orientation;
        this.domainRange = domainRange;
        this.labelsLayout = labelsLayout;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisLayoutInfo doLayout(double axisLength) {
        AxisLabelsLayoutInfo labelsInfo = this.labelsLayout.doLayout(axisLength, this.toAxisMapper(axisLength));
        ScaleBreaks scaleBreaks = labelsInfo.getBreaks();
        Intrinsics.checkNotNull((Object)scaleBreaks);
        ScaleBreaks axisBreaks = scaleBreaks;
        DoubleRectangle doubleRectangle = labelsInfo.getBounds();
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle labelsBounds = doubleRectangle;
        return new AxisLayoutInfo(axisLength, this.domainRange, this.orientation, axisBreaks, labelsBounds, labelsInfo.getLabelRotationAngle(), labelsInfo.getLabelHorizontalAnchor(), labelsInfo.getLabelVerticalAnchor(), labelsInfo.getLabelAdditionalOffsets(), BreakLabelsLayoutUtil.INSTANCE.textBounds(labelsBounds, this.labelsLayout.getTheme().tickLabelMargins(), this.orientation), labelsInfo.getLabelBoundsList());
    }

    @NotNull
    protected abstract Function1<Double, Double> toAxisMapper(double var1);

    @NotNull
    protected final ScaleMapper<Double> toScaleMapper(double axisLength) {
        return Mappers.INSTANCE.mul(this.domainRange, axisLength);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter$Companion;", "", "()V", "create", "Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaksProvider", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProvider;", "geomAreaInsets", "Ljetbrains/datalore/plot/builder/layout/util/Insets;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLayouter create(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisBreaksProvider breaksProvider, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (orientation.isHorizontal()) {
                AxisLabelsLayout labelsLayout = breaksProvider.isFixedBreaks() ? AxisLabelsLayout.Companion.horizontalFixedBreaks(orientation, axisDomain, breaksProvider.getFixedBreaks(), geomAreaInsets, theme) : AxisLabelsLayout.Companion.horizontalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
                return new HorizontalAxisLayouter(orientation, axisDomain, labelsLayout);
            }
            AxisLabelsLayout labelsLayout = breaksProvider.isFixedBreaks() ? AxisLabelsLayout.Companion.verticalFixedBreaks(orientation, axisDomain, breaksProvider.getFixedBreaks(), theme) : AxisLabelsLayout.Companion.verticalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
            return new VerticalAxisLayouter(orientation, axisDomain, labelsLayout);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

