/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0003 !\"BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\u0002\u0010\u0010J;\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016J\u0012\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u000fH\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "trim", "", "bandWidth", "", "bandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "n", "", "fullScanMax", "quantiles", "", "(ZLjava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;IILjava/util/List;)V", "Ljava/lang/Double;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "BandWidthMethod", "Companion", "Kernel", "plot-base-portable"})
public final class DensityStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean trim;
    @Nullable
    private final Double bandWidth;
    @NotNull
    private final BandWidthMethod bandWidthMethod;
    private final double adjust;
    @NotNull
    private final Kernel kernel;
    private final int n;
    private final int fullScanMax;
    @NotNull
    private final List<Double> quantiles;
    public static final boolean DEF_TRIM = false;
    @NotNull
    private static final Kernel DEF_KERNEL = Kernel.GAUSSIAN;
    public static final double DEF_ADJUST = 1.0;
    public static final int DEF_N = 512;
    @NotNull
    private static final BandWidthMethod DEF_BW = BandWidthMethod.NRD0;
    public static final int DEF_FULL_SCAN_MAX = 5000;
    @NotNull
    private static final List<Double> DEF_QUANTILES;
    public static final int MAX_N = 1024;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public DensityStat(boolean trim, @Nullable Double bandWidth, @NotNull BandWidthMethod bandWidthMethod, double adjust, @NotNull Kernel kernel2, int n, int fullScanMax, @NotNull List<Double> quantiles) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        Intrinsics.checkNotNullParameter(quantiles, (String)"quantiles");
        super(DEF_MAPPING);
        this.trim = trim;
        this.bandWidth = bandWidth;
        this.bandWidthMethod = bandWidthMethod;
        this.adjust = adjust;
        this.kernel = kernel2;
        this.n = n;
        this.fullScanMax = fullScanMax;
        this.quantiles = quantiles;
        if (!(this.n <= 1024)) {
            boolean bl = false;
            String string = "The input n = " + this.n + " > 1024 is too large!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List xs = null;
        List weights = null;
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            List<List<Double>> filtered = SeriesUtil.INSTANCE.filterFinite(data.getNumeric(TransformVar.INSTANCE.getX()), data.getNumeric(TransformVar.INSTANCE.getWEIGHT()));
            List<Double> xsFiltered = filtered.get(0);
            List<Double> weightsFiltered = filtered.get(1);
            Iterable $this$sortedBy$iv = CollectionsKt.zip((Iterable)xsFiltered, (Iterable)weightsFiltered);
            boolean $i$f$sortedBy = false;
            Pair pair2 = CollectionsKt.unzip((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    Pair it = (Pair)a2;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getFirst()));
                }
            }));
            List xsSorted = (List)pair2.component1();
            List weightsSorted = (List)pair2.component2();
            xs = xsSorted;
            weights = weightsSorted;
        } else {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv22 = CollectionsKt.filterNotNull((Iterable)data.getNumeric(TransformVar.INSTANCE.getX()));
            boolean $i$f$filter22 = false;
            Iterable weightsFiltered = $this$filter$iv22;
            Collection destination$iv$iv = new ArrayList();
            int $i$f$filterTo = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                double d = it;
                boolean bl2 = !Double.isInfinite(d) && !Double.isNaN(d);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            xs = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            int $this$filter$iv22 = xs.size();
            ArrayList<Double> $i$f$filter22 = new ArrayList<Double>($this$filter$iv22);
            int $this$filterTo$iv$iv2 = 0;
            while ($this$filterTo$iv$iv2 < $this$filter$iv22) {
                $i$f$filterTo = destination$iv$iv = $this$filterTo$iv$iv2++;
                ArrayList<Double> arrayList = $i$f$filter22;
                boolean bl = false;
                arrayList.add(1.0);
            }
            weights = $i$f$filter22;
        }
        if (xs.isEmpty()) {
            return this.withEmptyStatValues();
        }
        if (this.trim) {
            FiveNumberSummary xSummary = new FiveNumberSummary(xs);
            doubleSpan = new DoubleSpan(xSummary.getMin(), xSummary.getMax());
        } else {
            doubleSpan = statCtx.overallXRange();
            if (doubleSpan == null) {
                doubleSpan = new DoubleSpan(-0.5, 0.5);
            }
        }
        DoubleSpan rangeX = doubleSpan;
        List<Double> statX = DensityStatUtil.INSTANCE.createStepValues(rangeX, this.n);
        ArrayList<Double> statDensity = new ArrayList<Double>();
        ArrayList<Double> statCount = new ArrayList<Double>();
        ArrayList<Double> statScaled = new ArrayList<Double>();
        Function1<Double, Double> densityFunction = DensityStatUtil.INSTANCE.densityFunction$plot_base_portable(xs, weights, this.bandWidth, this.bandWidthMethod, this.adjust, this.kernel, this.fullScanMax);
        double nTotal = CollectionsKt.sumOfDouble((Iterable)weights);
        Iterator<Double> iterator2 = statX.iterator();
        while (iterator2.hasNext()) {
            double x2 = ((Number)iterator2.next()).doubleValue();
            double d = ((Number)densityFunction.invoke((Object)x2)).doubleValue();
            statCount.add(d);
            statDensity.add(d / nTotal);
        }
        Double d = CollectionsKt.maxOrNull((Iterable)statCount);
        Intrinsics.checkNotNull((Object)d);
        double maxm = d;
        for (Double d2 : statCount) {
            statScaled.add(d2 / maxm);
        }
        List<Double> statQuantile = DensityStatUtil.INSTANCE.calculateStatQuantile$plot_base_portable(statX, (List<Double>)statCount, this.quantiles);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), statX), TuplesKt.to((Object)Stats.INSTANCE.getDENSITY(), statDensity), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), statCount), TuplesKt.to((Object)Stats.INSTANCE.getSCALED(), statScaled), TuplesKt.to((Object)Stats.INSTANCE.getQUANTILE(), statQuantile)};
        Map statData = DensityStatUtil.expandByGroupEnds$plot_base_portable$default(DensityStatUtil.INSTANCE, MapsKt.mapOf((Pair[])pairArray), Stats.INSTANCE.getX(), Stats.INSTANCE.getQUANTILE(), null, 8, null);
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry entry : statData.entrySet()) {
            DataFrame.Variable variable = (DataFrame.Variable)entry.getKey();
            List series = (List)entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    static {
        Object[] objectArray = new Double[]{0.25, 0.5, 0.75};
        DEF_QUANTILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getDENSITY()), TuplesKt.to(Aes.Companion.getQUANTILE(), (Object)Stats.INSTANCE.getQUANTILE())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "", "(Ljava/lang/String;I)V", "GAUSSIAN", "RECTANGULAR", "TRIANGULAR", "BIWEIGHT", "EPANECHNIKOV", "OPTCOSINE", "COSINE", "plot-base-portable"})
    public static final class Kernel
    extends Enum<Kernel> {
        public static final /* enum */ Kernel GAUSSIAN = new Kernel();
        public static final /* enum */ Kernel RECTANGULAR = new Kernel();
        public static final /* enum */ Kernel TRIANGULAR = new Kernel();
        public static final /* enum */ Kernel BIWEIGHT = new Kernel();
        public static final /* enum */ Kernel EPANECHNIKOV = new Kernel();
        public static final /* enum */ Kernel OPTCOSINE = new Kernel();
        public static final /* enum */ Kernel COSINE = new Kernel();
        private static final /* synthetic */ Kernel[] $VALUES;

        public static Kernel[] values() {
            return (Kernel[])$VALUES.clone();
        }

        public static Kernel valueOf(String value) {
            return Enum.valueOf(Kernel.class, value);
        }

        static {
            $VALUES = kernelArray = new Kernel[]{Kernel.GAUSSIAN, Kernel.RECTANGULAR, Kernel.TRIANGULAR, Kernel.BIWEIGHT, Kernel.EPANECHNIKOV, Kernel.OPTCOSINE, Kernel.COSINE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "", "(Ljava/lang/String;I)V", "NRD0", "NRD", "plot-base-portable"})
    public static final class BandWidthMethod
    extends Enum<BandWidthMethod> {
        public static final /* enum */ BandWidthMethod NRD0 = new BandWidthMethod();
        public static final /* enum */ BandWidthMethod NRD = new BandWidthMethod();
        private static final /* synthetic */ BandWidthMethod[] $VALUES;

        public static BandWidthMethod[] values() {
            return (BandWidthMethod[])$VALUES.clone();
        }

        public static BandWidthMethod valueOf(String value) {
            return Enum.valueOf(BandWidthMethod.class, value);
        }

        static {
            $VALUES = bandWidthMethodArray = new BandWidthMethod[]{BandWidthMethod.NRD0, BandWidthMethod.NRD};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Companion;", "", "()V", "DEF_ADJUST", "", "DEF_BW", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "getDEF_BW", "()Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "DEF_FULL_SCAN_MAX", "", "DEF_KERNEL", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "getDEF_KERNEL", "()Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_N", "DEF_QUANTILES", "", "getDEF_QUANTILES", "()Ljava/util/List;", "DEF_TRIM", "", "MAX_N", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Kernel getDEF_KERNEL() {
            return DEF_KERNEL;
        }

        @NotNull
        public final BandWidthMethod getDEF_BW() {
            return DEF_BW;
        }

        @NotNull
        public final List<Double> getDEF_QUANTILES() {
            return DEF_QUANTILES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

