/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.HintsCollection;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\nH\u0002J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/geom/RibbonGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "addTarget", "", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "toLocation", "Lkotlin/Function1;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "colorsByDataPoint", "", "Ljetbrains/datalore/base/values/Color;", "buildHints", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "dataPoints", "", "Companion", "plot-base-portable"})
public final class RibbonGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = true;

    private final Iterable<DataPointAesthetics> dataPoints(Aesthetics aesthetics) {
        Iterable<DataPointAesthetics> data = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getYMIN(), Aes.Companion.getYMAX());
        return GeomUtil.INSTANCE.ordered_X(data);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable<DataPointAesthetics> dataPoints2 = this.dataPoints(aesthetics);
        LinesHelper helper = new LinesHelper(pos, coord, ctx2);
        List paths2 = LinesHelper.createBands$default(helper, dataPoints2, GeomUtil.INSTANCE.getTO_LOCATION_X_YMAX(), GeomUtil.INSTANCE.getTO_LOCATION_X_YMIN(), false, 8, null);
        GeomBase.Companion.appendNodes(paths2, root);
        helper.setAlphaEnabled(false);
        List<LinePath> lines = helper.createLines(dataPoints2, GeomUtil.INSTANCE.getTO_LOCATION_X_YMAX());
        lines.addAll((Collection<LinePath>)helper.createLines(dataPoints2, GeomUtil.INSTANCE.getTO_LOCATION_X_YMIN()));
        GeomBase.Companion.appendNodes(lines, root);
        this.buildHints(aesthetics, pos, coord, ctx2);
    }

    private final void buildHints(Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.RIBBON, ctx2);
        for (DataPointAesthetics p : aesthetics.dataPoints()) {
            this.addTarget(p, ctx2, GeomUtil.INSTANCE.getTO_LOCATION_X_YMAX(), helper, colorsByDataPoint);
        }
    }

    private final void addTarget(DataPointAesthetics p, GeomContext ctx2, Function1<? super DataPointAesthetics, DoubleVector> toLocation, GeomHelper helper, Function1<? super DataPointAesthetics, ? extends List<Color>> colorsByDataPoint) {
        DoubleVector coord = (DoubleVector)toLocation.invoke((Object)p);
        if (coord != null) {
            HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(0.0);
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            HintsCollection.HintConfigFactory hintConfigFactory2 = hintConfigFactory.defaultCoord(d).defaultKind(ctx2.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
            Color color = p.fill();
            Intrinsics.checkNotNull((Object)color);
            HintsCollection.HintConfigFactory hint = hintConfigFactory2.defaultColor(color, null);
            HintsCollection hintsCollection = new HintsCollection(p, helper).addHint(hint.create(Aes.Companion.getYMAX())).addHint(hint.create(Aes.Companion.getYMIN()));
            GeomTargetCollector geomTargetCollector = ctx2.getTargetCollector();
            int n = p.index();
            DoubleVector doubleVector = helper.toClient(coord, p);
            Intrinsics.checkNotNull((Object)doubleVector);
            GeomTargetCollector.DefaultImpls.addPoint$default(geomTargetCollector, n, doubleVector, 0.0, new GeomTargetCollector.TooltipParams(hintsCollection.getHints(), null, null, (List)colorsByDataPoint.invoke((Object)p), 6, null), null, 16, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/geom/RibbonGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

