/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.CompositeFigureBuildInfo;
import jetbrains.datalore.plot.FigureToPlainSvg;
import jetbrains.datalore.plot.PlotFigureBuildInfo;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.builder.FigureBuildInfo;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.CompositeFigureConfig;
import jetbrains.datalore.plot.config.FigKind;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.config.PlotConfigClientSideUtil;
import jetbrains.datalore.plot.server.config.BackendSpecTransformUtil;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import jetbrains.datalore.vis.svgToString.SvgToString;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J?\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J5\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJA\u0010\u001b\u001a\u00020\u00152\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001cJA\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0002\u00a2\u0006\u0002\u0010\"JQ\u0010#\u001a\u00020\u001e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010%JL\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010'\u001a\u00020(2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0!\u0012\u0004\u0012\u00020+0*J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020+H\u0002\u00a8\u00063"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon;", "", "()V", "buildCompositeFigure", "Ljetbrains/datalore/plot/CompositeFigureBuildInfo;", "compositeFigureConfig", "Ljetbrains/datalore/plot/config/CompositeFigureConfig;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "computationMessages", "", "", "buildCompositeFigureFromProcessedSpecs", "plotSpec", "", "plotSize", "plotMaxWidth", "", "plotPreferredWidth", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/plot/CompositeFigureBuildInfo;", "buildGGBunchFromProcessedSpecs", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "bunchSpec", "", "maxWidth", "preferredWidth", "(Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildPlotsFromProcessedSpecs", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildSinglePlot", "Ljetbrains/datalore/plot/PlotFigureBuildInfo;", "config", "Ljetbrains/datalore/plot/config/PlotConfigClientSide;", "", "(Ljetbrains/datalore/plot/config/PlotConfigClientSide;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;Ljava/util/List;)Ljetbrains/datalore/plot/PlotFigureBuildInfo;", "buildSinglePlotFromProcessedSpecs", "compositeFigureComputationMessages", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;Ljava/util/List;)Ljetbrains/datalore/plot/PlotFigureBuildInfo;", "buildSvgImagesFromRawSpecs", "svgToString", "Ljetbrains/datalore/vis/svgToString/SvgToString;", "computationMessagesHandler", "Lkotlin/Function1;", "", "createPlotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "processRawSpecs", "frontendOnly", "", "throwTestingErrors", "PlotsBuildResult", "plot-config-portable"})
public final class MonolithicCommon {
    @NotNull
    public static final MonolithicCommon INSTANCE = new MonolithicCommon();

    private MonolithicCommon() {
    }

    @NotNull
    public final List<String> buildSvgImagesFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @NotNull SvgToString svgToString, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        SvgSvgElement buildInfo;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        FigureBuildInfo it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        Map<String, Object> plotSpec2 = this.processRawSpecs(plotSpec, false);
        PlotsBuildResult buildResult = MonolithicCommon.buildPlotsFromProcessedSpecs$default(this, plotSpec2, plotSize2, null, null, 12, null);
        if (buildResult.isError()) {
            Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Error");
            String errorMessage = ((PlotsBuildResult.Error)buildResult).getError();
            throw new RuntimeException(errorMessage);
        }
        Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Success");
        PlotsBuildResult.Success success2 = (PlotsBuildResult.Success)buildResult;
        Iterable $this$flatMap$iv = success2.getBuildInfos();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FigureBuildInfo)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getComputationMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List computationMessages = (List)destination$iv$iv;
        if (!((Collection)computationMessages).isEmpty()) {
            computationMessagesHandler.invoke((Object)computationMessages);
        }
        Iterable $this$map$iv = success2.getBuildInfos();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (FigureBuildInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FigureToPlainSvg((FigureBuildInfo)((Object)buildInfo)).eval());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            buildInfo = (SvgSvgElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(svgToString.render((SvgSvgElement)((Object)it)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PlotsBuildResult buildPlotsFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @Nullable Double plotPreferredWidth) {
        PlotsBuildResult plotsBuildResult;
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        this.throwTestingErrors();
        DoubleVector doubleVector2 = plotSize2;
        if (doubleVector2 != null) {
            DoubleVector it = doubleVector2;
            boolean bl = false;
            doubleVector = new DoubleVector(Math.max(0.0, it.getX()), Math.max(0.0, it.getY()));
        } else {
            doubleVector = null;
        }
        DoubleVector plotSize3 = doubleVector;
        PlotConfig.Companion.assertFigSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            String errorMessage = PlotConfig.Companion.getErrorMessage(plotSpec);
            return new PlotsBuildResult.Error(errorMessage);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(plotSpec).ordinal()]) {
            case 1: {
                plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)MonolithicCommon.buildSinglePlotFromProcessedSpecs$default(this, plotSpec, plotSize3, plotMaxWidth, plotPreferredWidth, null, 16, null)));
                break;
            }
            case 2: {
                plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)this.buildCompositeFigureFromProcessedSpecs(plotSpec, plotSize3, plotMaxWidth, plotPreferredWidth)));
                break;
            }
            case 3: {
                plotsBuildResult = this.buildGGBunchFromProcessedSpecs(plotSpec, plotMaxWidth, plotPreferredWidth);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return plotsBuildResult;
    }

    public static /* synthetic */ PlotsBuildResult buildPlotsFromProcessedSpecs$default(MonolithicCommon monolithicCommon, Map map2, DoubleVector doubleVector, Double d, Double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        if ((n & 8) != 0) {
            d2 = null;
        }
        return monolithicCommon.buildPlotsFromProcessedSpecs(map2, doubleVector, d, d2);
    }

    private final PlotsBuildResult buildGGBunchFromProcessedSpecs(Map<String, Object> bunchSpec, Double maxWidth, Double preferredWidth) {
        Object object;
        Object scaledSize;
        DoubleVector naturalSize;
        block8: {
            Object object2;
            block7: {
                naturalSize = PlotSizeHelper.INSTANCE.plotBunchSize(bunchSpec);
                object2 = preferredWidth;
                if (object2 == null) break block7;
                double w = ((Number)object2).doubleValue();
                boolean bl = false;
                DoubleVector doubleVector = naturalSize.mul(Math.max(50.0, w) / naturalSize.getX());
                object2 = doubleVector;
                if (doubleVector != null) break block8;
            }
            object2 = scaledSize = naturalSize;
        }
        if (maxWidth != null && maxWidth < ((DoubleVector)scaledSize).getX()) {
            double d = maxWidth;
            object = ((DoubleVector)scaledSize).mul(Math.max(50.0, d) / ((DoubleVector)scaledSize).getX());
        } else {
            object = scaledSize;
        }
        Object neededSize = object;
        double scalingCoef = ((DoubleVector)neededSize).getX() / naturalSize.getX();
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            return new PlotsBuildResult.Error("No plots in the bunch");
        }
        ArrayList<PlotFigureBuildInfo> buildInfos = new ArrayList<PlotFigureBuildInfo>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            Map<String, Object> map2 = bunchItem.getFeatureSpec();
            Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map plotSpec = TypeIntrinsics.asMutableMap(map2);
            DoubleVector itemSize = PlotSizeHelper.INSTANCE.bunchItemSize$plot_config_portable(bunchItem);
            DoubleRectangle itemBounds = new DoubleRectangle(new DoubleVector(bunchItem.getX(), bunchItem.getY()).mul(scalingCoef), itemSize.mul(scalingCoef));
            PlotFigureBuildInfo plotFigureBuildInfo = MonolithicCommon.buildSinglePlotFromProcessedSpecs$default(this, plotSpec, itemSize, null, null, null, 16, null).withBounds(itemBounds);
            buildInfos.add(plotFigureBuildInfo);
        }
        return new PlotsBuildResult.Success((List<? extends FigureBuildInfo>)buildInfos);
    }

    private final PlotFigureBuildInfo buildSinglePlotFromProcessedSpecs(Map<String, ? extends Object> plotSpec, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth, List<String> compositeFigureComputationMessages) {
        List list2;
        PlotConfigClientSide config2;
        block3: {
            ArrayList<String> computationMessages;
            block2: {
                computationMessages = new ArrayList<String>();
                config2 = PlotConfigClientSide.Companion.create(plotSpec, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
                    final /* synthetic */ ArrayList<String> $computationMessages;
                    {
                        this.$computationMessages = $computationMessages;
                        super(1);
                    }

                    public final void invoke(@NotNull List<String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.$computationMessages.addAll((Collection<String>)it);
                    }
                }));
                list2 = compositeFigureComputationMessages;
                if (list2 == null) break block2;
                List it = list2;
                boolean bl = false;
                it.addAll((Collection)computationMessages);
                List list3 = CollectionsKt.emptyList();
                list2 = list3;
                if (list3 != null) break block3;
            }
            list2 = computationMessages;
        }
        List ownComputationMessages = list2;
        return this.buildSinglePlot(config2, plotSize2, plotMaxWidth, plotPreferredWidth, ownComputationMessages);
    }

    static /* synthetic */ PlotFigureBuildInfo buildSinglePlotFromProcessedSpecs$default(MonolithicCommon monolithicCommon, Map map2, DoubleVector doubleVector, Double d, Double d2, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        return monolithicCommon.buildSinglePlotFromProcessedSpecs(map2, doubleVector, d, d2, list2);
    }

    private final PlotFigureBuildInfo buildSinglePlot(PlotConfigClientSide config2, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth, List<String> computationMessages) {
        DoubleVector preferredSize = PlotSizeHelper.INSTANCE.singlePlotSize(config2.toMap(), plotSize2, plotMaxWidth, plotPreferredWidth, config2.getFacets(), config2.getContainsLiveMap());
        PlotAssembler assembler = this.createPlotAssembler(config2);
        return new PlotFigureBuildInfo(assembler, config2.toMap(), new DoubleRectangle(DoubleVector.Companion.getZERO(), preferredSize), computationMessages);
    }

    private final CompositeFigureBuildInfo buildCompositeFigureFromProcessedSpecs(Map<String, ? extends Object> plotSpec, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth) {
        ArrayList<String> computationMessages = new ArrayList<String>();
        CompositeFigureConfig compositeFigureConfig2 = new CompositeFigureConfig(plotSpec, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
            final /* synthetic */ ArrayList<String> $computationMessages;
            {
                this.$computationMessages = $computationMessages;
                super(1);
            }

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$computationMessages.addAll((Collection<String>)it);
            }
        }));
        DoubleVector preferredSize = PlotSizeHelper.INSTANCE.compositeFigureSize(compositeFigureConfig2, plotSize2, plotMaxWidth, plotPreferredWidth);
        return this.buildCompositeFigure(compositeFigureConfig2, preferredSize, (List<String>)computationMessages);
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeFigureBuildInfo buildCompositeFigure(CompositeFigureConfig compositeFigureConfig2, DoubleVector preferredSize, List<String> computationMessages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = compositeFigureConfig2.getElementConfigs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FigureBuildInfo figureBuildInfo;
            void it;
            OptionsAccessor optionsAccessor = (OptionsAccessor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it != null) {
                void it2;
                boolean bl2 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind((OptionsAccessor)it2).ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.config.PlotConfigClientSide");
                        figureBuildInfo = INSTANCE.buildSinglePlot((PlotConfigClientSide)it2, null, null, null, CollectionsKt.emptyList());
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.config.CompositeFigureConfig");
                        CompositeFigureConfig gridOptions = (CompositeFigureConfig)it2;
                        figureBuildInfo = INSTANCE.buildCompositeFigure(gridOptions, DoubleVector.Companion.getZERO(), computationMessages);
                        break;
                    }
                    case 3: {
                        throw new IllegalArgumentException("SubPlots can't contain GGBunch.");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            } else {
                figureBuildInfo = null;
            }
            collection.add(figureBuildInfo);
        }
        List elements = (List)destination$iv$iv;
        return new CompositeFigureBuildInfo(elements, compositeFigureConfig2.createLayout(), new DoubleRectangle(DoubleVector.Companion.getZERO(), preferredSize), computationMessages);
    }

    private final PlotAssembler createPlotAssembler(PlotConfigClientSide config2) {
        return PlotConfigClientSideUtil.INSTANCE.createPlotAssembler(config2);
    }

    private final void throwTestingErrors() {
    }

    @NotNull
    public final Map<String, Object> processRawSpecs(@NotNull Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        PlotConfig.Companion.assertFigSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : BackendSpecTransformUtil.INSTANCE.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigClientSide.Companion.processTransform(plotSpec2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "", "()V", "isError", "", "()Z", "Error", "Success", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "plot-config-portable"})
    public static abstract class PlotsBuildResult {
        private final boolean isError = this instanceof Error;

        private PlotsBuildResult() {
        }

        public final boolean isError() {
            return this.isError;
        }

        public /* synthetic */ PlotsBuildResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "plot-config-portable"})
        public static final class Error
        extends PlotsBuildResult {
            @NotNull
            private final String error;

            public Error(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildInfos", "", "Ljetbrains/datalore/plot/builder/FigureBuildInfo;", "(Ljava/util/List;)V", "getBuildInfos", "()Ljava/util/List;", "plot-config-portable"})
        public static final class Success
        extends PlotsBuildResult {
            @NotNull
            private final List<FigureBuildInfo> buildInfos;

            public Success(@NotNull List<? extends FigureBuildInfo> buildInfos) {
                Intrinsics.checkNotNullParameter(buildInfos, (String)"buildInfos");
                super(null);
                this.buildInfos = buildInfos;
            }

            @NotNull
            public final List<FigureBuildInfo> getBuildInfos() {
                return this.buildInfos;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

