/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.typedGeometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.typedGeometry.ExtensionsKt;
import jetbrains.datalore.base.typedGeometry.LineString;
import jetbrains.datalore.base.typedGeometry.MultiLineString;
import jetbrains.datalore.base.typedGeometry.MultiPolygon;
import jetbrains.datalore.base.typedGeometry.Polygon;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Ring;
import jetbrains.datalore.base.typedGeometry.Vec;
import jetbrains.datalore.base.typedGeometry.VecResampler;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00062 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\rJW\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e2 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010JY\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0011\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u00112 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0013JW\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0014\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\b0\u00142 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0016J[\u0010\u0005\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u0017\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\b0\u00172 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0019Jc\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b0\u001b\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00072\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\u001b2 \u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/base/typedGeometry/Transforms;", "", "()V", "RESAMPLING_PRECISION", "", "transform", "Ljetbrains/datalore/base/typedGeometry/LineString;", "OutT", "InT", "lineString", "Lkotlin/Function1;", "Ljetbrains/datalore/base/typedGeometry/Vec;", "resamplingPrecision", "(Ljetbrains/datalore/base/typedGeometry/LineString;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljetbrains/datalore/base/typedGeometry/LineString;", "Ljetbrains/datalore/base/typedGeometry/MultiLineString;", "multiLineString", "(Ljetbrains/datalore/base/typedGeometry/MultiLineString;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljetbrains/datalore/base/typedGeometry/MultiLineString;", "Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "multiPolygon", "(Ljetbrains/datalore/base/typedGeometry/MultiPolygon;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "Ljetbrains/datalore/base/typedGeometry/Polygon;", "polygon", "(Ljetbrains/datalore/base/typedGeometry/Polygon;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljetbrains/datalore/base/typedGeometry/Polygon;", "Ljetbrains/datalore/base/typedGeometry/Rect;", "bbox", "(Ljetbrains/datalore/base/typedGeometry/Rect;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljetbrains/datalore/base/typedGeometry/Rect;", "transformPoints", "", "path", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;Ljava/lang/Double;)Ljava/util/List;", "base-portable"})
public final class Transforms {
    @NotNull
    public static final Transforms INSTANCE = new Transforms();
    private static final double RESAMPLING_PRECISION = 0.001;

    private Transforms() {
    }

    @Nullable
    public final <InT, OutT> Rect<OutT> transform(@NotNull Rect<InT> bbox2, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        Intrinsics.checkNotNullParameter(bbox2, (String)"bbox");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return this.transform(ExtensionsKt.toPolygon(bbox2), transform2, resamplingPrecision).getBbox();
    }

    public static /* synthetic */ Rect transform$default(Transforms transforms, Rect rect2, Function1 function1, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.001;
        }
        return transforms.transform(rect2, function1, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <InT, OutT> MultiPolygon<OutT> transform(@NotNull MultiPolygon<InT> multiPolygon, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(multiPolygon, (String)"multiPolygon");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Iterable $this$map$iv = (Iterable)((Object)multiPolygon);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Polygon polygon2 = (Polygon)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.transform((Polygon<InT>)it, transform2, resamplingPrecision));
        }
        List list2 = (List)destination$iv$iv;
        return new MultiPolygon(list2);
    }

    public static /* synthetic */ MultiPolygon transform$default(Transforms transforms, MultiPolygon multiPolygon, Function1 function1, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.001;
        }
        return transforms.transform(multiPolygon, function1, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <InT, OutT> Polygon<OutT> transform(@NotNull Polygon<InT> polygon2, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(polygon2, (String)"polygon");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Iterable $this$map$iv = (Iterable)((Object)polygon2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Ring ring = (Ring)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Ring(INSTANCE.transformPoints((List)it, transform2, resamplingPrecision)));
        }
        List list2 = (List)destination$iv$iv;
        return new Polygon(list2);
    }

    @NotNull
    public final <InT, OutT> LineString<OutT> transform(@NotNull LineString<InT> lineString, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return new LineString(this.transformPoints((List)((Object)lineString), transform2, resamplingPrecision));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <InT, OutT> MultiLineString<OutT> transform(@NotNull MultiLineString<InT> multiLineString, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(multiLineString, (String)"multiLineString");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Iterable $this$map$iv = (Iterable)((Object)multiLineString);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LineString lineString = (LineString)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.transform((LineString<InT>)it, transform2, resamplingPrecision));
        }
        List list2 = (List)destination$iv$iv;
        return new MultiLineString(list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <InT, OutT> List<Vec<OutT>> transformPoints(@NotNull List<Vec<InT>> path2, @NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, @Nullable Double resamplingPrecision) {
        List list2;
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        if (resamplingPrecision == null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = path2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                if (transform2.invoke(element$iv$iv) == null) continue;
                boolean bl2 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = new VecResampler<InT, OutT>(transform2, resamplingPrecision).resample(path2);
        }
        return list2;
    }
}

