/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.AbstractLibrary;
import com.github.weisj.darklaf.platform.NativeUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.util.Collections;
import java.util.List;

public class MacOSLibrary
extends AbstractLibrary {
    private static final String PATH = "/com/github/weisj/darklaf/platform/darklaf-macos/";
    private static final String x86_64_PATH = "macos-x86-64/";
    private static final String arm64_PATH = "macos-arm64/";
    private static final String DLL_NAME = "libdarklaf-macos.dylib";
    private static final String FRAMEWORK_TARGET_PATH = "JavaNativeFoundation.framework/";
    private static final String FRAMEWORK_PATH = "/com/github/weisj/darklaf/platform/darklaf-macos/JavaNativeFoundation.framework/JavaNativeFoundation";
    private static final MacOSLibrary instance = new MacOSLibrary();

    public static MacOSLibrary get() {
        return instance;
    }

    protected MacOSLibrary() {
        super(PATH, DLL_NAME, LogUtil.getLogger(MacOSLibrary.class));
    }

    private String getArm64Path() {
        return super.getPath() + arm64_PATH;
    }

    private String getX64Path() {
        return super.getPath() + x86_64_PATH;
    }

    protected String getPath() {
        if (SystemInfo.isX86Compatible && SystemInfo.isX64) {
            return this.getX64Path();
        }
        if (SystemInfo.isM1) {
            return this.getArm64Path();
        }
        throw new IllegalStateException("Unsupported arch");
    }

    protected List<NativeUtil.Resource> getResourcePaths() {
        return Collections.singletonList(new NativeUtil.Resource(FRAMEWORK_PATH, FRAMEWORK_TARGET_PATH));
    }

    protected boolean canLoad() {
        return (SystemInfo.isX86Compatible && SystemInfo.isX64 || SystemInfo.isM1) && SystemInfo.isMacOSYosemite;
    }
}

