/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.repaint;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;
import org.pbjar.jxlayer.repaint.RepaintManagerProvider;
import org.pbjar.jxlayer.repaint.WrappedRepaintManager;

public final class RepaintManagerUtils {
    private RepaintManagerUtils() {
    }

    public static Action createRPDisplayAction() {
        return new DisplayAction();
    }

    private static void ensureImpl(RepaintManager delegate, RepaintManagerProvider provider) {
        RepaintManager manager = delegate;
        while (!provider.isAdequate(manager)) {
            if (manager instanceof WrappedRepaintManager) {
                manager = ((WrappedRepaintManager)manager).getDelegateManager();
                continue;
            }
            RepaintManager.setCurrentManager(provider.createWrappedRepaintManager(delegate));
            break;
        }
    }

    public static void ensureRepaintManagerSet(JComponent c, RepaintManagerProvider provider) {
        RepaintManagerUtils.ensureImpl(RepaintManager.currentManager(c), provider);
    }

    private static class DisplayAction
    extends AbstractAction {
        public DisplayAction() {
            super("RPM tree");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent c = (JComponent)e.getSource();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("The tree for the current RepaintManager:");
            pw.println();
            RepaintManager manager = RepaintManager.currentManager(c);
            this.appendDelegates(pw, manager);
            pw.close();
            String text = sw.toString();
            JTextPane message = new JTextPane();
            message.setFont(Font.decode("Monospaced"));
            message.setContentType("text/plain");
            message.setText(text);
            message.setEditable(false);
            JOptionPane.showMessageDialog(c, message, "The RepaintManager tree", 1);
        }

        private void appendClass(PrintWriter writer, Object obj) {
            String prefix = "Class:   ";
            for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                writer.println(prefix + clazz.getName());
                prefix = "Extends: ";
            }
        }

        private void appendDelegates(PrintWriter writer, Object rp) {
            this.appendClass(writer, rp);
            RepaintManager delegate = rp instanceof WrappedRepaintManager ? ((WrappedRepaintManager)rp).getDelegateManager() : null;
            if (delegate != null) {
                writer.println();
                writer.println("Delegate:");
                this.appendDelegates(writer, delegate);
            }
        }
    }
}

