/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.geom;

import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.geom.RasterData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/geom/Extensions;", "", "()V", "create", "Lorg/jetbrains/letsPlot/geom/RasterData;", "Lorg/jetbrains/letsPlot/geom/RasterData$Companion;", "img", "Ljava/awt/image/BufferedImage;", "plot-api"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();

    private Extensions() {
    }

    @NotNull
    public final RasterData create(@NotNull RasterData.Companion $this$create, @NotNull BufferedImage img) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        int nChannels = img.getColorModel().hasAlpha() ? 4 : 3;
        byte[] byteArrayData = new byte[img.getHeight() * img.getWidth() * nChannels];
        int px = 0;
        int n = img.getHeight();
        for (int j = 0; j < n; ++j) {
            int n2 = img.getWidth();
            for (int i = 0; i < n2; ++i) {
                int rgb = img.getRGB(i, j);
                byte a = (byte)(rgb >> 24 & 0xFF);
                byte r = (byte)(rgb >> 16 & 0xFF);
                byte g = (byte)(rgb >> 8 & 0xFF);
                byte b = (byte)(rgb & 0xFF);
                byteArrayData[px++] = r;
                byteArrayData[px++] = g;
                byteArrayData[px++] = b;
                if (nChannels != 4) continue;
                byteArrayData[px++] = a;
            }
        }
        return RasterData.Companion.create(byteArrayData, img.getWidth(), img.getHeight(), nChannels);
    }
}

