/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTimeUtil;", "", "()V", "DAYS_IN_LEAP_YEAR", "", "getDAYS_IN_LEAP_YEAR$commons", "()I", "DAYS_IN_YEAR", "getDAYS_IN_YEAR$commons", "isLeap", "", "year", "isLeap$commons", "leapYearsBetween", "fromYear", "toYear", "leapYearsBetween$commons", "leapYearsFromZero", "commons"})
public final class DateTimeUtil {
    @NotNull
    public static final DateTimeUtil INSTANCE = new DateTimeUtil();
    private static final int DAYS_IN_YEAR;
    private static final int DAYS_IN_LEAP_YEAR;

    private DateTimeUtil() {
    }

    public final int getDAYS_IN_YEAR$commons() {
        return DAYS_IN_YEAR;
    }

    public final int getDAYS_IN_LEAP_YEAR$commons() {
        return DAYS_IN_LEAP_YEAR;
    }

    public final boolean isLeap$commons(int year) {
        return this.leapYearsFromZero(year) - this.leapYearsFromZero(year - 1) == 1;
    }

    public final int leapYearsBetween$commons(int fromYear, int toYear) {
        if (fromYear > toYear) {
            throw new IllegalArgumentException();
        }
        return this.leapYearsFromZero(toYear - 1) - this.leapYearsFromZero(fromYear - 1);
    }

    private final int leapYearsFromZero(int year) {
        return year / 4 - year / 100 + year / 400;
    }

    static {
        int leapYearDays = 0;
        int yearDays = 0;
        for (Month m : Month.Companion.values()) {
            leapYearDays += m.getDaysInLeapYear();
            yearDays += m.getDays();
        }
        DAYS_IN_YEAR = yearDays;
        DAYS_IN_LEAP_YEAR = leapYearDays;
    }
}

