/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.regression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionEvaluator;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fBC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LinearRegression;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator;", "n", "", "meanX", "", "sumXX", "model", "Lkotlin/Function1;", "standardErrorOfEstimate", "tCritical", "(IDDLkotlin/jvm/functions/Function1;DD)V", "Companion", "plot-base"})
public final class LinearRegression
extends RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LinearRegression(int n, double meanX, double sumXX, Function1<? super Double, Double> model2, double standardErrorOfEstimate, double tCritical) {
        super(n, meanX, sumXX, model2, standardErrorOfEstimate, tCritical);
    }

    public /* synthetic */ LinearRegression(int n, double meanX, double sumXX, Function1 model2, double standardErrorOfEstimate, double tCritical, DefaultConstructorMarker $constructor_marker) {
        this(n, meanX, sumXX, (Function1<? super Double, Double>)model2, standardErrorOfEstimate, tCritical);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LinearRegression$Companion;", "", "()V", "fit", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/LinearRegression;", "xs", "", "", "ys", "confidenceLevel", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LinearRegression fit(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            RegressionEvaluator.Companion.check(xs, ys, confidenceLevel);
            Pair<double[], double[]> pair = RegressionUtilKt.allFinite(xs, ys);
            double[] xVals = (double[])pair.component1();
            double[] yVals = (double[])pair.component2();
            int n = xVals.length;
            double degreesOfFreedom = (double)n - 2.0;
            if (n <= 1) {
                return null;
            }
            double meanX = ArraysKt.average((double[])xVals);
            double sumXX = RegressionUtilKt.sumOfSquaredDeviations(xVals, meanX);
            double meanY = ArraysKt.average((double[])yVals);
            double sumXY = RegressionUtilKt.sumOfDeviationProducts(xVals, yVals, meanX, meanY);
            double slope = sumXY / sumXX;
            double intercept = meanY - slope * meanX;
            Function1 model2 = (Function1)new Function1<Double, Double>(slope, intercept){
                final /* synthetic */ double $slope;
                final /* synthetic */ double $intercept;
                {
                    this.$slope = $slope;
                    this.$intercept = $intercept;
                    super(1);
                }

                @NotNull
                public final Double invoke(double x) {
                    return this.$slope * x + this.$intercept;
                }
            };
            return new LinearRegression(n, meanX, sumXX, model2, RegressionEvaluator.Companion.calcStandardErrorOfEstimate(xVals, yVals, (Function1<? super Double, Double>)model2, degreesOfFreedom), RegressionEvaluator.Companion.calcTCritical(degreesOfFreedom, confidenceLevel), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

