/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.components.tree.LabeledTreeNode;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.ui.cell.CellRenderer;
import com.github.weisj.darklaf.ui.cell.CellToggleButton;
import com.github.weisj.darklaf.ui.cell.ComponentBasedTableCellRenderer;
import com.github.weisj.darklaf.ui.cell.ComponentBasedTreeCellRenderer;
import com.github.weisj.darklaf.ui.cell.DarkCellBorderUIResource;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRendererDelegate;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DarkCellRendererToggleButton<T extends JToggleButton>
implements ComponentBasedTreeCellRenderer,
ComponentBasedTableCellRenderer,
SwingConstants {
    private final T toggleButton;
    private final Icon checkIcon;
    private final Icon checkDisabledIcon;
    private final Icon checkSelectedIcon;
    private final Icon noCheck;
    private final Border border = new DarkCellBorderUIResource();

    public DarkCellRendererToggleButton(T toggleButton) {
        this.toggleButton = toggleButton;
        this.checkIcon = UIManager.getIcon("Check.icon");
        this.checkDisabledIcon = UIManager.getIcon("Check.disabled.icon");
        this.checkSelectedIcon = UIManager.getIcon("Check.selected.icon");
        this.noCheck = UIManager.getIcon("Check.deselected.icon");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean focus, int row, int column) {
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        }
        ((CellToggleButton)this.toggleButton).setHasFocus(focus);
        ((JComponent)this.toggleButton).setBorder(this.border);
        this.updateIcon(table.isCellEditable(row, column), isSelected && DarkUIUtil.hasFocus(table));
        ((AbstractButton)this.toggleButton).setEnabled(table.isEnabled());
        return this.toggleButton;
    }

    public void updateIcon(boolean editable, boolean cellSelected) {
        if (!editable) {
            ((AbstractButton)this.toggleButton).setSelectedIcon(cellSelected ? this.checkSelectedIcon : this.checkIcon);
            ((AbstractButton)this.toggleButton).setDisabledSelectedIcon(this.checkDisabledIcon);
            ((AbstractButton)this.toggleButton).setIcon(this.noCheck);
        } else {
            ((AbstractButton)this.toggleButton).setIcon(null);
            ((AbstractButton)this.toggleButton).setDisabledSelectedIcon(null);
            ((AbstractButton)this.toggleButton).setSelectedIcon(null);
        }
    }

    public T getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        } else {
            this.setValue(value);
            if (value instanceof LabeledTreeNode) {
                ((AbstractButton)this.toggleButton).setText(((LabeledTreeNode)value).getLabel());
            }
        }
        this.updateIcon(tree.isEditable() && tree.isPathEditable(tree.getPathForRow(row)), selected && DarkUIUtil.hasFocus(tree));
        ((AbstractButton)this.toggleButton).setEnabled(tree.isEnabled());
        ((CellToggleButton)this.toggleButton).setHasFocus(false);
        ((AbstractButton)this.toggleButton).setHorizontalAlignment(tree.getComponentOrientation().isLeftToRight() ? 2 : 4);
        return this.toggleButton;
    }

    protected void setValue(Object value) {
        ((AbstractButton)this.toggleButton).setSelected(Boolean.TRUE.equals(DarkTreeCellRendererDelegate.unwrapValue(value)));
    }

    public T getButton() {
        return this.toggleButton;
    }

    @Override
    public JComponent getRendererComponent() {
        return this.getButton();
    }

    public static class CellTristateButton
    extends TristateCheckBox
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellTristateButton(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellRadioButton
    extends JRadioButton
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellRadioButton(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellCheckBox
    extends JCheckBox
    implements CellRenderer,
    CellToggleButton {
        private boolean hasFocus;

        public CellCheckBox(boolean opaque) {
            this.setOpaque(opaque);
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.putClientProperty("JComponent.isTreeEditor", true);
            this.putClientProperty("JComponent.isTableEditor", true);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }
}

