/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.ForsythePolynomialGenerator;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunctionKt;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "deg", "", "(Ljava/util/List;Ljava/util/List;DI)V", "meanX", "n", "p", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "sumXX", "sy", "tcritical", "calcPolynomial", "xVals", "", "yVals", "coefficient", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "Companion", "plot-base-portable"})
public final class PolynomialRegression
extends RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PolynomialFunction p;
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double sy;
    private final double tcritical;

    /*
     * WARNING - void declaration
     */
    public PolynomialRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, int deg) {
        PolynomialRegression $this$_init__u24lambda_u244;
        double d;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        if (!(deg >= 2)) {
            boolean $i$a$-require-PolynomialRegression$32 = false;
            String $i$a$-require-PolynomialRegression$32 = "Degree of polynomial must be at least 2";
            throw new IllegalArgumentException($i$a$-require-PolynomialRegression$32.toString());
        }
        Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        if (!(this.n > deg)) {
            boolean bl = false;
            String string = "The number of valid data points must be greater than deg";
            throw new IllegalArgumentException(string.toString());
        }
        this.p = this.calcPolynomial(deg, xVals, yVals);
        this.meanX = ArraysKt.average((double[])xVals);
        double[] dArray = xVals;
        PolynomialRegression polynomialRegression = this;
        double d2 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it;
            double d3;
            double d4 = d3 = dArray[i];
            d = d2;
            boolean bl = false;
            double d5 = Math.pow((double)(it - this.meanX), 2);
            d2 = d + d5;
        }
        polynomialRegression.sumXX = d = d2;
        double df = (double)(this.n - deg) - 1.0;
        PolynomialRegression polynomialRegression2 = this;
        polynomialRegression = this;
        boolean bl = false;
        Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
        double d6 = 0.0;
        for (Object t : iterable) {
            Pair pair2 = (Pair)t;
            double d7 = d6;
            boolean bl2 = false;
            double x = ((Number)pair2.component1()).doubleValue();
            double y = ((Number)pair2.component2()).doubleValue();
            double d8 = Math.pow(y - $this$_init__u24lambda_u244.p.value(x), 2);
            d6 = d7 + d8;
        }
        double sse = d6;
        d = Math.sqrt(sse / df);
        polynomialRegression.sy = d;
        $this$_init__u24lambda_u244 = this;
        polynomialRegression = this;
        boolean bl3 = false;
        double alpha = 1.0 - confidenceLevel;
        d = new TDistribution(df, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        polynomialRegression.tcritical = d;
    }

    private final PolynomialFunction calcPolynomial(int deg, double[] xVals, double[] yVals) {
        ForsythePolynomialGenerator fpg = new ForsythePolynomialGenerator(xVals);
        double[] dArray = new double[]{0.0};
        PolynomialFunction res = new PolynomialFunction(dArray);
        int i = 0;
        if (i <= deg) {
            while (true) {
                PolynomialFunction p = fpg.getPolynomial(i);
                double s = this.coefficient(p, xVals, yVals);
                res = res.plus(PolynomialFunctionKt.times(s, p));
                if (i == deg) break;
                ++i;
            }
        }
        return res;
    }

    private final double coefficient(PolynomialFunction p, double[] xVals, double[] yVals) {
        double ww = 0.0;
        double w = 0.0;
        int n = xVals.length;
        for (int i = 0; i < n; ++i) {
            double x = xVals[i];
            double y = yVals[i];
            double pval = p.value(x);
            ww += pval * pval;
            w += y * pval;
        }
        return w / ww;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        PolynomialRegression $this$evalX_u24lambda_u246 = this;
        boolean bl = false;
        double dxSquare = Math.pow(x - $this$evalX_u24lambda_u246.meanX, 2);
        double se = $this$evalX_u24lambda_u246.sy * Math.sqrt(1.0 / (double)$this$evalX_u24lambda_u246.n + dxSquare / $this$evalX_u24lambda_u246.sumXX);
        double halfConfidenceInterval = this.tcritical * se;
        double yHat = this.p.value(x);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression$Companion;", "", "()V", "canBeComputed", "", "xs", "", "", "ys", "deg", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeComputed(@NotNull List<Double> xs, @NotNull List<Double> ys, int deg) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            double[] xVals = (double[])RegressionUtilKt.averageByX(xs, ys).component1();
            return xVals.length > deg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

