/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/LinearRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "(Ljava/util/List;Ljava/util/List;D)V", "beta0", "beta1", "meanX", "n", "", "sumXX", "sy", "tcritical", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "value", "plot-base-portable"})
public final class LinearRegression
extends RegressionEvaluator {
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double beta1;
    private final double beta0;
    private final double sy;
    private final double tcritical;

    /*
     * WARNING - void declaration
     */
    public LinearRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel) {
        void $this$_init__u24lambda_u244;
        LinearRegression $this$_init__u24lambda_u243;
        double d;
        double d2;
        double d3;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        Pair<double[], double[]> pair = RegressionUtilKt.allFinite(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        this.meanX = ArraysKt.average((double[])xVals);
        double[] dArray = xVals;
        LinearRegression linearRegression = this;
        double d4 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it22;
            double d5 = d3 = dArray[i];
            d2 = d4;
            boolean bl = false;
            double d6 = Math.pow((double)(it22 - this.meanX), 2);
            d4 = d2 + d6;
        }
        linearRegression.sumXX = d2 = d4;
        double meanY = ArraysKt.average((double[])yVals);
        double[] dArray2 = yVals;
        d3 = 0.0;
        int n2 = dArray2.length;
        for (int it22 = 0; it22 < n2; ++it22) {
            void it;
            double bl;
            double d7 = bl = dArray2[it22];
            double d8 = d3;
            boolean bl2 = false;
            d = Math.pow((double)(it - meanY), 2);
            d3 = d8 + d;
        }
        double sumYY = d3;
        Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
        double it22 = 0.0;
        for (Object t : iterable) {
            Pair pair2 = (Pair)t;
            double d9 = it22;
            boolean bl = false;
            double x = ((Number)pair2.component1()).doubleValue();
            double y = ((Number)pair2.component2()).doubleValue();
            d = (x - this.meanX) * (y - meanY);
            it22 = d9 + d;
        }
        double sumXY = it22;
        this.beta1 = sumXY / this.sumXX;
        this.beta0 = meanY - this.beta1 * this.meanX;
        LinearRegression it22 = this;
        linearRegression = this;
        boolean bl = false;
        double sse = Math.max(0.0, sumYY - sumXY * sumXY / $this$_init__u24lambda_u243.sumXX);
        d2 = Math.sqrt(sse / (double)($this$_init__u24lambda_u243.n - 2));
        linearRegression.sy = d2;
        $this$_init__u24lambda_u243 = this;
        linearRegression = this;
        boolean bl3 = false;
        double alpha = 1.0 - confidenceLevel;
        d2 = new TDistribution((double)$this$_init__u24lambda_u244.n - 2.0, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        linearRegression.tcritical = d2;
    }

    private final double value(double x) {
        return this.beta1 * x + this.beta0;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        LinearRegression $this$evalX_u24lambda_u245 = this;
        boolean bl = false;
        double dxSquare = Math.pow(x - $this$evalX_u24lambda_u245.meanX, 2);
        double se = $this$evalX_u24lambda_u245.sy * Math.sqrt(1.0 / (double)$this$evalX_u24lambda_u245.n + dxSquare / $this$evalX_u24lambda_u245.sumXX);
        double halfConfidenceInterval = this.tcritical * se;
        double yHat = this.value(x);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }
}

