/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.geom.BoxplotGeom;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.PointGeom;
import jetbrains.datalore.plot.base.geom.util.BarTooltipHelper;
import jetbrains.datalore.plot.base.geom.util.CrossBarHelper;
import jetbrains.datalore.plot.base.geom.util.DataPointAestheticsDelegate;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.MappedAesthetics;
import jetbrains.datalore.plot.base.interact.NullGeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0014J(\u00104\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J0\u00107\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00108\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u001a\u0010%\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0006\"\u0004\b'\u0010\b\u00a8\u0006="}, d2={"Ljetbrains/datalore/plot/base/geom/BoxplotGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "outlierColor", "Ljetbrains/datalore/base/values/Color;", "getOutlierColor", "()Ljetbrains/datalore/base/values/Color;", "setOutlierColor", "(Ljetbrains/datalore/base/values/Color;)V", "outlierFill", "getOutlierFill", "setOutlierFill", "outlierShape", "Ljetbrains/datalore/plot/base/render/point/PointShape;", "getOutlierShape", "()Ljetbrains/datalore/plot/base/render/point/PointShape;", "setOutlierShape", "(Ljetbrains/datalore/plot/base/render/point/PointShape;)V", "outlierSize", "getOutlierSize", "()Ljava/lang/Double;", "setOutlierSize", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "outlierStroke", "getOutlierStroke", "setOutlierStroke", "whiskerWidth", "getWhiskerWidth", "setWhiskerWidth", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "buildLines", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "buildOutliers", "getOutliersAesthetics", "toOutlierDataPointAesthetics", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "p", "Companion", "plot-base-portable"})
public final class BoxplotGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidline = 1.0;
    private double whiskerWidth = 0.5;
    @Nullable
    private Color outlierColor;
    @Nullable
    private Color outlierFill;
    @Nullable
    private PointShape outlierShape;
    @Nullable
    private Double outlierSize;
    @Nullable
    private Double outlierStroke;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = CrossBarHelper.INSTANCE.legendFactory(true);
    private static final double OUTLIER_DEF_SIZE = ((Number)AestheticsDefaults.Companion.point().defaultValue(Aes.Companion.getSIZE())).doubleValue();
    private static final double OUTLIER_DEF_STROKE = ((Number)AestheticsDefaults.Companion.point().defaultValue(Aes.Companion.getSTROKE())).doubleValue();

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    public final double getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public final void setWhiskerWidth(double d) {
        this.whiskerWidth = d;
    }

    @Nullable
    public final Color getOutlierColor() {
        return this.outlierColor;
    }

    public final void setOutlierColor(@Nullable Color color) {
        this.outlierColor = color;
    }

    @Nullable
    public final Color getOutlierFill() {
        return this.outlierFill;
    }

    public final void setOutlierFill(@Nullable Color color) {
        this.outlierFill = color;
    }

    @Nullable
    public final PointShape getOutlierShape() {
        return this.outlierShape;
    }

    public final void setOutlierShape(@Nullable PointShape pointShape) {
        this.outlierShape = pointShape;
    }

    @Nullable
    public final Double getOutlierSize() {
        return this.outlierSize;
    }

    public final void setOutlierSize(@Nullable Double d) {
        this.outlierSize = d;
    }

    @Nullable
    public final Double getOutlierStroke() {
        return this.outlierStroke;
    }

    public final void setOutlierStroke(@Nullable Double d) {
        this.outlierStroke = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        CrossBarHelper.INSTANCE.buildBoxes(root, aesthetics, pos, coord, ctx, (Function1<? super DataPointAesthetics, DoubleRectangle>)BoxplotGeom.Companion.clientRectByDataPoint(ctx, geomHelper, false));
        this.buildLines(root, aesthetics, ctx, geomHelper);
        this.buildOutliers(root, aesthetics, pos, coord, ctx);
        Object[] objectArray = new Aes[]{Aes.Companion.getYMAX(), Aes.Companion.getUPPER(), Aes.Companion.getMIDDLE(), Aes.Companion.getLOWER(), Aes.Companion.getYMIN()};
        BarTooltipHelper.collectRectangleTargets$default(BarTooltipHelper.INSTANCE, CollectionsKt.listOf((Object[])objectArray), aesthetics, pos, coord, ctx, BoxplotGeom.Companion.clientRectByDataPoint(ctx, geomHelper, true), buildIntern.1.INSTANCE, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, 128, null);
    }

    private final void buildLines(SvgRoot root, Aesthetics aesthetics, GeomContext ctx, GeomHelper geomHelper) {
        CrossBarHelper.INSTANCE.buildMidlines(root, aesthetics, ctx, geomHelper, this.fattenMidline);
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX())) {
            double fence;
            double hinge;
            double d;
            Double d2 = p.x();
            Intrinsics.checkNotNull((Object)d2);
            double x = d2;
            Double d3 = p.width();
            if (d3 != null) {
                double it = ((Number)d3).doubleValue();
                boolean bl = false;
                d = it * ctx.getResolution(Aes.Companion.getX()) / (double)2;
            } else {
                d = 0.0;
            }
            double halfWidth = d;
            double halfFenceWidth = halfWidth * this.whiskerWidth;
            ArrayList<SvgLineElement> lines = new ArrayList<SvgLineElement>();
            if (p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getYMIN())) {
                Double d4 = p.lower();
                Intrinsics.checkNotNull((Object)d4);
                hinge = d4;
                Double d5 = p.ymin();
                Intrinsics.checkNotNull((Object)d5);
                fence = d5;
                SvgLineElement svgLineElement = elementHelper.createLine(new DoubleVector(x, hinge), new DoubleVector(x, fence), p);
                Intrinsics.checkNotNull((Object)svgLineElement);
                lines.add(svgLineElement);
                SvgLineElement svgLineElement2 = elementHelper.createLine(new DoubleVector(x - halfFenceWidth, fence), new DoubleVector(x + halfFenceWidth, fence), p);
                Intrinsics.checkNotNull((Object)svgLineElement2);
                lines.add(svgLineElement2);
            }
            if (!p.defined(Aes.Companion.getUPPER()) || !p.defined(Aes.Companion.getYMAX())) continue;
            Double d6 = p.upper();
            Intrinsics.checkNotNull((Object)d6);
            hinge = d6;
            Double d7 = p.ymax();
            Intrinsics.checkNotNull((Object)d7);
            fence = d7;
            SvgLineElement svgLineElement = elementHelper.createLine(new DoubleVector(x, hinge), new DoubleVector(x, fence), p);
            Intrinsics.checkNotNull((Object)svgLineElement);
            lines.add(svgLineElement);
            SvgLineElement svgLineElement3 = elementHelper.createLine(new DoubleVector(x - halfFenceWidth, fence), new DoubleVector(x + halfFenceWidth, fence), p);
            Intrinsics.checkNotNull((Object)svgLineElement3);
            lines.add(svgLineElement3);
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement it = (SvgLineElement)element$iv;
                boolean bl = false;
                root.add((SvgNode)it);
            }
        }
    }

    private final void buildOutliers(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        Aesthetics outlierAesthetics = this.getOutliersAesthetics(aesthetics);
        new PointGeom().buildIntern(root, outlierAesthetics, pos, coord, ctx.withTargetCollector(new NullGeomTargetCollector()));
    }

    private final Aesthetics getOutliersAesthetics(Aesthetics aesthetics) {
        return new MappedAesthetics(aesthetics, (Function1<? super DataPointAesthetics, ? extends DataPointAesthetics>)((Function1)new Function1<DataPointAesthetics, DataPointAesthetics>(this){
            final /* synthetic */ BoxplotGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DataPointAesthetics invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return BoxplotGeom.access$toOutlierDataPointAesthetics(this.this$0, p);
            }
        }));
    }

    private final DataPointAesthetics toOutlierDataPointAesthetics(DataPointAesthetics p) {
        if (!p.defined(Aes.Companion.getY())) {
            return p;
        }
        return new DataPointAestheticsDelegate(p, this){
            final /* synthetic */ BoxplotGeom this$0;
            {
                this.this$0 = $receiver;
                super($p);
            }

            @Nullable
            public <T> T get(@NotNull Aes<T> aes) {
                Object object;
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                Aes<T> aes2 = aes;
                if (Intrinsics.areEqual(aes2, Aes.Companion.getCOLOR())) {
                    object = this.this$0.getOutlierColor();
                    if (object == null) {
                        object = (Color)super.get(aes);
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getFILL())) {
                    object = this.this$0.getOutlierFill();
                    if (object == null) {
                        object = (Color)super.get(aes);
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getSHAPE())) {
                    object = this.this$0.getOutlierShape();
                    if (object == null) {
                        object = (PointShape)super.get(aes);
                    }
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getSIZE())) {
                    Double d = this.this$0.getOutlierSize();
                    object = d != null ? d : BoxplotGeom.access$getOUTLIER_DEF_SIZE$cp();
                } else if (Intrinsics.areEqual(aes2, Aes.Companion.getSTROKE())) {
                    Double d = this.this$0.getOutlierStroke();
                    object = d != null ? d : BoxplotGeom.access$getOUTLIER_DEF_STROKE$cp();
                } else {
                    object = Intrinsics.areEqual(aes2, Aes.Companion.getALPHA()) ? Double.valueOf(1.0) : super.get(aes);
                }
                Color value = object;
                return (T)value;
            }
        };
    }

    public static final /* synthetic */ DataPointAesthetics access$toOutlierDataPointAesthetics(BoxplotGeom $this, DataPointAesthetics p) {
        return $this.toOutlierDataPointAesthetics(p);
    }

    public static final /* synthetic */ double access$getOUTLIER_DEF_SIZE$cp() {
        return OUTLIER_DEF_SIZE;
    }

    public static final /* synthetic */ double access$getOUTLIER_DEF_STROKE$cp() {
        return OUTLIER_DEF_STROKE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/geom/BoxplotGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "OUTLIER_DEF_SIZE", "", "OUTLIER_DEF_STROKE", "clientRectByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "isHintRect", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx, GeomHelper geomHelper, boolean isHintRect) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx, geomHelper, isHintRect){
                final /* synthetic */ GeomContext $ctx;
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ boolean $isHintRect;
                {
                    this.$ctx = $ctx;
                    this.$geomHelper = $geomHelper;
                    this.$isHintRect = $isHintRect;
                    super(1);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (p.defined(Aes.Companion.getX()) && p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getUPPER()) && p.defined(Aes.Companion.getWIDTH())) {
                        Double d = p.x();
                        Intrinsics.checkNotNull((Object)d);
                        double x = d;
                        Double d2 = p.lower();
                        Intrinsics.checkNotNull((Object)d2);
                        double lower = d2;
                        Double d3 = p.upper();
                        Intrinsics.checkNotNull((Object)d3);
                        double upper = d3;
                        Double d4 = p.width();
                        Intrinsics.checkNotNull((Object)d4);
                        double width2 = d4 * this.$ctx.getResolution(Aes.Companion.getX());
                        DoubleRectangle doubleRectangle2 = this.$geomHelper.toClient(DoubleRectangle.Companion.XYWH((Number)(x - width2 / (double)2), (Number)lower, (Number)width2, (Number)(upper - lower)), p);
                        if (doubleRectangle2 != null) {
                            DoubleRectangle doubleRectangle3 = doubleRectangle2;
                            boolean bl = this.$isHintRect;
                            GeomContext geomContext = this.$ctx;
                            DoubleRectangle it = doubleRectangle3;
                            boolean bl2 = false;
                            doubleRectangle = bl && upper == lower ? GeomUtil.INSTANCE.extendHeight$plot_base_portable(it, 2.0, geomContext.getFlipped()) : it;
                        } else {
                            doubleRectangle = null;
                        }
                    } else {
                        doubleRectangle = null;
                    }
                    DoubleRectangle clientRect = doubleRectangle;
                    return clientRect;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

