/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.util.Insets;
import jetbrains.datalore.plot.builder.scale.AxisPosition;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/layout/SingleTilePlotLayout;", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "tileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "hAxisPosition", "Ljetbrains/datalore/plot/builder/scale/AxisPosition;", "vAxisPosition", "hAxisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "vAxisTheme", "(Ljetbrains/datalore/plot/builder/layout/TileLayout;Ljetbrains/datalore/plot/builder/scale/AxisPosition;Ljetbrains/datalore/plot/builder/scale/AxisPosition;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "insets", "Ljetbrains/datalore/plot/builder/layout/util/Insets;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "layoutByGeomSize", "geomSize", "layoutOuterSize", "outerSize", "tileInfoToPlotInfo", "tileInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "plot-builder-portable"})
public final class SingleTilePlotLayout
implements PlotLayout {
    @NotNull
    private final TileLayout tileLayout;
    @NotNull
    private final Insets insets;

    public SingleTilePlotLayout(@NotNull TileLayout tileLayout, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        this.tileLayout = tileLayout;
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets(hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
    }

    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        return this.tileLayout.getInsideOut() ? this.layoutByGeomSize(preferredSize, coordProvider) : this.layoutOuterSize(preferredSize, coordProvider);
    }

    private final PlotLayoutInfo layoutOuterSize(DoubleVector outerSize, CoordProvider coordProvider) {
        DoubleVector tilePreferredSize = outerSize.subtract(this.insets.getLeftTop()).subtract(this.insets.getRightBottom());
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(tilePreferredSize, coordProvider).withOffset(this.insets.getLeftTop());
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo layoutByGeomSize(DoubleVector geomSize, CoordProvider coordProvider) {
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(geomSize, coordProvider).withOffset(this.insets.getLeftTop()).withNormalizedOrigin();
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo tileInfoToPlotInfo(TileLayoutInfo tileInfo) {
        return new PlotLayoutInfo(CollectionsKt.listOf((Object)tileInfo), this.insets);
    }
}

