/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.spatial.projections.Projection;
import jetbrains.datalore.base.spatial.projections.ProjectionsKt;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.coord.CoordinatesMapper;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "xLim", "Ljetbrains/datalore/base/interval/DoubleSpan;", "yLim", "flipped", "", "projection", "Ljetbrains/datalore/base/spatial/projections/Projection;", "(Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/base/interval/DoubleSpan;ZLjetbrains/datalore/base/spatial/projections/Projection;)V", "getFlipped", "()Z", "getProjection", "()Ljetbrains/datalore/base/spatial/projections/Projection;", "adjustDomain", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "domain", "createCoordinateMapper", "Ljetbrains/datalore/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-builder-portable"})
public abstract class CoordProviderBase
implements CoordProvider {
    @Nullable
    private final DoubleSpan xLim;
    @Nullable
    private final DoubleSpan yLim;
    private final boolean flipped;
    @NotNull
    private final Projection projection;

    public CoordProviderBase(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped, @NotNull Projection projection) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.xLim = xLim;
        this.yLim = yLim;
        this.flipped = flipped;
        this.projection = projection;
        if (!(this.xLim == null || this.xLim.getLength() > 0.0)) {
            boolean $i$a$-require-CoordProviderBase$32 = false;
            String $i$a$-require-CoordProviderBase$32 = "Coord x-limits range should be > 0.0";
            throw new IllegalArgumentException($i$a$-require-CoordProviderBase$32.toString());
        }
        if (!(this.yLim == null || this.yLim.getLength() > 0.0)) {
            boolean bl = false;
            String string = "Coord y-limits range should be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CoordProviderBase(DoubleSpan doubleSpan, DoubleSpan doubleSpan2, boolean bl, Projection projection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            projection = ProjectionsKt.identity();
        }
        this(doubleSpan, doubleSpan2, bl, projection);
    }

    @Override
    public boolean getFlipped() {
        return this.flipped;
    }

    @NotNull
    protected final Projection getProjection() {
        return this.projection;
    }

    @Override
    @NotNull
    public final DoubleRectangle adjustDomain(@NotNull DoubleRectangle domain) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        DoubleRectangle it = domain;
        boolean bl = false;
        DoubleSpan doubleSpan2 = this.xLim;
        if (doubleSpan2 == null) {
            doubleSpan2 = domain.xRange();
        }
        if ((doubleSpan = this.yLim) == null) {
            doubleSpan = domain.yRange();
        }
        DoubleRectangle withLims = new DoubleRectangle(doubleSpan2, doubleSpan);
        DoubleRectangle validDomain = this.projection.validDomain().intersect(withLims);
        if (validDomain != null && validDomain.getHeight() > 0.0 && validDomain.getWidth() > 0.0) {
        } else {
            throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("Can't create a valid domain.\n                |  data bbox: " + domain + "\n                |  x-lim: " + this.xLim + "\n                |  y-lim: " + this.yLim + "\n            "), null, (int)1, null));
        }
        return this.getFlipped() ? validDomain.flip() : validDomain;
    }

    @Override
    @NotNull
    public final CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        return CoordinatesMapper.Companion.create(adjustedDomain, clientSize, this.projection, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordinateSystem createCoordinateSystem(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        return CoordProvider.DefaultImpls.createCoordinateSystem(this, adjustedDomain, clientSize);
    }
}

