/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.typedGeometry.ExtensionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Vec;
import jetbrains.datalore.base.typedGeometry.VecKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u00010\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0006\u00a8\u0006\u0007"}, d2={"wrapPath", "", "Ljetbrains/datalore/base/typedGeometry/Vec;", "TypeT", "path", "domain", "Ljetbrains/datalore/base/typedGeometry/Rect;", "base-portable"})
public final class WrappingKt {
    @NotNull
    public static final <TypeT> List<List<Vec<TypeT>>> wrapPath(@NotNull List<Vec<TypeT>> path, @NotNull Rect<TypeT> domain) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        if (path.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList splitPath = new ArrayList();
        ArrayList<Vec<TypeT>> currentPath = new ArrayList<Vec<TypeT>>();
        currentPath.add(path.get(0));
        int n = path.size();
        for (int i = 1; i < n; ++i) {
            Vec<TypeT> p1 = path.get(i - 1);
            Vec<TypeT> p2 = path.get(i);
            if (Math.abs(p2.getX() - p1.getX()) > domain.getDimension().getX() / (double)2) {
                double xa = 0.0;
                double xb = 0.0;
                double y2 = 0.0;
                if (p1.getX() < p2.getX()) {
                    y2 = WrappingKt.wrapPath$yOnLine(p1, Vec.copy$default(p2, p2.getX() - ExtensionsKt.getWidth(domain), 0.0, 2, null), ExtensionsKt.getLeft(domain));
                    xa = ExtensionsKt.getLeft(domain);
                    xb = ExtensionsKt.getRight(domain);
                } else {
                    y2 = WrappingKt.wrapPath$yOnLine(p1, Vec.copy$default(p2, p2.getX() + ExtensionsKt.getWidth(domain), 0.0, 2, null), ExtensionsKt.getRight(domain));
                    xa = ExtensionsKt.getRight(domain);
                    xb = ExtensionsKt.getLeft(domain);
                }
                currentPath.add(VecKt.explicitVec(xa, y2));
                splitPath.add(currentPath);
                currentPath = new ArrayList();
                currentPath.add(VecKt.explicitVec(xb, y2));
            }
            currentPath.add(p2);
        }
        splitPath.add(currentPath);
        return splitPath;
    }

    private static final <TypeT> double wrapPath$yOnLine(Vec<TypeT> p1, Vec<TypeT> p2, double x2) {
        double m = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        double b = p2.getY() - m * p2.getX();
        return m * x2 + b;
    }
}

