/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import org.apache.jorphan.reflect.ServiceLoadExceptionHandler;
import org.slf4j.Logger;

public class LogAndIgnoreServiceLoadExceptionHandler
implements ServiceLoadExceptionHandler<Object> {
    private final Logger log;

    public LogAndIgnoreServiceLoadExceptionHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void handle(Class<?> service, String className, Throwable throwable) {
        if (throwable instanceof NoClassDefFoundError) {
            if (throwable.getMessage().contains("javafx")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to load class {} for interface {}. The class depends on JavaFX which is missing in the current JVM. Use JVM distribution with JavaFX, or add it as a library for the class to work", new Object[]{className, service, throwable});
                } else {
                    this.log.info("Class {} depends on JavaFX which is missing in the current JVM. Use JVM distribution with JavaFX, or add it as a library for the class to work", (Object)className);
                }
            } else {
                this.log.error("Exception registering implementation: [{}] of interface: [{}], a dependency used by the plugin class is missing", new Object[]{className, service, throwable});
            }
        } else {
            this.log.error("Exception registering implementation: [{}] of interface: [{}], a jar is probably missing", new Object[]{className, service, throwable});
        }
    }
}

