/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J&\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPLTE;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "entries", "", "nentries", "", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getEntry", "n", "getEntryRgb", "", "rgb", "offset", "getNentries", "minBitDepth", "parseFromRaw", "chunk", "setEntry", "r", "g", "b", "setNentries", "Companion", "plot-api"})
public final class PngChunkPLTE
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int nentries;
    @Nullable
    private int[] entries;
    @NotNull
    public static final String ID = "PLTE";

    public PngChunkPLTE(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        int len = 3 * this.nentries;
        int[] rgb = new int[3];
        ChunkRaw c = this.createEmptyChunk(len, true);
        int i = 0;
        for (int n = 0; n < this.nentries; ++n) {
            this.getEntryRgb(n, rgb);
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            byArray[i++] = (byte)rgb[0];
            byte[] byArray2 = c.getData();
            Intrinsics.checkNotNull((Object)byArray2);
            byArray2[i++] = (byte)rgb[1];
            byte[] byArray3 = c.getData();
            Intrinsics.checkNotNull((Object)byArray3);
            byArray3[i++] = (byte)rgb[2];
        }
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.setNentries(chunk.getLen() / 3);
        int i = 0;
        for (int n = 0; n < this.nentries; ++n) {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            int n2 = byArray[i++] & 0xFF;
            byte[] byArray2 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray2);
            int n3 = byArray2[i++] & 0xFF;
            byte[] byArray3 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray3);
            this.setEntry(n, n2, n3, byArray3[i++] & 0xFF);
        }
    }

    public final void setNentries(int n) {
        block5: {
            block4: {
                this.nentries = n;
                if (this.nentries < 1 || this.nentries > 256) {
                    throw new PngjException("invalid pallette - nentries=" + this.nentries);
                }
                if (this.entries == null) break block4;
                Intrinsics.checkNotNull((Object)this.entries);
                if (this.entries.length == this.nentries) break block5;
            }
            this.entries = new int[this.nentries];
        }
    }

    public final int getNentries() {
        return this.nentries;
    }

    public final void setEntry(int n, int r, int g, int b) {
        Intrinsics.checkNotNull((Object)this.entries);
        this.entries[n] = r << 16 | g << 8 | b;
    }

    public final int getEntry(int n) {
        Intrinsics.checkNotNull((Object)this.entries);
        return this.entries[n];
    }

    private final void getEntryRgb(int n, int[] rgb) {
        this.getEntryRgb(n, rgb, 0);
    }

    public final void getEntryRgb(int n, @NotNull int[] rgb, int offset) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNull((Object)this.entries);
        int v = this.entries[n];
        rgb[offset + 0] = (v & 0xFF0000) >> 16;
        rgb[offset + 1] = (v & 0xFF00) >> 8;
        rgb[offset + 2] = v & 0xFF;
    }

    public final int minBitDepth() {
        return this.nentries <= 2 ? 1 : (this.nentries <= 4 ? 2 : (this.nentries <= 16 ? 4 : 8));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPLTE$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

