/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkCopyBehaviour;", "", "()V", "COPY_ALL", "", "COPY_ALL_SAFE", "COPY_ALMOSTALL", "COPY_NONE", "COPY_PALETTE", "COPY_PHYS", "COPY_TEXTUAL", "COPY_TRANSPARENCY", "COPY_UNKNOWN", "createPredicate", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkPredicate;", "copyFromMask", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "maskMatch", "", "v", "mask", "plot-api"})
public final class ChunkCopyBehaviour {
    @NotNull
    public static final ChunkCopyBehaviour INSTANCE = new ChunkCopyBehaviour();
    public static final int COPY_NONE = 0;
    public static final int COPY_PALETTE = 1;
    public static final int COPY_ALL_SAFE = 4;
    public static final int COPY_ALL = 8;
    public static final int COPY_PHYS = 16;
    public static final int COPY_TEXTUAL = 32;
    public static final int COPY_TRANSPARENCY = 64;
    public static final int COPY_UNKNOWN = 128;
    public static final int COPY_ALMOSTALL = 256;

    private ChunkCopyBehaviour() {
    }

    private final boolean maskMatch(int v, int mask) {
        return (v & mask) != 0;
    }

    @NotNull
    public final ChunkPredicate createPredicate(int copyFromMask, @NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        return new ChunkPredicate(imgInfo, copyFromMask){
            final /* synthetic */ ImageInfo $imgInfo;
            final /* synthetic */ int $copyFromMask;
            {
                this.$imgInfo = $imgInfo;
                this.$copyFromMask = $copyFromMask;
            }

            public boolean match(@NotNull PngChunk chunk) {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                if (chunk.getCrit()) {
                    if (Intrinsics.areEqual((Object)chunk.getId(), (Object)"PLTE")) {
                        if (this.$imgInfo.getIndexed() && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 1)) {
                            return true;
                        }
                        if (!this.$imgInfo.getGreyscale() && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 8)) {
                            return true;
                        }
                    }
                } else {
                    boolean text2 = chunk instanceof PngChunkTextVar;
                    boolean safe = chunk.getSafe();
                    if (ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 8)) {
                        return true;
                    }
                    if (safe && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 4)) {
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)chunk.getId(), (Object)"tRNS") && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 64)) {
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)chunk.getId(), (Object)"pHYs") && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 16)) {
                        return true;
                    }
                    if (text2 && ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 32)) {
                        return true;
                    }
                    if (!(!ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 256) || ChunkHelper.INSTANCE.isUnknown(chunk) || text2 || Intrinsics.areEqual((Object)chunk.getId(), (Object)"hIST") || Intrinsics.areEqual((Object)chunk.getId(), (Object)"tIME"))) {
                        return true;
                    }
                    if (ChunkCopyBehaviour.access$maskMatch(ChunkCopyBehaviour.INSTANCE, this.$copyFromMask, 128) && ChunkHelper.INSTANCE.isUnknown(chunk)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static final /* synthetic */ boolean access$maskMatch(ChunkCopyBehaviour $this, int v, int mask) {
        return $this.maskMatch(v, mask);
    }
}

