/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.slider;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.icons.RotatableIcon;
import com.github.weisj.darklaf.swingdsl.VisualPaddingUtil;
import com.github.weisj.darklaf.ui.slider.DarkSliderListener;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class DarkSliderUI
extends BasicSliderUI {
    protected static final String KEY_PREFIX = "JSlider.";
    public static final String KEY_THUMB_ARROW_SHAPE = "JSlider.paintThumbArrowShape";
    public static final String KEY_SHOW_VOLUME_ICON = "JSlider.volume.showIcon";
    public static final String KEY_VARIANT = "JSlider.variant";
    public static final String KEY_INSTANT_SCROLL = "JSlider.instantScrollEnabled";
    public static final String KEY_MANUAL_LABEL_ALIGN = "JSlider.manualLabelAlign";
    public static final String KEY_USE_TRACK_AS_BASELINE = "JSlider.useTrackAsBaseline";
    public static final String VARIANT_VOLUME = "volume";
    protected final Rectangle iconRect = new Rectangle(0, 0, 0, 0);
    private DarkSliderListener sliderListener;
    protected int plainThumbRadius;
    protected int arcSize;
    protected int trackSize;
    protected int iconPad;
    protected Dimension thumbSize;
    protected Color inactiveTickForeground;
    protected Color trackBackground;
    protected Color selectedTrackBackground;
    protected Color selectedTrackInactiveBackground;
    protected Color selectedVolumeTrackBackground;
    protected Color selectedVolumeTrackInactiveBackground;
    protected Color thumbBackground;
    protected Color thumbInactiveBackground;
    protected Color volumeThumbBackground;
    protected Color volumeThumbInactiveBackground;
    protected Color thumbBorderColor;
    protected Color thumbFocusBorderColor;
    protected Color thumbInactiveBorderColor;
    protected RotatableIcon rotatableIcon;
    protected Icon thumb;
    protected Icon thumbDisabled;
    protected Icon thumbFocused;
    protected Icon volumeThumb;
    protected Icon volumeThumbDisabled;
    protected Icon volumeThumbFocused;
    protected Icon volume0;
    protected Icon volume1;
    protected Icon volume2;
    protected Icon volume3;
    protected Icon volume4;
    protected Icon volume0Inactive;
    protected Icon volume1Inactive;
    protected Icon volume2Inactive;
    protected Icon volume3Inactive;
    protected Icon volume4Inactive;
    protected int focusBorderSize;
    protected boolean paintFocus;
    protected RoundRectangle2D trackShape = new RoundRectangle2D.Double();

    public DarkSliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkSliderUI((JSlider)c);
    }

    protected boolean showVolumeIcon(JComponent c) {
        return PropertyUtil.getBooleanProperty((JComponent)c, (String)KEY_SHOW_VOLUME_ICON);
    }

    protected boolean isVolumeSlider(JComponent c) {
        return PropertyUtil.isPropertyEqual((JComponent)c, (String)KEY_VARIANT, (Object)VARIANT_VOLUME);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateVisualPaddings();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new SnapTrackListener();
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        if (this.sliderListener == null) {
            this.sliderListener = this.createSliderListener();
        }
        slider.addMouseListener(this.sliderListener);
        slider.addMouseWheelListener(this.sliderListener);
        slider.addPropertyChangeListener(this.sliderListener);
    }

    protected DarkSliderListener createSliderListener() {
        return new DarkSliderListener(this, this.slider);
    }

    protected void updateVisualPaddings() {
        this.calculateGeometry();
        Rectangle r = new Rectangle(this.contentRect);
        Insets ins = new Insets(r.y, r.x, this.slider.getHeight() - (r.y + r.height), this.slider.getWidth() - (r.x + r.width));
        VisualPaddingUtil.updateProperty(this.slider, ins);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.sliderListener);
        slider.removeMouseWheelListener(this.sliderListener);
        slider.removePropertyChangeListener(this.sliderListener);
        this.sliderListener = null;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        if (this.isHorizontal() && PropertyUtil.getBooleanProperty((JComponent)c, (String)KEY_USE_TRACK_AS_BASELINE)) {
            int thumbY = this.focusInsets.top + this.trackBuffer;
            if (this.isPlainThumb()) {
                Dimension thumbSize = this.getThumbSize();
                return thumbY + thumbSize.height - this.focusBorderSize;
            }
            Icon icon = this.getThumbIcon();
            int baseline = thumbY + icon.getIconHeight();
            if (icon instanceof RotatableIcon) {
                icon = ((RotatableIcon)icon).getIcon();
            }
            if (icon instanceof VisualPaddingProvider) {
                baseline -= ((VisualPaddingProvider)icon).getVisualPaddings((Component)this.slider).bottom;
            }
            return baseline;
        }
        return super.getBaseline(c, width, height);
    }

    @Override
    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateThumbSize();
        this.calculateContentRect();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
        if (this.showVolumeIcon(this.slider)) {
            this.calculateIconRect();
        } else {
            this.iconRect.setBounds(-1, -1, 0, 0);
        }
    }

    @Override
    protected void calculateFocusRect() {
        this.focusRect.setRect(0.0, 0.0, this.slider.getWidth(), this.slider.getHeight());
        DarkUIUtil.applyInsets(this.focusRect, this.focusInsets);
    }

    @Override
    protected void calculateContentRect() {
        boolean horizontal;
        this.contentRect.setRect(this.focusRect);
        boolean bl = horizontal = this.slider.getOrientation() == 0;
        if (this.showVolumeIcon(this.slider)) {
            if (horizontal) {
                this.contentRect.width -= this.getVolumeIcon().getIconWidth() + this.iconPad;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    this.contentRect.x += this.getVolumeIcon().getIconWidth() + this.iconPad;
                }
            } else {
                this.contentRect.height -= this.getVolumeIcon().getIconHeight() + this.iconPad;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    this.contentRect.y += this.getVolumeIcon().getIconHeight() + this.iconPad;
                }
            }
        }
        if (horizontal) {
            int thumbWidth = this.getThumbWidth();
            this.contentRect.x += thumbWidth / 2;
            this.contentRect.width -= thumbWidth;
        } else {
            int thumbHeight = this.getThumbHeight();
            this.contentRect.y += thumbHeight / 2;
            this.contentRect.height -= thumbHeight;
        }
        this.adjustRect(this.contentRect);
    }

    @Override
    protected void calculateTrackBuffer() {
        this.trackBuffer = 0;
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
    }

    @Override
    protected void calculateThumbLocation() {
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    @Override
    public int xPositionForValue(int value) {
        return super.xPositionForValue(value);
    }

    @Override
    public int yPositionForValue(int value) {
        return super.yPositionForValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement == 0) {
                blockIncrement = 1;
            }
            int tickSpacing = this.getTickSpacing();
            if (this.slider.getSnapToTicks()) {
                if (blockIncrement < tickSpacing) {
                    blockIncrement = tickSpacing;
                }
            } else if (tickSpacing > 0) {
                blockIncrement = tickSpacing;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.applyDelta(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta;
            int n = delta = direction > 0 ? 1 : -1;
            if (this.slider.getSnapToTicks()) {
                delta *= this.getTickSpacing();
            }
            this.applyDelta(delta);
        }
    }

    protected void applyDelta(int delta) {
        this.setValue(this.slider.getValue() + delta, true);
    }

    protected void setValue(int value, boolean snapIfNeeded) {
        this.slider.setValue(snapIfNeeded ? this.maybeSnapValue(value) : value);
    }

    protected int maybeSnapValue(int value) {
        if (this.slider.getSnapToTicks()) {
            return this.getSnappedValue(value);
        }
        return value;
    }

    @Override
    public int valueForXPosition(int xPos) {
        return this.maybeSnapValue(super.valueForXPosition(xPos));
    }

    @Override
    public int valueForYPosition(int yPos) {
        return this.maybeSnapValue(super.valueForYPosition(yPos));
    }

    protected int getTickSpacing() {
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int result = minorTickSpacing > 0 ? minorTickSpacing : Math.max(majorTickSpacing, 0);
        return result;
    }

    protected void adjustRect(Rectangle rectangle) {
        this.adjustRect(rectangle, false);
    }

    protected void adjustRect(Rectangle rectangle, boolean outwards) {
        boolean horizontal = this.slider.getOrientation() == 0;
        Dictionary dict = this.slider.getLabelTable();
        if (!this.slider.getPaintLabels() || dict == null || dict.isEmpty() || !horizontal) {
            return;
        }
        int extra = this.getLowerHorizontalExtend();
        int extend = this.getUpperHorizontalExtend();
        int factor = outwards ? 1 : -1;
        rectangle.x -= factor * extra;
        rectangle.width += factor * (extra + extend);
    }

    protected int getLowerHorizontalExtend() {
        boolean ltr = !this.drawInverted();
        Component minLabel = ltr ? this.getLowestValueLabel() : this.getHighestValueLabel();
        boolean adjustMin = PropertyUtil.getBooleanProperty((Component)minLabel, (String)KEY_MANUAL_LABEL_ALIGN);
        int minPrefWidth = minLabel.getPreferredSize().width;
        float adj = adjustMin ? minLabel.getAlignmentX() : 0.5f;
        return (int)((float)minPrefWidth * adj);
    }

    protected int getUpperHorizontalExtend() {
        boolean ltr = !this.drawInverted();
        Component maxLabel = ltr ? this.getHighestValueLabel() : this.getLowestValueLabel();
        boolean adjustMax = PropertyUtil.getBooleanProperty((Component)maxLabel, (String)KEY_MANUAL_LABEL_ALIGN);
        int maxPrefWidth = maxLabel.getPreferredSize().width;
        float adj = adjustMax ? maxLabel.getAlignmentX() : 0.5f;
        return (int)((float)maxPrefWidth * (1.0f - adj));
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        Dimension dim = super.getPreferredHorizontalSize();
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        rect.setSize(dim);
        this.adjustRect(rect, true);
        Dictionary dict = this.slider.getLabelTable();
        if (dict != null && !dict.isEmpty()) {
            int totalLabelWidth = 0;
            Enumeration labels = dict.elements();
            while (labels.hasMoreElements()) {
                Object obj = labels.nextElement();
                if (!(obj instanceof Component)) continue;
                totalLabelWidth += ((Component)obj).getPreferredSize().width;
            }
            rect.width = Math.max(rect.width, totalLabelWidth += this.getThumbWidth());
        }
        return rect.getSize();
    }

    @Override
    public Dimension getThumbSize() {
        if (this.isPlainThumb()) {
            int bw = 2 * this.getFocusBorderSize();
            return new Dimension(this.plainThumbRadius + bw, this.plainThumbRadius + bw);
        }
        return this.isHorizontal() ? new Dimension(this.thumbSize.width, this.thumbSize.height) : new Dimension(this.thumbSize.height, this.thumbSize.width);
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
        if (this.showVolumeIcon(c)) {
            this.getVolumeIcon().paintIcon(c, g2, this.iconRect.x, this.iconRect.y);
        }
    }

    @Override
    public void paintFocus(Graphics g2) {
    }

    @Override
    public void paintTrack(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        GraphicsContext config = GraphicsUtil.setupStrokePainting((Graphics)g);
        Color bgColor = this.getTrackBackground();
        Color selectionColor = this.getSelectedTrackColor();
        if (this.isHorizontal()) {
            Shape track = this.getHorizontalTrackShape(this.trackShape);
            g.setColor(bgColor);
            g.fill(track);
            this.setHorizontalTrackClip(g);
            g.setColor(selectionColor);
            g.fill(track);
        } else {
            Shape track = this.getVerticalTrackShape(this.trackShape);
            g.setColor(bgColor);
            g.fill(track);
            this.setVerticalTrackClip(g);
            g.setColor(selectionColor);
            g.fill(track);
        }
        config.restore();
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.checkDisabled(g);
        super.paintMinorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.checkDisabled(g);
        super.paintMajorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.checkDisabled(g);
        super.paintMinorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.checkDisabled(g);
        super.paintMajorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    public void paintLabels(Graphics g) {
        this.checkDisabled(g);
        GraphicsContext config = GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paintLabels(g);
        config.restore();
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        this.checkDisabled(g);
        int labelCenter = this.xPositionForValue(value);
        float align = 0.5f;
        if (PropertyUtil.getBooleanProperty((Component)label, (String)KEY_MANUAL_LABEL_ALIGN)) {
            align = label.getAlignmentX();
        }
        int labelLeft = labelCenter - (int)((float)label.getPreferredSize().width * align);
        g.translate(labelLeft, 0);
        label.paint(g);
        g.translate(-labelLeft, 0);
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        this.checkDisabled(g);
        super.paintVerticalLabel(g, value, label);
    }

    @Override
    public void paintThumb(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext context = GraphicsUtil.setupStrokePainting((Graphics)g);
        if (this.isPlainThumb()) {
            this.paintPlainSliderThumb(g);
        } else {
            this.paintSliderThumb(g);
        }
        context.restore();
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        Shape area;
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.slider);
        int size = 3 * this.trackSize;
        Shape shape = area = this.isHorizontal() ? this.getHorizontalTrackShape(this.trackShape, size) : this.getVerticalTrackShape(this.trackShape, size);
        if (!area.getBounds().contains(p)) {
            return;
        }
        if (this.instantScrollEnabled(this.slider)) {
            int value = this.isHorizontal() ? this.valueForXPosition(p.x) : this.valueForYPosition(p.y);
            this.setValue(value, false);
        } else {
            super.scrollDueToClickInTrack(dir);
        }
    }

    private void checkDisabled(Graphics g) {
        if (!this.slider.isEnabled()) {
            g.setColor(this.getDisabledTickColor());
        }
    }

    protected Color getDisabledTickColor() {
        return this.inactiveTickForeground;
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        LookAndFeel.installProperty(slider, "opaque", false);
        this.arcSize = UIManager.getInt("Slider.arc");
        this.trackSize = UIManager.getInt("Slider.trackThickness");
        this.plainThumbRadius = UIManager.getInt("Slider.plainThumbRadius");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        this.iconPad = UIManager.getInt("Slider.iconPad");
        this.inactiveTickForeground = UIManager.getColor("Slider.disabledTickColor");
        this.trackBackground = UIManager.getColor("Slider.trackBackground");
        this.selectedTrackBackground = UIManager.getColor("Slider.selectedTrackColor");
        this.selectedTrackInactiveBackground = UIManager.getColor("Slider.disabledTrackColor");
        this.selectedVolumeTrackBackground = UIManager.getColor("Slider.volume.selectedTrackColor");
        this.selectedVolumeTrackInactiveBackground = UIManager.getColor("Slider.volume.disabledTrackColor");
        this.thumbBackground = UIManager.getColor("Slider.activeThumbFill");
        this.thumbInactiveBackground = UIManager.getColor("Slider.inactiveThumbFill");
        this.volumeThumbBackground = UIManager.getColor("Slider.volume.activeThumbFill");
        this.volumeThumbInactiveBackground = UIManager.getColor("Slider.volume.inactiveThumbFill");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.thumbFocusBorderColor = UIManager.getColor("Slider.thumbFocusBorderColor");
        this.thumbInactiveBorderColor = UIManager.getColor("Slider.thumbBorderColorDisabled");
        this.focusBorderSize = UIManager.getInt("Slider.focusBorderSize");
        this.paintFocus = UIManager.getBoolean("Slider.paintFocusGlow");
        this.thumb = UIManager.getIcon("Slider.enabledThumb.icon");
        this.thumbDisabled = UIManager.getIcon("Slider.disabledThumb.icon");
        this.thumbFocused = UIManager.getIcon("Slider.focusedThumb.icon");
        this.volumeThumb = UIManager.getIcon("Slider.volume.enabledThumb.icon");
        this.volumeThumbDisabled = UIManager.getIcon("Slider.volume.disabledThumb.icon");
        this.volumeThumbFocused = UIManager.getIcon("Slider.volume.focusedThumb.icon");
        this.volume0 = UIManager.getIcon("Slider.volume.enabled_level_0.icon");
        this.volume1 = UIManager.getIcon("Slider.volume.enabled_level_1.icon");
        this.volume2 = UIManager.getIcon("Slider.volume.enabled_level_2.icon");
        this.volume3 = UIManager.getIcon("Slider.volume.enabled_level_3.icon");
        this.volume4 = UIManager.getIcon("Slider.volume.enabled_level_4.icon");
        this.volume0Inactive = UIManager.getIcon("Slider.volume.disabled_level_0.icon");
        this.volume1Inactive = UIManager.getIcon("Slider.volume.disabled_level_1.icon");
        this.volume2Inactive = UIManager.getIcon("Slider.volume.disabled_level_2.icon");
        this.volume3Inactive = UIManager.getIcon("Slider.volume.disabled_level_3.icon");
        this.volume4Inactive = UIManager.getIcon("Slider.volume.disabled_level_4.icon");
        this.rotatableIcon = new RotatableIcon();
    }

    public int getFocusBorderSize() {
        return this.paintFocus ? this.focusBorderSize : 0;
    }

    protected void calculateIconRect() {
        this.iconRect.width = this.getVolumeIcon().getIconWidth();
        this.iconRect.height = this.getVolumeIcon().getIconHeight();
        if (this.isHorizontal()) {
            int extraSpace = this.iconPad + this.getThumbWidth() / 2;
            this.iconRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width + extraSpace : this.trackRect.x - this.iconRect.width - extraSpace;
            this.iconRect.y = this.trackRect.y + (this.trackRect.height - this.iconRect.height) / 2;
        } else {
            int extraSpace = this.iconPad + this.getThumbHeight() / 2;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                this.iconRect.x = this.trackRect.x + (this.trackRect.width - this.iconRect.width) / 2;
                this.iconRect.y = this.trackRect.y + this.trackRect.height + extraSpace;
            } else {
                this.iconRect.x = this.trackRect.x + (this.trackRect.width - this.iconRect.width) / 2;
                this.iconRect.y = this.trackRect.y - this.iconRect.height - extraSpace;
            }
        }
    }

    private void setHorizontalTrackClip(Graphics g) {
        int x = this.thumbRect.x + this.thumbRect.width / 2;
        if (!this.drawInverted()) {
            g.clipRect(0, 0, x, this.slider.getHeight());
        } else {
            g.clipRect(x, 0, this.slider.getWidth() - x, this.slider.getHeight());
        }
    }

    protected Icon getVolumeIcon() {
        int range = this.slider.getMaximum() - this.slider.getMinimum();
        int value = this.slider.getValue() - this.slider.getMinimum();
        double percentage = (double)value / (double)range;
        boolean enabled = this.slider.isEnabled();
        if (Math.abs(percentage) < 1.0E-6) {
            return enabled ? this.volume0 : this.volume0Inactive;
        }
        if (percentage < 0.25) {
            return enabled ? this.volume1 : this.volume1Inactive;
        }
        if (percentage < 0.5) {
            return enabled ? this.volume2 : this.volume2Inactive;
        }
        if (percentage < 0.75) {
            return enabled ? this.volume3 : this.volume3Inactive;
        }
        return enabled ? this.volume4 : this.volume4Inactive;
    }

    private boolean isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    private Shape getHorizontalTrackShape(RoundRectangle2D trackShape) {
        return this.getHorizontalTrackShape(trackShape, this.trackSize);
    }

    private Shape getHorizontalTrackShape(RoundRectangle2D trackShape, int size) {
        int arc = this.arcSize;
        int yOff = (this.trackRect.height - size) / 2;
        int w = this.trackRect.width;
        trackShape.setRoundRect(this.trackRect.x, this.trackRect.y + yOff, w, size, arc, arc);
        return trackShape;
    }

    private void setVerticalTrackClip(Graphics g) {
        int y = this.thumbRect.y + this.thumbRect.height / 2;
        if (this.slider.getInverted()) {
            g.clipRect(0, 0, this.slider.getWidth(), y);
        } else {
            g.clipRect(0, y, this.slider.getWidth(), this.slider.getHeight() - y);
        }
    }

    private Shape getVerticalTrackShape(RoundRectangle2D trackShape) {
        return this.getVerticalTrackShape(trackShape, this.trackSize);
    }

    private Shape getVerticalTrackShape(RoundRectangle2D trackShape, int size) {
        int arc = this.arcSize;
        int xOff = (this.trackRect.width - size) / 2;
        int h = this.trackRect.height;
        trackShape.setRoundRect(this.trackRect.x + xOff, this.trackRect.y, size, h, arc, arc);
        return trackShape;
    }

    private void paintPlainSliderThumb(Graphics2D g) {
        g.translate(this.thumbRect.x, this.thumbRect.y);
        int r = this.plainThumbRadius;
        int bw = this.getFocusBorderSize();
        g.setColor(this.getThumbColor());
        PaintUtil.fillRoundRect(g, bw, bw, r, r, r);
        if (!this.isVolumeSlider(this.slider)) {
            g.setColor(this.getThumbBorderColor());
            PaintUtil.paintLineBorder(g, bw, bw, r, r, r);
        }
        if (this.paintFocus()) {
            PaintUtil.paintFocusBorder(g, r + 2 * bw, r + 2 * bw, r + 2 * bw, bw);
        }
        g.translate(-this.thumbRect.x, -this.thumbRect.y);
    }

    protected boolean isPlainThumb() {
        return !this.slider.getPaintTicks() || !PropertyUtil.getBooleanProperty((JComponent)this.slider, (String)KEY_THUMB_ARROW_SHAPE, (boolean)true);
    }

    protected Icon getThumbIcon() {
        boolean enabled = this.slider.isEnabled();
        boolean focused = this.slider.hasFocus();
        boolean volume = this.isVolumeSlider(this.slider);
        Icon icon = volume ? (enabled ? (focused ? this.volumeThumbFocused : this.volumeThumb) : this.volumeThumbDisabled) : (enabled ? (focused ? this.thumbFocused : this.thumb) : this.thumbDisabled);
        this.rotatableIcon.setIcon(icon);
        if (this.isHorizontal()) {
            this.rotatableIcon.setOrientation(Alignment.NORTH);
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            this.rotatableIcon.setOrientation(Alignment.WEST);
        } else {
            this.rotatableIcon.setOrientation(Alignment.EAST);
        }
        return this.rotatableIcon;
    }

    private void paintSliderThumb(Graphics2D g) {
        if (this.isHorizontal()) {
            this.getThumbIcon().paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        } else {
            int cx = this.thumbRect.x + this.thumbRect.width / 2;
            int cy = this.thumbRect.y + this.thumbRect.height / 2;
            int x = cx - this.thumbRect.height / 2;
            int y = cy - this.thumbRect.width / 2;
            this.getThumbIcon().paintIcon(this.slider, g, x, y);
        }
    }

    private boolean paintFocus() {
        return this.slider.hasFocus() && this.paintFocus;
    }

    protected int getThumbWidth() {
        return this.thumbRect.width;
    }

    protected int getThumbHeight() {
        return this.thumbRect.height;
    }

    protected Color getThumbColor() {
        if (this.isVolumeSlider(this.slider)) {
            return this.slider.isEnabled() ? this.volumeThumbBackground : this.volumeThumbInactiveBackground;
        }
        return this.slider.isEnabled() ? this.thumbBackground : this.thumbInactiveBackground;
    }

    protected Color getThumbBorderColor() {
        return this.slider.isEnabled() ? (this.paintFocus() ? this.thumbFocusBorderColor : this.thumbBorderColor) : this.thumbInactiveBorderColor;
    }

    protected Color getTrackBackground() {
        return this.trackBackground;
    }

    protected Color getSelectedTrackColor() {
        if (this.isVolumeSlider(this.slider)) {
            return this.slider.isEnabled() ? this.selectedVolumeTrackBackground : this.selectedVolumeTrackInactiveBackground;
        }
        return this.slider.isEnabled() ? this.selectedTrackBackground : this.selectedTrackInactiveBackground;
    }

    private boolean instantScrollEnabled(JComponent c) {
        return PropertyUtil.getBooleanProperty((JComponent)c, (String)KEY_INSTANT_SCROLL);
    }

    public Rectangle getThumbRect() {
        return new Rectangle(this.thumbRect);
    }

    private int getSnappedValue(int value) {
        int snappedValue = value;
        int tickSpacing = this.getTickSpacing();
        if (tickSpacing != 0 && (value - this.slider.getMinimum()) % tickSpacing != 0) {
            float temp = (float)(value - this.slider.getMinimum()) / (float)tickSpacing;
            snappedValue = this.slider.getMinimum() + Math.round(temp) * tickSpacing;
        }
        return snappedValue;
    }

    public class SnapTrackListener
    extends BasicSliderUI.TrackListener {
        private int offset;

        public SnapTrackListener() {
            super(DarkSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            int pos = DarkSliderUI.this.isHorizontal() ? evt.getX() : evt.getY();
            int loc = this.getLocationForValue(this.getSnappedValue(evt));
            int n = this.offset = loc < 0 ? 0 : pos - loc;
            if (DarkSliderUI.this.iconRect.contains(evt.getPoint())) {
                return;
            }
            super.mousePressed(evt);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DarkSliderUI.this.slider.getSnapToTicks()) {
                int pos = this.getLocationForValue(this.getSnappedValue(e));
                if (DarkSliderUI.this.isHorizontal()) {
                    e.translatePoint(pos - e.getX() + this.offset, 0);
                } else {
                    e.translatePoint(0, pos - e.getY() + this.offset);
                }
            }
            super.mouseDragged(e);
            DarkSliderUI.this.slider.repaint();
        }

        private int getLocationForValue(int value) {
            return DarkSliderUI.this.isHorizontal() ? DarkSliderUI.this.xPositionForValue(value) : DarkSliderUI.this.yPositionForValue(value);
        }

        private int getSnappedValue(MouseEvent e) {
            int value = DarkSliderUI.this.isHorizontal() ? DarkSliderUI.this.valueForXPosition(e.getX()) : DarkSliderUI.this.valueForYPosition(e.getY());
            return DarkSliderUI.this.getSnappedValue(value);
        }
    }
}

