/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.ui.internalframe.DarkDesktopPaneUI;
import com.github.weisj.darklaf.ui.internalframe.DarkInternalFrameTitlePane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class DarkInternalFrameUI
extends BasicInternalFrameUI
implements PropertyChangeListener {
    protected JMenuBar currentMenuBar;

    public DarkInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent b) {
        return new DarkInternalFrameUI((JInternalFrame)b);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.frame.setOpaque(false);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new DarkInternalFrameTitlePane(w);
        this.titlePane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
        return this.titlePane;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (UIManager.getBoolean("InternalFrame.useExternalMenuBar")) {
            this.frame.addPropertyChangeListener(this);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(this);
    }

    protected void updateActiveJMenuBar(JDesktopPane desktopPane, JMenuBar menuBar) {
        DarkDesktopPaneUI ui = DarkUIUtil.getUIOfType(desktopPane.getUI(), DarkDesktopPaneUI.class);
        if (ui != null) {
            ui.setActiveJMenuBar(menuBar);
        }
    }

    protected Rectangle getContentRegion(JDesktopPane desktopPane) {
        DarkDesktopPaneUI ui = DarkUIUtil.getUIOfType(desktopPane.getUI(), DarkDesktopPaneUI.class);
        if (ui != null) {
            return ui.getContentRegion();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Rectangle bounds;
        String key = evt.getPropertyName();
        boolean isMenuBarProp = "JMenuBar".equals(key);
        boolean isSelectedProp = "selected".equals(key);
        boolean isIconProperty = "icon".equals(key);
        if (isMenuBarProp || isSelectedProp || isIconProperty) {
            JDesktopPane desktopPane;
            if (isMenuBarProp) {
                this.currentMenuBar = this.frame.getJMenuBar();
                this.frame.getRootPane().remove(this.currentMenuBar);
                this.currentMenuBar.setPreferredSize(new Dimension(0, 0));
                this.frame.doLayout();
            }
            if ((desktopPane = this.frame.getDesktopPane()) != null) {
                if (this.shouldShowMenuBar(this.frame)) {
                    this.updateActiveJMenuBar(desktopPane, this.currentMenuBar);
                } else if (!this.shouldShowMenuBar(desktopPane.getSelectedFrame())) {
                    this.updateActiveJMenuBar(desktopPane, null);
                }
            }
        } else if ("maximum".equals(key) && this.frame.isMaximum() && (bounds = this.getContentRegion(this.frame.getDesktopPane())) != null) {
            this.frame.setBounds(bounds);
        }
    }

    protected boolean shouldShowMenuBar(JInternalFrame internalFrame) {
        if (internalFrame == null) {
            return false;
        }
        return internalFrame.isSelected() && !internalFrame.isClosed() && !internalFrame.isIcon();
    }
}

