/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.TextValueTemplateNode;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.style.XSLAccumulator;
import net.sf.saxon.style.XSLAccumulatorRule;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLArray;
import net.sf.saxon.style.XSLArrayMember;
import net.sf.saxon.style.XSLAssert;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLBreak;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCatch;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLContextItem;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLEvaluate;
import net.sf.saxon.style.XSLExpose;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFork;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalContextItem;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLItemType;
import net.sf.saxon.style.XSLIterate;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLMap;
import net.sf.saxon.style.XSLMapEntry;
import net.sf.saxon.style.XSLMatch;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMerge;
import net.sf.saxon.style.XSLMergeAction;
import net.sf.saxon.style.XSLMergeKey;
import net.sf.saxon.style.XSLMergeSource;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLMode;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextIteration;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOnCompletion;
import net.sf.saxon.style.XSLOnEmpty;
import net.sf.saxon.style.XSLOnNonEmpty;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSourceDocument;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLSwitch;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLTry;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWherePopulated;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.type.SchemaType;

public class StyleNodeFactory
implements NodeFactory {
    protected Configuration config;
    protected NamePool namePool;
    private final Compilation compilation;
    private boolean topLevelModule;

    public StyleNodeFactory(Configuration config, Compilation compilation) {
        this.config = config;
        this.compilation = compilation;
        this.namePool = config.getNamePool();
    }

    public void setTopLevelModule(boolean topLevelModule) {
        this.topLevelModule = topLevelModule;
    }

    public boolean isTopLevelModule() {
        return this.topLevelModule;
    }

    public Compilation getCompilation() {
        return this.compilation;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public ElementImpl makeElementNode(NodeInfo parent, NodeName elemName, SchemaType elemType, boolean isNilled, AttributeMap attlist, NamespaceMap namespaces, PipelineConfiguration pipe, Location location, int sequence) {
        ElementImpl node;
        Class actualClass;
        int f = elemName.obtainFingerprint(pipe.getConfiguration().getNamePool());
        boolean toplevel = parent instanceof XSLModuleRoot;
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        baseURI = location.getSystemId();
        lineNumber = location.getLineNumber();
        columnNumber = location.getColumnNumber();
        if (parent instanceof DataElement) {
            DataElement d = new DataElement();
            d.setNamespaceMap(namespaces);
            d.initialise(elemName, elemType, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        StyleElement e = this.makeXSLElement(f, (NodeImpl)parent);
        if ((e instanceof XSLStylesheet || e instanceof XSLPackage) && parent.getNodeKind() != 9) {
            e = new AbsentExtensionElement();
            XmlProcessingIncident reason = new XmlProcessingIncident(elemName.getDisplayName() + " can only appear at the outermost level", "XTSE0010", e);
            e.setValidationError(reason, StyleElement.OnFailure.REPORT_ALWAYS);
        }
        if (e != null) {
            e.setCompilation(this.compilation);
            e.setNamespaceMap(namespaces);
            e.initialise(elemName, elemType, attlist, parent, sequence);
            e.setLocation(baseURI, lineNumber, columnNumber);
            e.processExtensionElementAttribute("");
            e.processExcludedNamespaces("");
            e.processVersionAttribute("");
            e.processDefaultXPathNamespaceAttribute("");
            e.processExpandTextAttribute("");
            e.processDefaultValidationAttribute("");
            if (toplevel && !e.isDeclaration() && !(e instanceof XSLExpose) && e.forwardsCompatibleModeIsEnabled()) {
                DataElement d = new DataElement();
                d.setNamespaceMap(namespaces);
                d.initialise(elemName, elemType, attlist, parent, sequence);
                d.setLocation(baseURI, lineNumber, columnNumber);
                return d;
            }
            if (parent instanceof AbsentExtensionElement && ((AbsentExtensionElement)parent).forwardsCompatibleModeIsEnabled() && parent.getURI().equals("http://www.w3.org/1999/XSL/Transform") && !(e instanceof XSLFallback)) {
                AbsentExtensionElement temp = new AbsentExtensionElement();
                temp.initialise(elemName, elemType, attlist, parent, sequence);
                temp.setLocation(baseURI, lineNumber, columnNumber);
                temp.setCompilation(this.compilation);
                temp.setIgnoreInstruction();
                return temp;
            }
            return e;
        }
        String uri = elemName.getURI();
        if (toplevel && !uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            DataElement d = new DataElement();
            d.setNamespaceMap(namespaces);
            d.initialise(elemName, elemType, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        String localname = elemName.getLocalPart();
        ElementImpl temp = null;
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            int processorVersion = this.compilation.getCompilerInfo().getXsltVersion();
            if (parent instanceof XSLStylesheet) {
                if (((XSLStylesheet)parent).getEffectiveVersion() <= processorVersion) {
                    temp = new AbsentExtensionElement();
                    ((StyleElement)temp).setCompilation(this.compilation);
                    ((StyleElement)temp).setValidationError(new XmlProcessingIncident("Unknown top-level XSLT declaration " + elemName.getDisplayName(), "XTSE0010", location), StyleElement.OnFailure.REPORT_UNLESS_FORWARDS_COMPATIBLE);
                }
            } else {
                temp = new AbsentExtensionElement();
                temp.initialise(elemName, elemType, attlist, parent, sequence);
                temp.setLocation(baseURI, lineNumber, columnNumber);
                ((StyleElement)temp).setCompilation(this.compilation);
                ((StyleElement)temp).processStandardAttributes("");
                ((StyleElement)temp).setValidationError(new XmlProcessingIncident("Unknown XSLT instruction " + elemName.getDisplayName(), "XTSE0010", location), ((StyleElement)temp).getEffectiveVersion() > processorVersion ? StyleElement.OnFailure.REPORT_STATICALLY_UNLESS_FALLBACK_AVAILABLE : StyleElement.OnFailure.REPORT_ALWAYS);
            }
        }
        if (uri.equals("http://saxon.sf.net/")) {
            String message = elemName.getDisplayName() + " is not recognized as a Saxon instruction";
            if (this.config.getEditionCode().equals("HE")) {
                message = message + ". Saxon extensions require Saxon-PE or higher";
            } else if (!this.config.isLicensedFeature(8)) {
                message = message + ". No Saxon-PE or -EE license was found";
            }
            XmlProcessingIncident err = new XmlProcessingIncident(message, "SXWN9008", location.saveLocation()).asWarning();
            pipe.getErrorReporter().report(err);
        }
        Class<LiteralResultElement> assumedClass = LiteralResultElement.class;
        if (temp == null) {
            temp = new LiteralResultElement();
        }
        temp.setNamespaceMap(namespaces);
        ((StyleElement)temp).setCompilation(this.compilation);
        temp.initialise(elemName, elemType, attlist, parent, sequence);
        temp.setLocation(baseURI, lineNumber, columnNumber);
        ((StyleElement)temp).processStandardAttributes("http://www.w3.org/1999/XSL/Transform");
        if (((StyleElement)temp).isExtensionNamespace(uri) && !toplevel) {
            XmlProcessingIncident reason;
            actualClass = AbsentExtensionElement.class;
            if (NamespaceConstant.isReserved(uri)) {
                reason = new XmlProcessingIncident("Cannot use a reserved namespace for extension instructions", "XTSE0800");
                ((StyleElement)temp).setValidationError(reason, StyleElement.OnFailure.REPORT_ALWAYS);
            } else {
                reason = new XmlProcessingIncident("Unknown extension instruction " + Err.wrap(elemName.getDisplayName(), 1), "XTDE1450");
                ((StyleElement)temp).setValidationError(reason, StyleElement.OnFailure.REPORT_DYNAMICALLY_UNLESS_FALLBACK_AVAILABLE);
            }
        } else {
            actualClass = LiteralResultElement.class;
        }
        if (actualClass.equals(assumedClass)) {
            node = temp;
        } else {
            node = this.makeStyleElement(actualClass);
            ((StyleElement)node).substituteFor((StyleElement)temp);
        }
        return node;
    }

    protected StyleElement makeStyleElement(Class<? extends StyleElement> actualClass) {
        StyleElement node;
        try {
            node = actualClass.newInstance();
        }
        catch (InstantiationException err1) {
            throw new TransformerFactoryConfigurationError(err1, "Failed to create instance of " + actualClass.getName());
        }
        catch (IllegalAccessException err2) {
            throw new TransformerFactoryConfigurationError(err2, "Failed to access class " + actualClass.getName());
        }
        return node;
    }

    protected StyleElement makeXSLElement(int f, NodeImpl parent) {
        switch (f) {
            case 128: {
                return new XSLAccept();
            }
            case 129: {
                return new XSLAccumulator();
            }
            case 130: {
                return new XSLAccumulatorRule();
            }
            case 131: {
                return new XSLAnalyzeString();
            }
            case 132: {
                return new XSLApplyImports();
            }
            case 133: {
                return new XSLApplyTemplates();
            }
            case 134: {
                return new XSLArray();
            }
            case 135: {
                return new XSLArrayMember();
            }
            case 136: {
                return new XSLAssert();
            }
            case 137: {
                return new XSLAttribute();
            }
            case 138: {
                return new XSLAttributeSet();
            }
            case 139: {
                return new XSLBreak();
            }
            case 140: {
                return new XSLCallTemplate();
            }
            case 141: {
                return new XSLCatch();
            }
            case 145: {
                return new XSLContextItem();
            }
            case 142: {
                return new XSLCharacterMap();
            }
            case 143: {
                return new XSLChoose();
            }
            case 144: {
                return new XSLComment();
            }
            case 146: {
                return new XSLCopy();
            }
            case 147: {
                return new XSLCopyOf();
            }
            case 148: {
                return new XSLDecimalFormat();
            }
            case 150: {
                return new XSLDocument();
            }
            case 151: {
                return new XSLElement();
            }
            case 153: {
                return new XSLEvaluate();
            }
            case 152: {
                return new XSLExpose();
            }
            case 154: {
                return new XSLFallback();
            }
            case 155: {
                return new XSLForEach();
            }
            case 156: {
                return new XSLForEachGroup();
            }
            case 159: {
                return new XSLFork();
            }
            case 160: {
                return new XSLFunction();
            }
            case 161: {
                return new XSLGlobalContextItem();
            }
            case 162: {
                return new XSLIf();
            }
            case 163: {
                return new XSLImport();
            }
            case 164: {
                return new XSLImportSchema();
            }
            case 165: {
                return new XSLInclude();
            }
            case 166: {
                return new XSLItemType();
            }
            case 168: {
                return new XSLIterate();
            }
            case 169: {
                return new XSLKey();
            }
            case 170: {
                return new XSLMap();
            }
            case 171: {
                return new XSLMapEntry();
            }
            case 172: {
                return new XSLMatch();
            }
            case 173: {
                return new XSLMatchingSubstring();
            }
            case 174: {
                return new XSLMerge();
            }
            case 175: {
                return new XSLMergeAction();
            }
            case 176: {
                return new XSLMergeKey();
            }
            case 178: {
                return new XSLMergeSource();
            }
            case 179: {
                return new XSLMessage();
            }
            case 180: {
                return new XSLMode();
            }
            case 183: {
                return new XSLNextIteration();
            }
            case 184: {
                return new XSLNextMatch();
            }
            case 185: {
                return new XSLMatchingSubstring();
            }
            case 186: {
                return new XSLNumber();
            }
            case 181: {
                return new XSLNamespace();
            }
            case 182: {
                return new XSLNamespaceAlias();
            }
            case 188: {
                return new XSLOnCompletion();
            }
            case 189: {
                return new XSLOnEmpty();
            }
            case 190: {
                return new XSLOnNonEmpty();
            }
            case 187: {
                return new XSLOtherwise();
            }
            case 191: {
                return new XSLOutput();
            }
            case 193: {
                return new XSLOutputCharacter();
            }
            case 192: {
                return new XSLOverride();
            }
            case 194: {
                return new XSLPackage();
            }
            case 195: {
                return parent instanceof XSLModuleRoot || parent instanceof XSLOverride ? new XSLGlobalParam() : new XSLLocalParam();
            }
            case 198: {
                return new XSLPerformSort();
            }
            case 199: {
                return new XSLPreserveSpace();
            }
            case 200: {
                return new XSLProcessingInstruction();
            }
            case 201: {
                this.compilation.setCreatesSecondaryResultDocuments(true);
                return new XSLResultDocument();
            }
            case 202: {
                return new XSLSequence();
            }
            case 203: {
                return new XSLSort();
            }
            case 204: {
                return new XSLSourceDocument();
            }
            case 205: {
                return new XSLPreserveSpace();
            }
            case 208: 
            case 212: {
                return this.topLevelModule ? new XSLPackage() : new XSLStylesheet();
            }
            case 209: {
                return new XSLSwitch();
            }
            case 210: {
                return new XSLTemplate();
            }
            case 211: {
                return new XSLText();
            }
            case 213: {
                return new XSLTry();
            }
            case 214: {
                return new XSLUsePackage();
            }
            case 215: {
                return new XSLValueOf();
            }
            case 218: {
                return parent instanceof XSLModuleRoot || parent instanceof XSLOverride ? new XSLGlobalVariable() : new XSLLocalVariable();
            }
            case 221: {
                return new XSLWithParam();
            }
            case 219: {
                return new XSLWhen();
            }
            case 220: {
                return new XSLWherePopulated();
            }
        }
        return null;
    }

    @Override
    public TextImpl makeTextNode(NodeInfo parent, UnicodeString content) {
        if (parent instanceof StyleElement && ((StyleElement)parent).isExpandingText()) {
            return new TextValueTemplateNode(content);
        }
        return new TextImpl(content);
    }

    public boolean isElementAvailable(String uri, String localName, boolean instructionsOnly) {
        int fingerprint = this.namePool.getFingerprint(uri, localName);
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (fingerprint == -1) {
                return false;
            }
            StyleElement e = this.makeXSLElement(fingerprint, null);
            if (e != null) {
                return !instructionsOnly || e.isInstruction();
            }
        }
        return false;
    }

    public AccumulatorRegistry makeAccumulatorManager() {
        return new AccumulatorRegistry();
    }

    public PrincipalStylesheetModule newPrincipalModule(XSLPackage node) throws XPathException {
        return new PrincipalStylesheetModule(node);
    }
}

