/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.server.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.plot.config.FailureHandler;
import jetbrains.datalore.plot.config.FigKind;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import jetbrains.datalore.plot.server.config.transform.PlotConfigServerSideTransforms;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J(\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J(\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J4\u0010\u0015\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/server/config/BackendSpecTransformUtil;", "", "()V", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "getTransformedSpecsAndPlotConfig", "Lkotlin/Pair;", "", "", "Ljetbrains/datalore/plot/server/config/PlotConfigServerSide;", "plotSpecRaw", "getTransformedSpecsAndPlotConfig$plot_config_portable", "processTransform", "processTransformFigureList", "", "figureListRaw", "processTransformInBunch", "bunchSpecRaw", "processTransformInSubPlots", "compositeFigureSpecRaw", "processTransformIntern", "processTransformIntern2", "throwTestingException", "", "plotSpec", "", "plot-config-portable"})
public final class BackendSpecTransformUtil {
    @NotNull
    public static final BackendSpecTransformUtil INSTANCE = new BackendSpecTransformUtil();
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(BackendSpecTransformUtil.class));

    private BackendSpecTransformUtil() {
    }

    @NotNull
    public final Map<String, Object> processTransform(@NotNull Map<String, Object> plotSpecRaw) {
        Map map2;
        Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
        try {
            Map map3;
            switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(plotSpecRaw).ordinal()]) {
                case 1: {
                    map3 = this.processTransformIntern(plotSpecRaw);
                    break;
                }
                case 2: {
                    map3 = this.processTransformInSubPlots(plotSpecRaw);
                    break;
                }
                case 3: {
                    map3 = this.processTransformInBunch(plotSpecRaw);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            map2 = map3;
        }
        catch (RuntimeException e) {
            FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
            if (failureInfo.isInternalError()) {
                LOG.error(e, (Function0<String>)((Function0)new Function0<String>(failureInfo){
                    final /* synthetic */ FailureHandler.FailureInfo $failureInfo;
                    {
                        this.$failureInfo = $failureInfo;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$failureInfo.getMessage();
                    }
                }));
            }
            map2 = new HashMap<String, Object>(PlotConfig.Companion.failure(failureInfo.getMessage()));
        }
        return map2;
    }

    private final Map<String, Object> processTransformInSubPlots(Map<String, Object> compositeFigureSpecRaw) {
        if (!compositeFigureSpecRaw.containsKey("figures")) {
            compositeFigureSpecRaw.put("figures", CollectionsKt.emptyList());
            return compositeFigureSpecRaw;
        }
        Object object = compositeFigureSpecRaw.get("figures");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        List elementListRaw = (List)object;
        List<Object> elementListProcessed = this.processTransformFigureList(elementListRaw);
        HashMap<String, Object> compositeFigureSpec = new HashMap<String, Object>(compositeFigureSpecRaw);
        ((Map)compositeFigureSpec).put("figures", elementListProcessed);
        return compositeFigureSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> processTransformFigureList(List<?> figureListRaw) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = figureListRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map<String, Object> map2;
            void figRaw;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (figRaw == null || Intrinsics.areEqual((Object)figRaw, (Object)"blank")) {
                map2 = "blank";
            } else {
                if (!(figRaw instanceof Map)) {
                    throw new IllegalArgumentException("Subplots: a figure spec (a Map) expected but was: " + Reflection.getOrCreateKotlinClass(figRaw.getClass()).getSimpleName());
                }
                HashMap figCopy = new HashMap((Map)figRaw);
                switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figCopy).ordinal()]) {
                    case 1: {
                        map2 = INSTANCE.processTransformIntern(figCopy);
                        break;
                    }
                    case 2: {
                        map2 = INSTANCE.processTransformInSubPlots(figCopy);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException("GGBunch is not expected among subplots.");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            collection.add(map2);
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, Object> processTransformInBunch(Map<String, Object> bunchSpecRaw) {
        if (!bunchSpecRaw.containsKey("items")) {
            bunchSpecRaw.put("items", CollectionsKt.emptyList());
            return bunchSpecRaw;
        }
        Object object = bunchSpecRaw.get("items");
        Intrinsics.checkNotNull((Object)object);
        Object itemsRaw = object;
        if (!(itemsRaw instanceof List)) {
            throw new IllegalArgumentException("GGBunch: list of features expected but was: " + Reflection.getOrCreateKotlinClass(itemsRaw.getClass()).getSimpleName());
        }
        ArrayList items = new ArrayList();
        for (Object rawItem : (List)itemsRaw) {
            Object featureSpecRaw;
            if (!(rawItem instanceof Map)) {
                StringBuilder stringBuilder = new StringBuilder().append("GGBunch item: Map of attributes expected but was: ");
                Object e = rawItem;
                Intrinsics.checkNotNull(e);
                throw new IllegalArgumentException(stringBuilder.append(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName()).toString());
            }
            HashMap item = new HashMap((Map)rawItem);
            if (!item.containsKey("feature_spec")) {
                throw new IllegalArgumentException("GGBunch item: absent required attribute: feature_spec");
            }
            Intrinsics.checkNotNull(item.get("feature_spec"));
            if (!(featureSpecRaw instanceof Map)) {
                throw new IllegalArgumentException("GGBunch item 'feature_spec' : Map of attributes expected but was: " + Reflection.getOrCreateKotlinClass(featureSpecRaw.getClass()).getSimpleName());
            }
            HashMap featureSpec = new HashMap((Map)featureSpecRaw);
            FigKind kind = PlotConfig.Companion.figSpecKind(featureSpec);
            if (kind != FigKind.PLOT_SPEC) {
                throw new IllegalArgumentException((Object)((Object)FigKind.PLOT_SPEC) + " expected but was: " + (Object)((Object)kind));
            }
            Map<String, Object> plotSpec = this.processTransformIntern(featureSpec);
            ((Map)item).put("feature_spec", plotSpec);
            items.add(item);
        }
        bunchSpecRaw.put("items", items);
        return bunchSpecRaw;
    }

    private final Map<String, Object> processTransformIntern(Map<String, Object> plotSpecRaw) {
        Map plotSpec = (Map)this.processTransformIntern2(plotSpecRaw).component1();
        return plotSpec;
    }

    @NotNull
    public final Pair<Map<String, Object>, PlotConfigServerSide> getTransformedSpecsAndPlotConfig$plot_config_portable(@NotNull Map<String, Object> plotSpecRaw) {
        Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
        return this.processTransformIntern2(plotSpecRaw);
    }

    private final Pair<Map<String, Object>, PlotConfigServerSide> processTransformIntern2(Map<String, Object> plotSpecRaw) {
        Map<String, Object> plotSpec = PlotConfigServerSideTransforms.INSTANCE.migrationTransform().apply(plotSpecRaw);
        plotSpec = PlotConfigServerSideTransforms.INSTANCE.bistroTransform().apply(plotSpec);
        plotSpec = PlotConfigServerSideTransforms.INSTANCE.entryTransform().apply(plotSpec);
        PlotConfigServerSide plotConfig = new PlotConfigServerSide(plotSpec);
        plotConfig.updatePlotSpec$plot_config_portable();
        return new Pair(plotSpec, (Object)plotConfig);
    }

    private final void throwTestingException(Map<String, ? extends Object> plotSpec) {
        if (plotSpec.containsKey("ggtitle")) {
            Object object = plotSpec.get("ggtitle");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Object v = ((Map)object).get("text");
            Intrinsics.checkNotNull(v);
            Object title = v;
            if (Intrinsics.areEqual((Object)"Throw testing exception", title)) {
                throw new IllegalArgumentException("User configuration error");
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

