/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.builder.presentation.DefaultFontFamilyRegistry;
import jetbrains.datalore.plot.builder.presentation.FontFamilyRegistry;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/config/FontFamilyRegistryConfig;", "", "plotOptions", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "(Ljetbrains/datalore/plot/config/OptionsAccessor;)V", "createFontFamilyRegistry", "Ljetbrains/datalore/plot/builder/presentation/FontFamilyRegistry;", "plot-config-portable"})
public final class FontFamilyRegistryConfig {
    @NotNull
    private final OptionsAccessor plotOptions;

    public FontFamilyRegistryConfig(@NotNull OptionsAccessor plotOptions) {
        Intrinsics.checkNotNullParameter((Object)plotOptions, (String)"plotOptions");
        this.plotOptions = plotOptions;
    }

    @NotNull
    public final FontFamilyRegistry createFontFamilyRegistry() {
        List<?> metainfoOptionList = this.plotOptions.getList("metainfo_list");
        double defaultWidthFactor = 1.0;
        ArrayList<OptionsAccessor> fontInfos = new ArrayList<OptionsAccessor>();
        for (Object metainfoRaw : metainfoOptionList) {
            if (!(metainfoRaw instanceof Map)) continue;
            OptionsAccessor metainfoOpts = new OptionsAccessor((Map)metainfoRaw, null, 2, null);
            String string = metainfoOpts.getStringSafe("name");
            if (Intrinsics.areEqual((Object)string, (Object)"font_metrics_adjustment")) {
                defaultWidthFactor = metainfoOpts.getDoubleDef("width_correction", defaultWidthFactor);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"font_family_info")) continue;
            fontInfos.add(metainfoOpts);
        }
        DefaultFontFamilyRegistry familyRegistry = new DefaultFontFamilyRegistry(defaultWidthFactor);
        Iterable $this$forEach$iv = fontInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OptionsAccessor it = (OptionsAccessor)element$iv;
            boolean bl = false;
            Boolean mono = it.has("monospaced") ? Boolean.valueOf(it.getBoolean("monospaced", false)) : null;
            familyRegistry.put(it.getStringSafe("family"), mono, it.getDouble("width_correction"));
        }
        return familyRegistry;
    }
}

