/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Map;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.plot.base.geom.util.ArrowSpec;
import jetbrains.datalore.plot.config.ConfigUtil;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/config/ArrowSpecConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "options", "", "", "", "(Ljava/util/Map;)V", "createArrowSpec", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;", "Companion", "plot-config-portable"})
public final class ArrowSpecConfig
extends OptionsAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double DEF_ANGLE = 30.0;
    private static final double DEF_LENGTH = 10.0;
    @NotNull
    private static final ArrowSpec.End DEF_END = ArrowSpec.End.LAST;
    @NotNull
    private static final ArrowSpec.Type DEF_TYPE = ArrowSpec.Type.OPEN;

    private ArrowSpecConfig(Map<String, ? extends Object> options) {
        super(options, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ArrowSpec createArrowSpec() {
        String string;
        String s2;
        ArrowSpec.Type type;
        ArrowSpec.End end;
        double length;
        double angle;
        block17: {
            angle = 30.0;
            length = 10.0;
            end = DEF_END;
            type = DEF_TYPE;
            if (this.has("angle")) {
                Double d = this.getDouble("angle");
                Intrinsics.checkNotNull((Object)d);
                angle = d;
            }
            if (this.has("length")) {
                Double d = this.getDouble("length");
                Intrinsics.checkNotNull((Object)d);
                length = d;
            }
            if (!this.has("ends")) break block17;
            s2 = this.getString("ends");
            string = s2;
            if (string == null) throw new IllegalArgumentException("Expected: first|last|both");
            int n = -1;
            switch (string.hashCode()) {
                case 3314326: {
                    if (string.equals("last")) {
                        n = 1;
                    }
                    break;
                }
                case 97440432: {
                    if (string.equals("first")) {
                        n = 2;
                    }
                    break;
                }
                case 3029889: {
                    if (string.equals("both")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    end = ArrowSpec.End.LAST;
                    break;
                }
                case 2: {
                    end = ArrowSpec.End.FIRST;
                    break;
                }
                case 3: {
                    end = ArrowSpec.End.BOTH;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expected: first|last|both");
                }
            }
        }
        if (!this.has("type")) return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
        s2 = this.getString("type");
        string = s2;
        if (Intrinsics.areEqual((Object)string, (Object)"open")) {
            type = ArrowSpec.Type.OPEN;
            return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
        } else {
            if (!Intrinsics.areEqual((Object)string, (Object)"closed")) throw new IllegalArgumentException("Expected: open|closed");
            type = ArrowSpec.Type.CLOSED;
        }
        return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
    }

    public /* synthetic */ ArrowSpecConfig(Map options, DefaultConstructorMarker $constructor_marker) {
        this(options);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/config/ArrowSpecConfig$Companion;", "", "()V", "DEF_ANGLE", "", "DEF_END", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$End;", "DEF_LENGTH", "DEF_TYPE", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;", "create", "Ljetbrains/datalore/plot/config/ArrowSpecConfig;", "options", "plot-config-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrowSpecConfig create(@NotNull Object options) {
            String name;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (options instanceof Map && Intrinsics.areEqual((Object)"arrow", (Object)(name = ConfigUtil.INSTANCE.featureName((Map)options)))) {
                return new ArrowSpecConfig((Map)options, null);
            }
            throw new IllegalArgumentException("Expected: 'arrow = arrow(...)'");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

