/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProviderFactory;
import jetbrains.datalore.plot.builder.layout.axis.AxisLayouter;
import jetbrains.datalore.plot.builder.layout.util.Insets;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "", "breaksProviderFactory", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "getOrientation", "()Ljetbrains/datalore/plot/builder/guide/Orientation;", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "axisDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "axisLength", "", "geomAreaInsets", "Ljetbrains/datalore/plot/builder/layout/util/Insets;", "plot-builder-portable"})
public final class AxisLayout {
    @NotNull
    private final AxisBreaksProviderFactory breaksProviderFactory;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final AxisTheme theme;

    public AxisLayout(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @NotNull Orientation orientation, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.breaksProviderFactory = breaksProviderFactory;
        this.orientation = orientation;
        this.theme = theme;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisTheme getTheme() {
        return this.theme;
    }

    @NotNull
    public final AxisLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength, @NotNull Insets geomAreaInsets) {
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
        AxisBreaksProvider breaksProvider = this.breaksProviderFactory.createAxisBreaksProvider(axisDomain);
        AxisLayouter layouter = AxisLayouter.Companion.create(this.orientation, axisDomain, breaksProvider, geomAreaInsets, this.theme);
        return layouter.doLayout(axisLength);
    }
}

