/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.scale.breaks.NumericBreakFormatter;
import jetbrains.datalore.plot.base.scale.transform.LinearBreaksGen;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/NonlinearBreaksGen;", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "transform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "formatter", "Lkotlin/Function1;", "", "", "(Ljetbrains/datalore/plot/base/ContinuousTransform;Lkotlin/jvm/functions/Function1;)V", "defaultFormatter", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "labelFormatter", "Companion", "MultiFormatter", "plot-base-portable"})
public final class NonlinearBreaksGen
implements BreaksGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContinuousTransform transform;
    @Nullable
    private final Function1<Object, String> formatter;

    public NonlinearBreaksGen(@NotNull ContinuousTransform transform2, @Nullable Function1<Object, String> formatter2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        this.transform = transform2;
        this.formatter = formatter2;
    }

    public /* synthetic */ NonlinearBreaksGen(ContinuousTransform continuousTransform, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(continuousTransform, (Function1<Object, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
        void $this$mapIndexedTo$iv$iv;
        List list2;
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        List breakValues = NonlinearBreaksGen.Companion.generateBreakValues(domain, targetCount, this.transform);
        if (this.formatter != null) {
            int n = breakValues.size();
            ArrayList<Function1<Object, String>> arrayList = new ArrayList<Function1<Object, String>>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add((String)this.formatter);
            }
            list2 = arrayList;
        } else {
            list2 = NonlinearBreaksGen.Companion.createFormatters(breakValues);
        }
        List breakFormatters = list2;
        Iterable $this$mapIndexed$iv = breakValues;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void v;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv$iv).doubleValue();
            int n5 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)((Function1)breakFormatters.get((int)i)).invoke((Object)((double)v)));
        }
        List labels = (List)destination$iv$iv;
        return new ScaleBreaks(breakValues, breakValues, labels);
    }

    @Override
    @NotNull
    public Function1<Object, String> labelFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Function1<Object, String> function1 = this.formatter;
        if (function1 == null) {
            function1 = this.defaultFormatter(domain, targetCount);
        }
        return function1;
    }

    @Override
    @NotNull
    public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return NonlinearBreaksGen.Companion.createMultiFormatter(NonlinearBreaksGen.Companion.generateBreakValues(domain, targetCount, this.transform));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J(\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/NonlinearBreaksGen$Companion;", "", "()V", "createFormatter", "Lkotlin/Function1;", "", "domainValue", "", "step", "createFormatters", "", "breakValues", "createMultiFormatter", "generateBreakValues", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "targetCount", "", "transform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Double> generateBreakValues(DoubleSpan domain, int targetCount, ContinuousTransform transform2) {
            DoubleSpan transformedDomain = ScaleUtil.INSTANCE.applyTransform(domain, transform2);
            List<Double> transformedBreakValues = LinearBreaksGen.Companion.generateBreakValues$plot_base_portable(transformedDomain, targetCount);
            return CollectionsKt.filterNotNull((Iterable)transform2.applyInverse(transformedBreakValues));
        }

        private final Function1<Object, String> createMultiFormatter(List<Double> breakValues) {
            List<Function1<Object, String>> breakFormatters = this.createFormatters(breakValues);
            return (Function1)new Function1<Object, String>((Object)new MultiFormatter(breakValues, breakFormatters)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((MultiFormatter)this.receiver).apply(p0);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<Function1<Object, String>> createFormatters(List<Double> breakValues) {
            void $this$mapIndexedTo$iv$iv;
            if (breakValues.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            if (breakValues.size() == 1) {
                double domainValue = ((Number)breakValues.get(0)).doubleValue();
                double step = domainValue / (double)10;
                return CollectionsKt.listOf(this.createFormatter(domainValue, step));
            }
            Iterable $this$mapIndexed$iv = breakValues;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void currValue;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d = ((Number)item$iv$iv).doubleValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double step = Math.abs((double)(i == false ? currValue - ((Number)breakValues.get((int)(i + true))).doubleValue() : currValue - ((Number)breakValues.get((int)(i - true))).doubleValue()));
                collection.add(Companion.createFormatter((double)currValue, step));
            }
            List formatters = (List)destination$iv$iv;
            return formatters;
        }

        private final Function1<Object, String> createFormatter(double domainValue, double step) {
            return (Function1)new Function1<Object, String>((Object)new NumericBreakFormatter(domainValue, step, true)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((NumericBreakFormatter)this.receiver).apply(p0);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0001R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/NonlinearBreaksGen$MultiFormatter;", "", "breakValues", "", "", "breakFormatters", "Lkotlin/Function1;", "", "(Ljava/util/List;Ljava/util/List;)V", "getBreakFormatters", "()Ljava/util/List;", "getBreakValues", "apply", "v", "plot-base-portable"})
    private static final class MultiFormatter {
        @NotNull
        private final List<Double> breakValues;
        @NotNull
        private final List<Function1<Object, String>> breakFormatters;

        /*
         * WARNING - void declaration
         */
        public MultiFormatter(@NotNull List<Double> breakValues, @NotNull List<? extends Function1<Object, String>> breakFormatters) {
            Intrinsics.checkNotNullParameter(breakValues, (String)"breakValues");
            Intrinsics.checkNotNullParameter(breakFormatters, (String)"breakFormatters");
            this.breakValues = breakValues;
            this.breakFormatters = breakFormatters;
            if (!(this.breakValues.size() == this.breakFormatters.size())) {
                boolean $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = false;
                String $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = "MultiFormatter: breakValues.size=" + this.breakValues.size() + " but breakFormatters.size=" + this.breakFormatters.size();
                throw new IllegalStateException($i$a$-check-NonlinearBreaksGen$MultiFormatter$32.toString());
            }
            if (this.breakValues.size() > 1) {
                boolean ordered;
                block8: {
                    boolean bl;
                    void $this$all$iv;
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv;
                    Iterable $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = this.breakValues;
                    boolean $i$f$mapIndexed = false;
                    Iterator iterator2 = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void v;
                        void i;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        double d = ((Number)item$iv$iv).doubleValue();
                        int n2 = n;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(i == false ? 0.0 : v - ((Number)this.breakValues.get((int)(i - true))).doubleValue());
                    }
                    $this$mapIndexed$iv = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            double it = ((Number)element$iv).doubleValue();
                            boolean bl3 = false;
                            if (it >= 0.0) continue;
                            bl = false;
                            break block8;
                        }
                        bl = ordered = true;
                    }
                }
                if (!ordered) {
                    boolean bl = false;
                    String string = "MultiFormatter: values must be sorted in ascending order. Were: " + this.breakValues + '.';
                    throw new IllegalStateException(string.toString());
                }
            }
        }

        @NotNull
        public final List<Double> getBreakValues() {
            return this.breakValues;
        }

        @NotNull
        public final List<Function1<Object, String>> getBreakFormatters() {
            return this.breakFormatters;
        }

        @NotNull
        public final String apply(@NotNull Object v) {
            String string;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Double cfr_ignored_0 = (Double)v;
            if (this.breakValues.isEmpty()) {
                string = v.toString();
            } else {
                int i = Math.abs(CollectionsKt.binarySearch$default(this.breakValues, (Comparable)((Comparable)v), (int)0, (int)0, (int)6, null));
                int ii = Math.min(i, this.breakValues.size() - 1);
                string = (String)this.breakFormatters.get(ii).invoke(v);
            }
            return string;
        }
    }
}

