/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.color;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.common.color.RGBChannelGen;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/common/color/ColorUtil;", "", "()V", "genColors", "", "Ljetbrains/datalore/base/values/Color;", "count", "", "baseColors", "plot-common-portable"})
public final class ColorUtil {
    @NotNull
    public static final ColorUtil INSTANCE = new ColorUtil();

    private ColorUtil() {
    }

    @NotNull
    public final List<Color> genColors(int count, @NotNull List<Color> baseColors) {
        Intrinsics.checkNotNullParameter(baseColors, (String)"baseColors");
        ArrayList<Integer> rValues = new ArrayList<Integer>();
        ArrayList<Integer> gValues = new ArrayList<Integer>();
        ArrayList<Integer> bValues = new ArrayList<Integer>();
        for (Color baseColor : baseColors) {
            rValues.add(baseColor.getRed());
            gValues.add(baseColor.getGreen());
            bValues.add(baseColor.getBlue());
        }
        RGBChannelGen rChannelGen = new RGBChannelGen((List<Integer>)rValues);
        RGBChannelGen gChannelGen = new RGBChannelGen((List<Integer>)gValues);
        RGBChannelGen bChannelGen = new RGBChannelGen((List<Integer>)bValues);
        Iterator<Integer> rValuesGen = rChannelGen.generate(count).iterator();
        Iterator<Integer> gValuesGen = gChannelGen.generate(count).iterator();
        Iterator<Integer> bValuesGen = bChannelGen.generate(count).iterator();
        ArrayList<Color> colorsGen = new ArrayList<Color>(count);
        while (rValuesGen.hasNext() && gValuesGen.hasNext() && bValuesGen.hasNext()) {
            Color colorGen = new Color(((Number)rValuesGen.next()).intValue(), ((Number)gValuesGen.next()).intValue(), ((Number)bValuesGen.next()).intValue(), 0, 8, null);
            colorsGen.add(colorGen);
        }
        return colorsGen;
    }
}

