/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPanel {
    private static final Logger log = LoggerFactory.getLogger(RequestPanel.class);
    private final Deque<RequestView> listRequestView = new ArrayDeque<RequestView>();
    private final JPanel panel;

    public RequestPanel() {
        List classesToAdd = Collections.emptyList();
        try {
            classesToAdd = JMeterUtils.findClassesThatExtend(RequestView.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String rawTab = JMeterUtils.getResString((String)"view_results_table_request_tab_raw");
        RequestView rawObject = null;
        for (String clazz : classesToAdd) {
            try {
                RequestView requestView = Class.forName(clazz).asSubclass(RequestView.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (rawTab.equals(requestView.getLabel())) {
                    rawObject = requestView;
                    continue;
                }
                this.listRequestView.add(requestView);
            }
            catch (NoClassDefFoundError e) {
                log.error("Exception registering implementation: [{}] of interface: [{}], a dependency used by the plugin class is missing", new Object[]{clazz, RequestView.class, e});
            }
            catch (Exception e) {
                log.error("Exception registering implementation: [{}] of interface: [{}], a jar is probably missing", new Object[]{clazz, RequestView.class, e});
            }
        }
        if (rawObject != null) {
            this.listRequestView.addFirst(rawObject);
        }
        JTabbedPane tabbedRequest = new JTabbedPane(3);
        for (RequestView requestView : this.listRequestView) {
            requestView.init();
            tabbedRequest.addTab(requestView.getLabel(), requestView.getPanel());
        }
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(tabbedRequest);
    }

    public void clearData() {
        for (RequestView requestView : this.listRequestView) {
            requestView.clearData();
        }
    }

    public void setSamplerResult(SampleResult samplerResult) {
        for (RequestView requestView : this.listRequestView) {
            requestView.setSamplerResult(samplerResult);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

