/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.jmeter.threads.openmodel.TokenizerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u000e0\u000e*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer;", "", "()V", "IDENTIFIER", "Lkotlin/text/Regex;", "NUMBER", "WHITESPACE", "tokenize", "", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$TokenPosition;", "value", "", "lookingAt", "", "Ljava/util/regex/Matcher;", "pos", "", "prepareMatcher", "kotlin.jvm.PlatformType", "CloseParenthesisToken", "DivideToken", "IdentifierToken", "NumberToken", "OpenParenthesisToken", "Token", "TokenPosition", "ApacheJMeter_core"})
public final class Tokenizer {
    @NotNull
    public static final Tokenizer INSTANCE = new Tokenizer();
    @NotNull
    private static final Regex WHITESPACE = new Regex("(?>\\s+|/\\*(?:(?!\\*/).)*+\\*/)|//[^\\n\\r]*+[\\n\\r]*+");
    @NotNull
    private static final Regex IDENTIFIER = new Regex("\\p{Alpha}(?>\\p{Alnum}|_)*+");
    @NotNull
    private static final Regex NUMBER = new Regex("(?>\\d++(?:\\.\\d++)?|\\.\\d++)");

    private Tokenizer() {
    }

    private final Matcher prepareMatcher(Regex $this$prepareMatcher, String value) {
        return $this$prepareMatcher.toPattern().matcher(value).useAnchoringBounds(false).useTransparentBounds(true).region(0, value.length());
    }

    private final boolean lookingAt(Matcher $this$lookingAt, int pos) {
        return $this$lookingAt.region(pos, $this$lookingAt.regionEnd()).lookingAt();
    }

    @NotNull
    public final List<TokenPosition> tokenize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List res = new ArrayList();
        int pos = 0;
        Matcher mWhitespace = this.prepareMatcher(WHITESPACE, value);
        Matcher mIdentifier = this.prepareMatcher(IDENTIFIER, value);
        Matcher mNumber = this.prepareMatcher(NUMBER, value);
        while (pos < value.length()) {
            Token token;
            Intrinsics.checkNotNullExpressionValue((Object)mWhitespace, (String)"mWhitespace");
            if (this.lookingAt(mWhitespace, pos)) {
                pos = mWhitespace.end();
                continue;
            }
            if (value.charAt(pos) == '(') {
                token = OpenParenthesisToken.INSTANCE;
            } else if (value.charAt(pos) == ')') {
                token = CloseParenthesisToken.INSTANCE;
            } else if (value.charAt(pos) == '/') {
                token = DivideToken.INSTANCE;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)mNumber, (String)"mNumber");
                if (this.lookingAt(mNumber, pos)) {
                    String string = mNumber.group();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mNumber.group()");
                    token = new NumberToken(string);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)mIdentifier, (String)"mIdentifier");
                    if (this.lookingAt(mIdentifier, pos)) {
                        String string = mIdentifier.group();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mIdentifier.group()");
                        token = new IdentifierToken(string);
                    } else {
                        throw new TokenizerException(value, pos, "Unexpected input");
                    }
                }
            }
            Token token2 = token;
            ((Collection)res).add(new TokenPosition(pos, token2));
            pos += token2.getImage().length();
        }
        return res;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$TokenPosition;", "", "pos", "", "token", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "(ILorg/apache/jmeter/threads/openmodel/Tokenizer$Token;)V", "getPos", "()I", "getToken", "()Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "ApacheJMeter_core"})
    public static final class TokenPosition {
        private final int pos;
        @NotNull
        private final Token token;

        public TokenPosition(int pos, @NotNull Token token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.pos = pos;
            this.token = token;
        }

        public final int getPos() {
            return this.pos;
        }

        @NotNull
        public final Token getToken() {
            return this.token;
        }

        @NotNull
        public String toString() {
            return "" + this.token + ':' + this.pos;
        }

        public final int component1() {
            return this.pos;
        }

        @NotNull
        public final Token component2() {
            return this.token;
        }

        @NotNull
        public final TokenPosition copy(int pos, @NotNull Token token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return new TokenPosition(pos, token);
        }

        public static /* synthetic */ TokenPosition copy$default(TokenPosition tokenPosition, int n, Token token, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = tokenPosition.pos;
            }
            if ((n2 & 2) != 0) {
                token = tokenPosition.token;
            }
            return tokenPosition.copy(n, token);
        }

        public int hashCode() {
            int result = Integer.hashCode(this.pos);
            result = result * 31 + this.token.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenPosition)) {
                return false;
            }
            TokenPosition tokenPosition = (TokenPosition)other;
            if (this.pos != tokenPosition.pos) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.token, (Object)tokenPosition.token);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0005\u0006\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "", "image", "", "getImage", "()Ljava/lang/String;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$IdentifierToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$NumberToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$OpenParenthesisToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$CloseParenthesisToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$DivideToken;", "ApacheJMeter_core"})
    public static interface Token {
        @NotNull
        public String getImage();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$IdentifierToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "image", "", "(Ljava/lang/String;)V", "getImage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ApacheJMeter_core"})
    public static final class IdentifierToken
    implements Token {
        @NotNull
        private final String image;

        public IdentifierToken(@NotNull String image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public String getImage() {
            return this.image;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof IdentifierToken && StringsKt.equals((String)this.getImage(), (String)((IdentifierToken)other).getImage(), (boolean)true);
        }

        public int hashCode() {
            String string = this.getImage();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            return string2.hashCode();
        }

        @NotNull
        public String toString() {
            return "Identifier(" + this.getImage() + ')';
        }

        @NotNull
        public final String component1() {
            return this.getImage();
        }

        @NotNull
        public final IdentifierToken copy(@NotNull String image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new IdentifierToken(image);
        }

        public static /* synthetic */ IdentifierToken copy$default(IdentifierToken identifierToken, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = identifierToken.getImage();
            }
            return identifierToken.copy(string);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$NumberToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "image", "", "(Ljava/lang/String;)V", "getImage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ApacheJMeter_core"})
    public static final class NumberToken
    implements Token {
        @NotNull
        private final String image;

        public NumberToken(@NotNull String image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public String getImage() {
            return this.image;
        }

        @NotNull
        public String toString() {
            return "Number(" + this.getImage() + ')';
        }

        @NotNull
        public final String component1() {
            return this.getImage();
        }

        @NotNull
        public final NumberToken copy(@NotNull String image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new NumberToken(image);
        }

        public static /* synthetic */ NumberToken copy$default(NumberToken numberToken, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = numberToken.getImage();
            }
            return numberToken.copy(string);
        }

        public int hashCode() {
            return this.getImage().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NumberToken)) {
                return false;
            }
            NumberToken numberToken = (NumberToken)other;
            return Intrinsics.areEqual((Object)this.getImage(), (Object)numberToken.getImage());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$OpenParenthesisToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "()V", "image", "", "getImage", "()Ljava/lang/String;", "toString", "ApacheJMeter_core"})
    public static final class OpenParenthesisToken
    implements Token {
        @NotNull
        public static final OpenParenthesisToken INSTANCE = new OpenParenthesisToken();

        private OpenParenthesisToken() {
        }

        @Override
        @NotNull
        public String getImage() {
            return "(";
        }

        @NotNull
        public String toString() {
            return "(";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$CloseParenthesisToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "()V", "image", "", "getImage", "()Ljava/lang/String;", "toString", "ApacheJMeter_core"})
    public static final class CloseParenthesisToken
    implements Token {
        @NotNull
        public static final CloseParenthesisToken INSTANCE = new CloseParenthesisToken();

        private CloseParenthesisToken() {
        }

        @Override
        @NotNull
        public String getImage() {
            return ")";
        }

        @NotNull
        public String toString() {
            return ")";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/apache/jmeter/threads/openmodel/Tokenizer$DivideToken;", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "()V", "image", "", "getImage", "()Ljava/lang/String;", "toString", "ApacheJMeter_core"})
    public static final class DivideToken
    implements Token {
        @NotNull
        public static final DivideToken INSTANCE = new DivideToken();

        private DivideToken() {
        }

        @Override
        @NotNull
        public String getImage() {
            return "/";
        }

        @NotNull
        public String toString() {
            return "/";
        }
    }
}

