/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.SplashScreen;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.util.JMeterUtils;

public class AboutCommand
extends AbstractAction {
    private static final Set<String> commandSet;
    private static JDialog about;

    @Override
    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("about")) {
            this.about();
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commandSet;
    }

    private void about() {
        MainFrame mainFrame = GuiPackage.getInstance().getMainFrame();
        JDialog dialog = this.initDialog(mainFrame);
        Point p = mainFrame.getLocationOnScreen();
        Dimension d1 = mainFrame.getSize();
        Dimension d2 = dialog.getSize();
        dialog.setLocation(p.x + (d1.width - d2.width) / 2, p.y + (d1.height - d2.height) / 2);
        dialog.setVisible(true);
    }

    private JDialog initDialog(JFrame mainFrame) {
        if (about != null) {
            return about;
        }
        about = new EscapeDialog(mainFrame, "About Apache JMeter", false);
        about.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                about.setVisible(false);
            }
        });
        JLabel copyright = new JLabel(JMeterUtils.getJMeterCopyright(), 0);
        JLabel rights = new JLabel("All Rights Reserved.", 0);
        JLabel version = new JLabel("Apache JMeter Version " + JMeterUtils.getJMeterVersion(), 0);
        JLabel releaseNotes = new JLabel("<html><a href=\"https://jmeter.apache.org/changes.html\">Release notes</a></html>", 0);
        releaseNotes.setCursor(Cursor.getPredefinedCursor(12));
        releaseNotes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "link_release_notes"));
                }
            }
        });
        JPanel infos = new JPanel();
        infos.setOpaque(false);
        infos.setLayout(new GridLayout(0, 1));
        infos.setBorder(new EmptyBorder(5, 5, 5, 5));
        infos.add(copyright);
        infos.add(rights);
        infos.add(version);
        infos.add(releaseNotes);
        Container panel = about.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)SplashScreen.loadLogo(), "North");
        panel.add((Component)infos, "South");
        about.pack();
        return about;
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("about");
        commandSet = Collections.unmodifiableSet(commands);
    }
}

