/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.coord.Projection;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.coord.CoordProviderBase;
import jetbrains.datalore.plot.builder.coord.FixedRatioCoordProvider;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ<\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J,\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J:\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/coord/ProjectionCoordProvider;", "Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "projectionX", "Ljetbrains/datalore/plot/base/coord/Projection;", "projectionY", "xLim", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "yLim", "flipped", "", "(Ljetbrains/datalore/plot/base/coord/Projection;Ljetbrains/datalore/plot/base/coord/Projection;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Z)V", "adjustDomainsIntern", "Lkotlin/Pair;", "hDomain", "vDomain", "adjustGeomSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "geomSize", "buildAxisScaleX", "Ljetbrains/datalore/plot/base/Scale;", "scaleProto", "domain", "axisLength", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "buildAxisScaleY", "with", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "Companion", "plot-builder-portable"})
public final class ProjectionCoordProvider
extends CoordProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Projection projectionX;
    @NotNull
    private final Projection projectionY;

    public ProjectionCoordProvider(@NotNull Projection projectionX, @NotNull Projection projectionY, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter((Object)projectionX, (String)"projectionX");
        Intrinsics.checkNotNullParameter((Object)projectionY, (String)"projectionY");
        super(xLim, yLim, flipped);
        this.projectionX = projectionX;
        this.projectionY = projectionY;
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, boolean flipped) {
        return new ProjectionCoordProvider(this.projectionX, this.projectionY, xLim, yLim, flipped);
    }

    @Override
    @NotNull
    protected Pair<ClosedRange<Double>, ClosedRange<Double>> adjustDomainsIntern(@NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain) {
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        ClosedRange xDomain = this.projectionX.toValidDomain(hDomain);
        ClosedRange yDomain = this.projectionY.toValidDomain(vDomain);
        return TuplesKt.to((Object)xDomain, (Object)yDomain);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double h0 = this.projectionX.apply(((Number)((Object)hDomain.getLowerEnd())).doubleValue());
        double h1 = this.projectionX.apply(((Number)((Object)hDomain.getUpperEnd())).doubleValue());
        double v0 = this.projectionY.apply(((Number)((Object)vDomain.getLowerEnd())).doubleValue());
        double v1 = this.projectionY.apply(((Number)((Object)vDomain.getUpperEnd())).doubleValue());
        double d = h1 - h0;
        boolean bl = false;
        double d2 = Math.abs(d);
        d = v1 - v0;
        bl = false;
        double domainRatio = d2 / Math.abs(d);
        return FixedRatioCoordProvider.Companion.reshapeGeom(geomSize, domainRatio);
    }

    @Override
    @NotNull
    public Scale<Double> buildAxisScaleX(@NotNull Scale<Double> scaleProto, @NotNull ClosedRange<Double> domain, double axisLength, @NotNull ScaleBreaks breaks) {
        Intrinsics.checkNotNullParameter(scaleProto, (String)"scaleProto");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        return this.projectionX.getNonlinear() ? ProjectionCoordProvider.Companion.buildAxisScaleWithProjection(this.projectionX, (Scale<Double>)scaleProto, (ClosedRange<Double>)domain, axisLength, breaks) : super.buildAxisScaleX(scaleProto, domain, axisLength, breaks);
    }

    @Override
    @NotNull
    public Scale<Double> buildAxisScaleY(@NotNull Scale<Double> scaleProto, @NotNull ClosedRange<Double> domain, double axisLength, @NotNull ScaleBreaks breaks) {
        Intrinsics.checkNotNullParameter(scaleProto, (String)"scaleProto");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        return this.projectionY.getNonlinear() ? ProjectionCoordProvider.Companion.buildAxisScaleWithProjection(this.projectionY, (Scale<Double>)scaleProto, (ClosedRange<Double>)domain, axisLength, breaks) : super.buildAxisScaleY(scaleProto, domain, axisLength, breaks);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002JL\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/coord/ProjectionCoordProvider$Companion;", "", "()V", "buildAxisScaleWithProjection", "Ljetbrains/datalore/plot/base/Scale;", "", "projection", "Ljetbrains/datalore/plot/base/coord/Projection;", "scaleProto", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "axisLength", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "twistScaleMapper", "Lkotlin/Function1;", "projectionInverse", "scaleMapper", "validateBreaks", "validDomain", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Scale<Double> buildAxisScaleWithProjection(Projection projection, Scale<Double> scaleProto, ClosedRange<Double> domain, double axisLength, ScaleBreaks breaks) {
            ClosedRange validDomain = projection.toValidDomain(domain);
            ClosedRange validDomainProjected = new ClosedRange((Comparable)Double.valueOf(projection.apply(((Number)((Object)validDomain.getLowerEnd())).doubleValue())), (Comparable)Double.valueOf(projection.apply(((Number)((Object)validDomain.getUpperEnd())).doubleValue())));
            Function1 projectionInverse = Mappers.linear$default((Mappers)Mappers.INSTANCE, (ClosedRange)validDomainProjected, (ClosedRange)validDomain, (boolean)false, (int)4, null);
            Function1<Double, Double> linearMapper = CoordProviderBase.Companion.linearMapper(domain, axisLength);
            Function1<Double, Double> scaleMapper = this.twistScaleMapper(projection, (Function1<? super Double, Double>)projectionInverse, linearMapper);
            ScaleBreaks validBreaks = this.validateBreaks((ClosedRange<Double>)validDomain, breaks);
            return CoordProviderBase.Companion.buildAxisScaleDefault(scaleProto, scaleMapper, validBreaks);
        }

        private final ScaleBreaks validateBreaks(ClosedRange<Double> validDomain, ScaleBreaks breaks) {
            ArrayList<Integer> validIndices = new ArrayList<Integer>();
            int i = 0;
            for (Object v : breaks.getDomainValues()) {
                if (v instanceof Double && validDomain.contains((Comparable)v)) {
                    validIndices.add(i);
                }
                int n = i;
                i = n + 1;
            }
            if (validIndices.size() == breaks.getDomainValues().size()) {
                return breaks;
            }
            List validDomainValues = SeriesUtil.INSTANCE.pickAtIndices(breaks.getDomainValues(), (List)validIndices);
            List validLabels = SeriesUtil.INSTANCE.pickAtIndices(breaks.getLabels(), (List)validIndices);
            List validTransformedValues = SeriesUtil.INSTANCE.pickAtIndices(breaks.getTransformedValues(), (List)validIndices);
            return new ScaleBreaks(validDomainValues, validTransformedValues, validLabels);
        }

        private final Function1<Double, Double> twistScaleMapper(Projection projection, Function1<? super Double, Double> projectionInverse, Function1<? super Double, Double> scaleMapper) {
            return (Function1)new Function1<Double, Double>(projection, projectionInverse, scaleMapper){
                final /* synthetic */ Projection $projection;
                final /* synthetic */ Function1<Double, Double> $projectionInverse;
                final /* synthetic */ Function1<Double, Double> $scaleMapper;
                {
                    this.$projection = $projection;
                    this.$projectionInverse = $projectionInverse;
                    this.$scaleMapper = $scaleMapper;
                    super(1);
                }

                @Nullable
                public final Double invoke(@Nullable Double v) {
                    Double d;
                    Double d2 = v;
                    if (d2 == null) {
                        d = null;
                    } else {
                        Double d3 = d2;
                        Projection projection = this.$projection;
                        Function1<Double, Double> function1 = this.$projectionInverse;
                        Function1<Double, Double> function12 = this.$scaleMapper;
                        boolean bl = false;
                        boolean bl2 = false;
                        double $this$invoke_u24lambda_u2d0 = ((Number)d3).doubleValue();
                        boolean bl3 = false;
                        double projected = projection.apply(v.doubleValue());
                        double unProjected = ((Number)function1.invoke((Object)projected)).doubleValue();
                        d = (Double)function12.invoke((Object)unProjected);
                    }
                    return d;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

