/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.upload.impl;

import java.io.File;
import jodd.io.upload.FileUpload;
import jodd.io.upload.FileUploadFactory;
import jodd.io.upload.MultipartRequestInputStream;
import jodd.io.upload.impl.AdaptiveFileUpload;

public class AdaptiveFileUploadFactory
implements FileUploadFactory {
    protected int memoryThreshold = 8192;
    protected File uploadPath;
    protected int maxFileSize = 102400;
    protected boolean breakOnError;
    protected String[] fileExtensions;
    protected boolean allowFileExtensions = true;

    @Override
    public FileUpload create(MultipartRequestInputStream input) {
        return new AdaptiveFileUpload(input, this.memoryThreshold, this.uploadPath, this.maxFileSize, this.breakOnError, this.fileExtensions, this.allowFileExtensions);
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public AdaptiveFileUploadFactory setMemoryThreshold(int memoryThreshold) {
        if (memoryThreshold >= 0) {
            this.memoryThreshold = memoryThreshold;
        }
        return this;
    }

    public File getUploadPath() {
        return this.uploadPath;
    }

    public AdaptiveFileUploadFactory setUploadPath(File uploadPath) {
        this.uploadPath = uploadPath;
        return this;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public AdaptiveFileUploadFactory setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public AdaptiveFileUploadFactory setBreakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public AdaptiveFileUploadFactory breakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public AdaptiveFileUploadFactory setFileExtensions(String[] fileExtensions, boolean allow) {
        this.fileExtensions = fileExtensions;
        this.allowFileExtensions = allow;
        return this;
    }
}

