/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.lang.GenericReflection;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SerializationHelper {
    private SerializationHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static byte[] getSerializedByteArray(@Nonnull Serializable serializable) {
        ValueEnforcer.notNull(serializable, "Data");
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            try (Object object = new ObjectOutputStream(nonBlockingByteArrayOutputStream);){
                ((ObjectOutputStream)object).writeObject(serializable);
            }
            object = nonBlockingByteArrayOutputStream.toByteArray();
            return object;
        }
        catch (NotSerializableException notSerializableException) {
            throw new IllegalArgumentException("Not serializable: " + notSerializableException.getMessage(), notSerializableException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to write serializable object " + serializable + " of type " + serializable.getClass().getName(), iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static <T> T getDeserializedObject(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Data");
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new NonBlockingByteArrayInputStream(byArray));){
            Object DSTTYPE = GenericReflection.uncheckedCast(objectInputStream.readObject());
            return (T)DSTTYPE;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to read serializable object", exception);
        }
    }
}

