/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegexpHTMLParser
extends HTMLParser {
    private static final Logger log = LoggerFactory.getLogger(RegexpHTMLParser.class);
    private static final String VALUE = "\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))";
    private static final String SEP = "\\s(?:[^>]*\\s)?";
    private static final String REGEXP = "<(?:!--.*?-->|BASE\\s(?:[^>]*\\s)?HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:IMG|SCRIPT|FRAME|IFRAME|BGSOUND)\\s(?:[^>]*\\s)?SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|APPLET\\s(?:[^>]*\\s)?CODE(?:BASE)?\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:EMBED|OBJECT)\\s(?:[^>]*\\s)?(?:SRC|CODEBASE|DATA)\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:BODY|TABLE|TR|TD)\\s(?:[^>]*\\s)?BACKGROUND\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|[^<]+?STYLE\\s*=['\"].*?URL\\(\\s*['\"](.+?)['\"]\\s*\\)|INPUT(?:\\s(?:[^>]*\\s)?(?:SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|TYPE\\s*=\\s*(?:\"image\"|'image'|image(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"stylesheet\"|'stylesheet'|stylesheet(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"icon\"|'icon'|icon(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"shortcut icon\"|'shortcut icon'|shortcut icon(?=[\\s>])))){2,})";
    private static final Pattern HTML_PATTERN = Pattern.compile("<(?:!--.*?-->|BASE\\s(?:[^>]*\\s)?HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:IMG|SCRIPT|FRAME|IFRAME|BGSOUND)\\s(?:[^>]*\\s)?SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|APPLET\\s(?:[^>]*\\s)?CODE(?:BASE)?\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:EMBED|OBJECT)\\s(?:[^>]*\\s)?(?:SRC|CODEBASE|DATA)\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:BODY|TABLE|TR|TD)\\s(?:[^>]*\\s)?BACKGROUND\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|[^<]+?STYLE\\s*=['\"].*?URL\\(\\s*['\"](.+?)['\"]\\s*\\)|INPUT(?:\\s(?:[^>]*\\s)?(?:SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|TYPE\\s*=\\s*(?:\"image\"|'image'|image(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"stylesheet\"|'stylesheet'|stylesheet(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"icon\"|'icon'|icon(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"shortcut icon\"|'shortcut icon'|shortcut icon(?=[\\s>])))){2,})", 34);
    private static final int NUM_BASE_GROUPS = 3;
    private static final ThreadLocal<PatternMatcherInput> localInput = ThreadLocal.withInitial(() -> new PatternMatcherInput(new char[0]));
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");

    protected RegexpHTMLParser() {
    }

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        if (USE_JAVA_REGEX) {
            return this.getEmbeddedResourceURLsWithJavaRegex(html, baseUrl, urls, encoding);
        }
        return this.getEmbeddedResourceURLsWithOroRegex(html, baseUrl, urls, encoding);
    }

    private Iterator<URL> getEmbeddedResourceURLsWithJavaRegex(byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        try {
            String input = new String(html, encoding);
            Matcher matcher = HTML_PATTERN.matcher(input);
            while (matcher.find()) {
                String s;
                int g;
                java.util.regex.MatchResult match = matcher.toMatchResult();
                if (log.isDebugEnabled()) {
                    log.debug("match groups {} {}", (Object)match.groupCount(), (Object)match);
                }
                for (g = 1; g <= 3 && g <= match.groupCount(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    log.debug("new baseUrl: {} - {}", (Object)s, (Object)baseUrl);
                    try {
                        baseUrl = ConversionUtils.makeRelativeURL(baseUrl, s);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        log.debug("Can't build base URL from URL {} in page {}", new Object[]{s, baseUrl, e});
                    }
                }
                for (g = 4; g <= match.groupCount(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("group {} - {}", (Object)g, (Object)match.group(g));
                    }
                    urls.addURL(s, baseUrl);
                }
            }
            return urls.iterator();
        }
        catch (UnsupportedEncodingException | PatternSyntaxException e) {
            throw new HTMLParseException(e.getMessage(), e);
        }
    }

    private Iterator<URL> getEmbeddedResourceURLsWithOroRegex(byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        Iterator<URL> iterator;
        org.apache.oro.text.regex.Pattern pattern = null;
        Perl5Matcher matcher = null;
        try {
            matcher = JMeterUtils.getMatcher();
            PatternMatcherInput input = localInput.get();
            input.setInput(new String(html, encoding));
            pattern = JMeterUtils.getPatternCache().getPattern(REGEXP, 32785);
            while (matcher.contains(input, pattern)) {
                String s;
                int g;
                MatchResult match = matcher.getMatch();
                if (log.isDebugEnabled()) {
                    log.debug("match groups {} {}", (Object)match.groups(), (Object)match);
                }
                for (g = 1; g <= 3 && g <= match.groups(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    log.debug("new baseUrl: {} - {}", (Object)s, (Object)baseUrl);
                    try {
                        baseUrl = ConversionUtils.makeRelativeURL(baseUrl, s);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        log.debug("Can't build base URL from URL {} in page {}", new Object[]{s, baseUrl, e});
                    }
                }
                for (g = 4; g <= match.groups(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("group {} - {}", (Object)g, (Object)match.group(g));
                    }
                    urls.addURL(s, baseUrl);
                }
            }
            iterator = urls.iterator();
        }
        catch (UnsupportedEncodingException | MalformedCachePatternException e) {
            try {
                throw new HTMLParseException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, pattern);
                throw throwable;
            }
        }
        JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, (org.apache.oro.text.regex.Pattern)pattern);
        return iterator;
    }
}

