/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.protocol.http.modifier.RegExUserParameters;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="regex_params_title")
public class RegExUserParametersGui
extends AbstractPreProcessorGui {
    private static final long serialVersionUID = 3080808672311046276L;
    private JLabeledTextField refRegExRefNameField;
    private JLabeledTextField paramNamesGrNrField;
    private JLabeledTextField paramValuesGrNrField;

    public RegExUserParametersGui() {
        this.init();
    }

    public String getLabelResource() {
        return "regex_params_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof RegExUserParameters) {
            RegExUserParameters re = (RegExUserParameters)el;
            this.paramNamesGrNrField.setText(re.getRegParamNamesGrNr());
            this.paramValuesGrNrField.setText(re.getRegExParamValuesGrNr());
            this.refRegExRefNameField.setText(re.getRegExRefName());
        }
    }

    public TestElement createTestElement() {
        RegExUserParameters regExUserParams = new RegExUserParameters();
        this.modifyTestElement((TestElement)regExUserParams);
        return regExUserParams;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof RegExUserParameters) {
            RegExUserParameters regExUserParams = (RegExUserParameters)extractor;
            regExUserParams.setRegExRefName(this.refRegExRefNameField.getText());
            regExUserParams.setRegExParamNamesGrNr(this.paramNamesGrNrField.getText());
            regExUserParams.setRegExParamValuesGrNr(this.paramValuesGrNrField.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.paramNamesGrNrField.setText("");
        this.paramValuesGrNrField.setText("");
        this.refRegExRefNameField.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        this.refRegExRefNameField = new JLabeledTextField(JMeterUtils.getResString((String)"regex_params_ref_name_field"));
        this.paramNamesGrNrField = new JLabeledTextField(JMeterUtils.getResString((String)"regex_params_names_field"));
        this.paramValuesGrNrField = new JLabeledTextField(JMeterUtils.getResString((String)"regex_params_values_field"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refRegExRefNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.paramNamesGrNrField, gbc);
        this.resetContraints(gbc);
        gbc.weighty = 1.0;
        this.addField(panel, this.paramValuesGrNrField, gbc);
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

