/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class URLRewritingModifier
extends AbstractTestElement
implements Serializable,
PreProcessor {
    private static final long serialVersionUID = 233L;
    private static final String SEMI_COLON = ";";
    private transient Function<String, String> pathExtensionEqualsQuestionmarkExtractor;
    private transient Function<String, String> pathExtensionEqualsNoQuestionmarkExtractor;
    private transient Function<String, String> pathExtensionNoEqualsQuestionmarkExtractor;
    private transient Function<String, String> pathExtensionNoEqualsNoQuestionmarkExtractor;
    private transient Function<String, String> parameterExtractor;
    private static final String ARGUMENT_NAME = "argument_name";
    private static final String PATH_EXTENSION = "path_extension";
    private static final String PATH_EXTENSION_NO_EQUALS = "path_extension_no_equals";
    private static final String PATH_EXTENSION_NO_QUESTIONMARK = "path_extension_no_questionmark";
    private static final String SHOULD_CACHE = "cache_value";
    private static final String ENCODE = "encode";
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");
    private transient String savedValue = "";

    public void process() {
        JMeterContext ctx = this.getThreadContext();
        Sampler sampler = ctx.getCurrentSampler();
        if (!(sampler instanceof HTTPSamplerBase)) {
            return;
        }
        SampleResult responseText = ctx.getPreviousResult();
        if (responseText == null) {
            return;
        }
        this.initRegex(this.getArgumentName());
        String text = responseText.getResponseDataAsString();
        String value = this.isPathExtension() && this.isPathExtensionNoEquals() && this.isPathExtensionNoQuestionmark() ? this.pathExtensionNoEqualsNoQuestionmarkExtractor.apply(text) : (this.isPathExtension() && this.isPathExtensionNoEquals() ? this.pathExtensionNoEqualsQuestionmarkExtractor.apply(text) : (this.isPathExtension() && this.isPathExtensionNoQuestionmark() ? this.pathExtensionEqualsNoQuestionmarkExtractor.apply(text) : (this.isPathExtension() ? this.pathExtensionEqualsQuestionmarkExtractor.apply(text) : this.parameterExtractor.apply(text))));
        if (this.shouldCache()) {
            if (value == null || value.isEmpty()) {
                value = this.savedValue;
            } else {
                this.savedValue = value;
            }
        }
        this.modify((HTTPSamplerBase)sampler, value);
    }

    private void modify(HTTPSamplerBase sampler, String value) {
        if (this.isPathExtension()) {
            String oldPath = sampler.getPath();
            int indexOfSessionId = oldPath.indexOf(SEMI_COLON + this.getArgumentName());
            if (oldPath.contains(SEMI_COLON + this.getArgumentName())) {
                int indexOfQuestionMark = oldPath.indexOf(63);
                oldPath = indexOfQuestionMark < 0 ? oldPath.substring(0, indexOfSessionId) : oldPath.substring(0, indexOfSessionId) + oldPath.substring(indexOfQuestionMark);
            }
            if (this.isPathExtensionNoEquals()) {
                sampler.setPath(oldPath + SEMI_COLON + this.getArgumentName() + value);
            } else {
                sampler.setPath(oldPath + SEMI_COLON + this.getArgumentName() + "=" + value);
            }
        } else {
            sampler.getArguments().removeArgument(this.getArgumentName());
            sampler.getArguments().addArgument((Argument)new HTTPArgument(this.getArgumentName(), value, !this.encode()));
        }
    }

    public void setArgumentName(String argName) {
        this.setProperty(ARGUMENT_NAME, argName);
    }

    private void initRegex(String argName) {
        String quotedArg = Perl5Compiler.quotemeta((String)argName);
        this.pathExtensionEqualsQuestionmarkExtractor = this.generateExtractor(SEMI_COLON + quotedArg + "=([^\"'<>&\\s;]*)");
        this.pathExtensionEqualsNoQuestionmarkExtractor = this.generateExtractor(SEMI_COLON + quotedArg + "=([^\"'<>&\\s;?]*)");
        this.pathExtensionNoEqualsQuestionmarkExtractor = this.generateExtractor(SEMI_COLON + quotedArg + "([^\"'<>&\\s;]*)");
        this.pathExtensionNoEqualsNoQuestionmarkExtractor = this.generateExtractor(SEMI_COLON + quotedArg + "([^\"'<>&\\s;?]*)");
        this.parameterExtractor = this.generateFirstMatchExtractor("[;\\?&]" + quotedArg + "=([^\"'<>&\\s;\\\\]*)|\\s[Nn][Aa][Mm][Ee]\\s*=\\s*[\"']" + quotedArg + "[\"'][^>]*\\s[vV][Aa][Ll][Uu][Ee]\\s*=\\s*[\"']([^\"']*)[\"']|\\s[vV][Aa][Ll][Uu][Ee]\\s*=\\s*[\"']([^\"']*)[\"'][^>]*\\s[Nn][Aa][Mm][Ee]\\s*=\\s*[\"']" + quotedArg + "[\"']");
    }

    private Function<String, String> generateExtractor(String regex) {
        if (USE_JAVA_REGEX) {
            return this.generateExtractorWithJavaRegex(regex);
        }
        return this.generateExtractorWithOroRegex(regex);
    }

    private Function<String, String> generateExtractorWithJavaRegex(String regex) {
        java.util.regex.Pattern pattern = JMeterUtils.compilePattern((String)regex, (int)8);
        return text -> {
            Matcher matcher = pattern.matcher((CharSequence)text);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return "";
        };
    }

    private Function<String, String> generateExtractorWithOroRegex(String regex) {
        Pattern pattern = JMeterUtils.getPatternCache().getPattern(regex, 32776);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        return text -> {
            if (matcher.contains(text, pattern)) {
                MatchResult result = matcher.getMatch();
                return result.group(1);
            }
            return "";
        };
    }

    private Function<String, String> generateFirstMatchExtractor(String regex) {
        if (USE_JAVA_REGEX) {
            return this.generateFirstMatchExtractorWithJavaRegex(regex);
        }
        return this.generateFirstMatchExtractorWithOroRegex(regex);
    }

    private Function<String, String> generateFirstMatchExtractorWithJavaRegex(String regex) {
        java.util.regex.Pattern pattern = JMeterUtils.compilePattern((String)regex, (int)8);
        return text -> {
            Matcher matcher = pattern.matcher((CharSequence)text);
            if (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String value = matcher.group(i);
                    if (value == null) continue;
                    return value;
                }
            }
            return "";
        };
    }

    private Function<String, String> generateFirstMatchExtractorWithOroRegex(String regex) {
        Pattern pattern = JMeterUtils.getPatternCache().getPattern(regex, 32776);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        return text -> {
            if (matcher.contains(text, pattern)) {
                MatchResult result = matcher.getMatch();
                for (int i = 1; i < result.groups(); ++i) {
                    String value = result.group(i);
                    if (value == null) continue;
                    return value;
                }
            }
            return "";
        };
    }

    public String getArgumentName() {
        return this.getPropertyAsString(ARGUMENT_NAME);
    }

    public void setPathExtension(boolean pathExt) {
        this.setProperty((JMeterProperty)new BooleanProperty(PATH_EXTENSION, pathExt));
    }

    public void setPathExtensionNoEquals(boolean pathExtNoEquals) {
        this.setProperty((JMeterProperty)new BooleanProperty(PATH_EXTENSION_NO_EQUALS, pathExtNoEquals));
    }

    public void setPathExtensionNoQuestionmark(boolean pathExtNoQuestionmark) {
        this.setProperty((JMeterProperty)new BooleanProperty(PATH_EXTENSION_NO_QUESTIONMARK, pathExtNoQuestionmark));
    }

    public void setShouldCache(boolean b) {
        this.setProperty((JMeterProperty)new BooleanProperty(SHOULD_CACHE, b));
    }

    public boolean isPathExtension() {
        return this.getPropertyAsBoolean(PATH_EXTENSION);
    }

    public boolean isPathExtensionNoEquals() {
        return this.getPropertyAsBoolean(PATH_EXTENSION_NO_EQUALS);
    }

    public boolean isPathExtensionNoQuestionmark() {
        return this.getPropertyAsBoolean(PATH_EXTENSION_NO_QUESTIONMARK);
    }

    public boolean shouldCache() {
        return this.getPropertyAsBoolean(SHOULD_CACHE, true);
    }

    protected Object readResolve() {
        this.savedValue = "";
        return this;
    }

    public boolean encode() {
        return this.getPropertyAsBoolean(ENCODE, false);
    }

    public void setEncode(boolean b) {
        this.setProperty((JMeterProperty)new BooleanProperty(ENCODE, b));
    }
}

