/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.config.GeoDataFrameProcessor;
import jetbrains.datalore.plot.config.GeoReferenceProcessor;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.OptionsSelectorKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/config/GeoConfig;", "", "geomKind", "Ljetbrains/datalore/plot/base/GeomKind;", "dataFrame", "Ljetbrains/datalore/plot/base/DataFrame;", "layerOptions", "", "mappingOptions", "(Ljetbrains/datalore/plot/base/GeomKind;Ljetbrains/datalore/plot/base/DataFrame;Ljava/util/Map;Ljava/util/Map;)V", "dataAndCoordinates", "getDataAndCoordinates", "()Ljetbrains/datalore/plot/base/DataFrame;", "mappings", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "getMappings", "()Ljava/util/Map;", "Companion", "plot-config-portable"})
public final class GeoConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFrame dataAndCoordinates;
    @NotNull
    private final Map<Aes<?>, DataFrame.Variable> mappings;
    @NotNull
    public static final String GEO_ID = "__geo_id__";
    @NotNull
    public static final String POINT_X = "lon";
    @NotNull
    public static final String POINT_Y = "lat";
    @NotNull
    public static final String RECT_XMIN = "lonmin";
    @NotNull
    public static final String RECT_YMIN = "latmin";
    @NotNull
    public static final String RECT_XMAX = "lonmax";
    @NotNull
    public static final String RECT_YMAX = "latmax";
    @NotNull
    public static final String MAP_JOIN_REQUIRED_MESSAGE = "map_join is required when both data and map parameters used";

    /*
     * Enabled aggressive block sorting
     */
    public GeoConfig(@NotNull GeomKind geomKind, @NotNull DataFrame dataFrame, @NotNull Map<?, ?> layerOptions, @NotNull Map<?, ?> mappingOptions) {
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
        Intrinsics.checkNotNullParameter(mappingOptions, (String)"mappingOptions");
        Object object = new String[]{"map_data_meta", "geodataframe"};
        if (!OptionsSelectorKt.has(layerOptions, (String[])object)) {
            object = new String[]{"data_meta", "geodataframe"};
            if (!OptionsSelectorKt.has(layerOptions, (String[])object)) {
                object = new String[]{"map_data_meta", "georeference"};
                if (!OptionsSelectorKt.has(layerOptions, (String[])object)) throw new IllegalStateException();
                object = new GeoReferenceProcessor(dataFrame, layerOptions, mappingOptions);
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                this.dataAndCoordinates = ((GeoReferenceProcessor)it).getProcessedDataFrame();
                this.mappings = ((GeoReferenceProcessor)it).getProcessedMappings();
                return;
            }
        }
        object = new GeoDataFrameProcessor(geomKind, dataFrame, layerOptions, mappingOptions);
        boolean bl = false;
        boolean bl4 = false;
        String[] it = object;
        boolean bl5 = false;
        this.dataAndCoordinates = it.getDataAndCoordinates();
        this.mappings = it.getMappings();
    }

    @NotNull
    public final DataFrame getDataAndCoordinates() {
        return this.dataAndCoordinates;
    }

    @NotNull
    public final Map<Aes<?>, DataFrame.Variable> getMappings() {
        return this.mappings;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\u00042\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J&\u0010\u0010\u001a\u00020\u00112\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ\u001e\u0010\u0013\u001a\u00020\u00112\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/config/GeoConfig$Companion;", "", "()V", "GEO_ID", "", "MAP_JOIN_REQUIRED_MESSAGE", "POINT_X", "POINT_Y", "RECT_XMAX", "RECT_XMIN", "RECT_YMAX", "RECT_YMIN", "getGeometryColumn", "layerOptions", "", "gdfRole", "isApplicable", "", "combinedMappings", "isGeoDataframe", "toDataMetaKey", "plot-config-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isApplicable(@NotNull Map<?, ?> layerOptions, @NotNull Map<?, ?> combinedMappings) {
            boolean bl;
            block8: {
                void $this$any$iv;
                boolean bl2;
                Object object;
                Object it;
                boolean bl3;
                Object element$iv$iv;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
                Intrinsics.checkNotNullParameter(combinedMappings, (String)"combinedMappings");
                Iterable $this$mapNotNull$iv = combinedMappings.keySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    bl3 = false;
                    it = element$iv$iv;
                    boolean bl4 = false;
                    if ((it instanceof String ? (String)it : null) == null) continue;
                    object = object;
                    bl2 = false;
                    boolean bl5 = false;
                    String it$iv$iv = object;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Aes aes;
                    Object object2;
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    bl3 = false;
                    it = (String)element$iv$iv;
                    boolean bl7 = false;
                    object = Companion;
                    bl2 = false;
                    try {
                        object2 = Result.Companion;
                        Object $this$isApplicable_u24lambda_u2d2_u24lambda_u2d1 = object;
                        boolean bl8 = false;
                        Aes<?> aes2 = Option.Mapping.INSTANCE.toAes((String)it);
                        boolean bl9 = false;
                        object2 = Result.constructor-impl(aes2);
                    }
                    catch (Throwable throwable) {
                        Result.Companion companion = Result.Companion;
                        boolean bl10 = false;
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = object2;
                    bl2 = false;
                    if ((Aes)(Result.isFailure-impl((Object)object) ? null : object) == null) continue;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    Aes it$iv$iv = aes;
                    boolean bl13 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                Aes.Companion companion = Aes.Companion;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Aes p0 = (Aes)element$iv;
                        boolean bl14 = false;
                        if (!companion.isPositional(p0)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            String[] stringArray = new String[]{"map_data_meta", "geodataframe", "geometry"};
            return OptionsSelectorKt.has(layerOptions, stringArray) || OptionsSelectorKt.has(layerOptions, stringArray = new String[]{"data_meta", "geodataframe", "geometry"}) || OptionsSelectorKt.has(layerOptions, stringArray = new String[]{"map_data_meta", "georeference"}) || OptionsSelectorKt.has(layerOptions, stringArray = new String[]{"data_meta", "georeference"});
        }

        public final boolean isGeoDataframe(@NotNull Map<?, ?> layerOptions, @NotNull String gdfRole) {
            Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
            Intrinsics.checkNotNullParameter((Object)gdfRole, (String)"gdfRole");
            String[] stringArray = new String[]{this.toDataMetaKey(gdfRole), "geodataframe", "geometry"};
            return OptionsSelectorKt.has(layerOptions, stringArray);
        }

        @NotNull
        public final String getGeometryColumn(@NotNull Map<?, ?> layerOptions, @NotNull String gdfRole) {
            Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
            Intrinsics.checkNotNullParameter((Object)gdfRole, (String)"gdfRole");
            Object object = new String[]{this.toDataMetaKey(gdfRole), "geodataframe", "geometry"};
            String string = OptionsSelectorKt.getString(layerOptions, (String[])object);
            if (string == null) {
                object = "Geometry column not set";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            return string;
        }

        private final String toDataMetaKey(String gdfRole) {
            String string;
            String string2 = gdfRole;
            if (Intrinsics.areEqual((Object)string2, (Object)"map")) {
                string = "map_data_meta";
            } else if (Intrinsics.areEqual((Object)string2, (Object)"data")) {
                string = "data_meta";
            } else {
                String string3 = "Unknown gdf role: '" + gdfRole + "'. Expected: 'map' or 'data'";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

