/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.base.pos.StackPos;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/pos/FillPos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "myScalerByIndex", "", "", "", "myStackPosHelper", "handlesGroups", "", "mapIndexToScaler", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-base-portable"})
public final class FillPos
implements PositionAdjustment {
    @NotNull
    private final PositionAdjustment myStackPosHelper;
    @NotNull
    private final Map<Integer, Double> myScalerByIndex;

    public FillPos(@NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        this.myStackPosHelper = StackPos.Companion.splitPositiveNegative(aes);
        this.myScalerByIndex = this.mapIndexToScaler(aes);
    }

    private final Map<Integer, Double> mapIndexToScaler(Aesthetics aes) {
        boolean bl;
        HashMap posMaxByBin = new HashMap();
        HashMap negMaxByBin = new HashMap();
        int n = 0;
        int n2 = aes.dataPointCount();
        if (n < n2) {
            do {
                Double d;
                boolean bl2;
                Double y2;
                int i;
                DataPointAesthetics dataPoint;
                Double x2;
                if (!SeriesUtil.INSTANCE.isFinite(x2 = (dataPoint = aes.dataPointAt(i = n++)).x())) continue;
                Map map2 = posMaxByBin;
                boolean bl3 = false;
                if (!map2.containsKey(x2)) {
                    map2 = posMaxByBin;
                    Double d2 = x2;
                    Intrinsics.checkNotNull((Object)d2);
                    Double d3 = d2;
                    Double d4 = 0.0;
                    bl = false;
                    map2.put(d3, d4);
                    map2 = negMaxByBin;
                    d3 = 0.0;
                    boolean bl4 = false;
                    map2.put(x2, d3);
                }
                if (!SeriesUtil.INSTANCE.isFinite(y2 = dataPoint.y())) continue;
                Double d5 = y2;
                Intrinsics.checkNotNull((Object)d5);
                if (d5 >= 0.0) {
                    Double d6;
                    Map map3 = posMaxByBin;
                    Intrinsics.checkNotNull((Object)x2);
                    Object v = posMaxByBin.get(x2);
                    Intrinsics.checkNotNull(v);
                    Double d7 = ((Number)v).doubleValue() + y2;
                    bl2 = false;
                    map3.put(d6, d7);
                    continue;
                }
                Map map4 = negMaxByBin;
                Intrinsics.checkNotNull((Object)x2);
                Object v = negMaxByBin.get(x2);
                Intrinsics.checkNotNull(v);
                Double d8 = ((Number)v).doubleValue() - y2;
                bl2 = false;
                map4.put(d, d8);
            } while (n < n2);
        }
        HashMap scalerByIndex = new HashMap();
        n2 = 0;
        int n3 = aes.dataPointCount();
        if (n2 < n3) {
            do {
                boolean bl5;
                Object object;
                Integer n4;
                int i = n2++;
                DataPointAesthetics dataPoint = aes.dataPointAt(i);
                Double x3 = dataPoint.x();
                Double y3 = dataPoint.y();
                Map map5 = posMaxByBin;
                bl = false;
                if (map5.containsKey(x3) && SeriesUtil.INSTANCE.isFinite(y3)) {
                    Double d = y3;
                    Intrinsics.checkNotNull((Object)d);
                    if (d >= 0.0) {
                        map5 = posMaxByBin;
                        bl = false;
                        Object v = map5.get(x3);
                        Intrinsics.checkNotNull(v);
                        if (((Number)v).doubleValue() > 0.0) {
                            map5 = scalerByIndex;
                            n4 = i;
                            object = posMaxByBin;
                            bl5 = false;
                            Object v2 = object.get(x3);
                            Intrinsics.checkNotNull(v2);
                            object = 1.0 / ((Number)v2).doubleValue();
                            bl5 = false;
                            map5.put(n4, object);
                            continue;
                        }
                    }
                    if (y3 < 0.0) {
                        map5 = negMaxByBin;
                        bl = false;
                        Object v = map5.get(x3);
                        Intrinsics.checkNotNull(v);
                        if (((Number)v).doubleValue() > 0.0) {
                            map5 = scalerByIndex;
                            n4 = i;
                            object = negMaxByBin;
                            bl5 = false;
                            Object v3 = object.get(x3);
                            Intrinsics.checkNotNull(v3);
                            object = 1.0 / ((Number)v3).doubleValue();
                            bl5 = false;
                            map5.put(n4, object);
                            continue;
                        }
                    }
                    map5 = scalerByIndex;
                    n4 = i;
                    object = 1.0;
                    bl5 = false;
                    map5.put(n4, object);
                    continue;
                }
                map5 = scalerByIndex;
                n4 = i;
                object = 1.0;
                bl5 = false;
                map5.put(n4, object);
            } while (n2 < n3);
        }
        return scalerByIndex;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        DoubleVector newLoc = this.myStackPosHelper.translate(v, p, ctx2);
        double d = newLoc.getX();
        double d2 = newLoc.getY();
        Double d3 = this.myScalerByIndex.get(p.index());
        Intrinsics.checkNotNull((Object)d3);
        return new DoubleVector(d, d2 * ((Number)d3).doubleValue() * ctx2.getUnitResolution(Aes.Companion.getY()));
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.FILL.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

