/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 32\u00020\u0001:\u00042345B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\nH\u0002J$\u0010\u001d\u001a\u00020\u00002\u001a\u0010\u001e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u001fH\u0002J\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!2\u0006\u0010\u001b\u001a\u00020\nJ\u0014\u0010\"\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000bJ \u0010%\u001a\u00020&2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0016H\u0002J\u0015\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001b\u001a\u00020\nH\u0086\u0002J\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00102\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010/\u001a\u00020$J\u0014\u00100\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0010J\u0014\u00100\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000bJ\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n0\u000bR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0012\u001a.\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\tj\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ljetbrains/datalore/plot/base/DataFrame;", "", "builder", "Ljetbrains/datalore/plot/base/DataFrame$Builder;", "(Ljetbrains/datalore/plot/base/DataFrame$Builder;)V", "isEmpty", "", "()Z", "myDistinctValues", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "myIsNumeric", "", "myOrderSpecs", "", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "myRanges", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "myVectorByVar", "", "assertAllSeriesAreSameSize", "", "vectorByVar", "assertDefined", "variable", "assertNumeric", "buildModified", "serieFun", "Lkotlin/Function1;", "distinctValues", "", "dropIndices", "indices", "", "dumpSizes", "", "get", "getNumeric", "getOrderedDistinctValues", "orderSpec", "has", "hasNoOrEmpty", "isNumeric", "range", "rowCount", "selectIndices", "variables", "Builder", "Companion", "OrderSpec", "Variable", "plot-base-portable"})
public final class DataFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Variable, List<?>> myVectorByVar;
    @NotNull
    private final Map<Variable, Boolean> myIsNumeric;
    @NotNull
    private final HashMap<Variable, ClosedRange<Double>> myRanges = new HashMap();
    @NotNull
    private final HashMap<Variable, Set<Object>> myDistinctValues = new HashMap();
    @NotNull
    private final List<OrderSpec> myOrderSpecs;
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(DataFrame.class));

    private DataFrame(Builder builder) {
        this.assertAllSeriesAreSameSize((Map)builder.getMyVectorByVar$plot_base_portable());
        this.myVectorByVar = new HashMap(builder.getMyVectorByVar$plot_base_portable());
        this.myIsNumeric = new HashMap(builder.getMyIsNumeric$plot_base_portable());
        this.myOrderSpecs = builder.getMyOrderSpecs$plot_base_portable();
        Iterable $this$forEach$iv = this.myOrderSpecs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrderSpec orderSpec = (OrderSpec)element$iv;
            boolean bl = false;
            Map map2 = this.myDistinctValues;
            Variable variable = orderSpec.getVariable();
            Set<Object> set2 = this.getOrderedDistinctValues(orderSpec);
            boolean bl2 = false;
            map2.put(variable, set2);
        }
    }

    public final boolean isEmpty() {
        return this.myVectorByVar.isEmpty();
    }

    private final void assertAllSeriesAreSameSize(Map<Variable, ? extends List<?>> vectorByVar) {
        if (vectorByVar.size() > 1) {
            Iterator<Map.Entry<Variable, List<?>>> entries = vectorByVar.entrySet().iterator();
            Map.Entry<Variable, List<?>> first2 = entries.next();
            int size2 = first2.getValue().size();
            while (entries.hasNext()) {
                Map.Entry<Variable, List<?>> next = entries.next();
                if (next.getValue().size() == size2) continue;
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"All data series in data frame must have equal size\n", (Object)this.dumpSizes(vectorByVar)));
            }
        }
    }

    private final String dumpSizes(Map<Variable, ? extends List<?>> vectorByVar) {
        StringBuilder sb = new StringBuilder();
        Object object = vectorByVar;
        boolean bl = false;
        Object object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            boolean bl2 = false;
            Variable key = (Variable)object3.getKey();
            Object object4 = object;
            boolean bl3 = false;
            List value = (List)object4.getValue();
            sb.append(key.getName()).append(" : ").append(value.size()).append('\n');
        }
        object2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sb.toString()");
        return object2;
    }

    public final int rowCount() {
        return this.myVectorByVar.isEmpty() ? 0 : this.myVectorByVar.entrySet().iterator().next().getValue().size();
    }

    public final boolean has(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.myVectorByVar.containsKey(variable);
    }

    public final boolean isEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.get(variable).isEmpty();
    }

    public final boolean hasNoOrEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return !this.has(variable) || this.isEmpty(variable);
    }

    @NotNull
    public final List<?> get(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        List<?> list2 = this.myVectorByVar.get(variable);
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @NotNull
    public final List<Double> getNumeric(@NotNull Variable variable) {
        List<Double> list2;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        List<Double> list3 = list2 = this.myVectorByVar.get(variable);
        Intrinsics.checkNotNull(list3);
        if (list3.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.assertNumeric(variable);
        return list2;
    }

    @NotNull
    public final Collection<Object> distinctValues(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        Map $this$getOrPut$iv = this.myDistinctValues;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(variable);
        if (value$iv == null) {
            boolean bl = false;
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.get(variable));
            boolean bl2 = false;
            boolean bl3 = false;
            LinkedHashSet $this$distinctValues_u24lambda_u2d2_u24lambda_u2d1 = linkedHashSet;
            boolean bl4 = false;
            $this$distinctValues_u24lambda_u2d2_u24lambda_u2d1.remove(null);
            LinkedHashSet values2 = linkedHashSet;
            return values2;
        }
        return (Collection)value$iv;
    }

    @NotNull
    public final Set<Variable> variables() {
        return this.myVectorByVar.keySet();
    }

    public final boolean isNumeric(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        if (!this.myIsNumeric.containsKey(variable)) {
            SeriesUtil.CheckedDoubleList checkedDoubles = SeriesUtil.INSTANCE.checkedDoubles(this.get(variable));
            Map<Variable, Boolean> map2 = this.myIsNumeric;
            Boolean bl = checkedDoubles.notEmptyAndCanBeCast();
            boolean bl2 = false;
            map2.put(variable, bl);
        }
        Boolean bl = this.myIsNumeric.get(variable);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @Nullable
    public final ClosedRange<Double> range(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.myRanges.containsKey(variable)) {
            List<Double> v = this.getNumeric(variable);
            ClosedRange<Double> r = SeriesUtil.INSTANCE.range((Iterable<Double>)v);
            Map map2 = this.myRanges;
            boolean bl = false;
            map2.put(variable, r);
        }
        return this.myRanges.get(variable);
    }

    @NotNull
    public final Builder builder() {
        return new Builder(this);
    }

    private final void assertDefined(Variable variable) {
        if (!this.has(variable)) {
            IllegalArgumentException e = new IllegalArgumentException("Undefined variable: '" + variable + '\'');
            LOG.error(e, (Function0<String>)((Function0)new Function0<String>(e){
                final /* synthetic */ IllegalArgumentException $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = this.$e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
            }));
            throw e;
        }
    }

    private final void assertNumeric(Variable variable) {
        if (!this.isNumeric(variable)) {
            IllegalArgumentException e = new IllegalArgumentException("Not a numeric variable: '" + variable + '\'');
            LOG.error(e, (Function0<String>)((Function0)new Function0<String>(e){
                final /* synthetic */ IllegalArgumentException $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = this.$e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
            }));
            throw e;
        }
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ List<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
        });
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
        });
    }

    @NotNull
    public final DataFrame dropIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return indices.isEmpty() ? this : this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set<Integer> $indices;
            {
                this.$indices = $indices;
                super(1);
            }

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.skipAtIndices(serie, this.$indices);
            }
        });
    }

    private final DataFrame buildModified(Function1<? super List<?>, ? extends List<?>> serieFun) {
        Builder builder = this.builder();
        for (Variable variable : this.myVectorByVar.keySet()) {
            List<?> serie;
            List<?> list2 = serie = this.myVectorByVar.get(variable);
            Intrinsics.checkNotNull(list2);
            List modifiedSerie = (List)serieFun.invoke(list2);
            builder.putIntern$plot_base_portable(variable, modifiedSerie);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Object> getOrderedDistinctValues(OrderSpec orderSpec) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object it;
        Iterable $this$filterTo$iv$iv;
        List list2;
        Object $dstr$_u24__u24$byValues;
        Function1[] $this$mapValuesTo$iv$iv;
        Object destination$iv$iv;
        if (orderSpec.getAggregateOperation() != null) {
            Double d;
            Object byValue;
            Object object;
            Object list$iv$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            boolean bl = this.isNumeric(orderSpec.getOrderBy());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Can't apply aggregate operation to non-numeric values";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable $this$groupBy$iv = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.getNumeric(orderSpec.getOrderBy()));
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $dstr$_u24__u24$byValue;
                Object object2;
                Object value;
                Object element$iv$iv = iterator2.next();
                Pair $dstr$value = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-DataFrame$getOrderedDistinctValues$orderedValues$42 = false;
                key$iv$iv = value = $dstr$value.component1();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-DataFrame$getOrderedDistinctValues$orderedValues$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl6 = false;
                byValue = (Double)$dstr$_u24__u24$byValue.component2();
                d = byValue;
                object.add(d);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                void $this$filterTo$iv$iv2;
                void $this$filter$iv;
                void it$iv$iv;
                Object element$iv$iv$iv = list$iv$iv.next();
                Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
                key$iv$iv = destination$iv$iv;
                boolean bl7 = false;
                Object $i$f$getOrPut = it$iv$iv.getKey();
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                d = $i$f$getOrPut;
                object = key$iv$iv;
                boolean bl8 = false;
                byValue = $dstr$_u24__u24$byValues;
                boolean bl9 = false;
                List byValues = (List)byValue.getValue();
                byValue = byValues;
                Function1<List<Double>, Double> function1 = orderSpec.getAggregateOperation();
                boolean $i$f$filter = false;
                void var22_67 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator3 = $this$filterTo$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv$iv;
                    Object p0 = element$iv$iv = iterator3.next();
                    boolean bl10 = false;
                    if (!DataFrame.getOrderedDistinctValues$isValueComparable(p0)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv2;
                Double d2 = (Double)function1.invoke((Object)list3);
                object.put(d, d2);
            }
            list2 = MapsKt.toList((Map)destination$iv$iv);
        } else {
            list2 = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.get(orderSpec.getOrderBy()));
        }
        Function1[] $this$filter$iv = (Function1[])list2;
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(DataFrame.getOrderedDistinctValues$isValueComparable(it.getSecond()) && DataFrame.getOrderedDistinctValues$isValueComparable(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new Function1[]{getOrderedDistinctValues.orderedValues.6.INSTANCE, getOrderedDistinctValues.orderedValues.7.INSTANCE};
        Iterable $this$mapNotNull$iv2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])$this$filter$iv));
        boolean $i$f$mapNotNull22 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl11 = false;
            if (it2.getFirst() == null) continue;
            boolean bl12 = false;
            boolean bl13 = false;
            Object it$iv$iv = $dstr$_u24__u24$byValues;
            boolean bl14 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List orderedValues2 = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = CollectionsKt.zip((Iterable)this.get(orderSpec.getVariable()), (Iterable)this.get(orderSpec.getOrderBy()));
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it3 = (Pair)element$iv$iv;
            boolean bl = false;
            if (DataFrame.getOrderedDistinctValues$isValueComparable(it3.getSecond())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator4 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator4.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator4.next();
            boolean bl = false;
            Pair it4 = (Pair)element$iv$iv;
            boolean bl15 = false;
            if (it4.getFirst() == null) continue;
            boolean bl16 = false;
            boolean bl17 = false;
            Object it$iv$iv = object;
            boolean bl18 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List nonComparableAppendix = (List)destination$iv$iv3;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)(orderSpec.getDirection() < 0 ? CollectionsKt.reversed((Iterable)orderedValues2) : orderedValues2), (Iterable)nonComparableAppendix));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getOrderedDistinctValues$isValueComparable(Object value) {
        if (value == null) return false;
        if (!(value instanceof Double)) return true;
        double d = ((Number)value).doubleValue();
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (Double.isInfinite(d2)) return false;
        d2 = d;
        bl2 = false;
        if (Double.isNaN(d2)) return false;
        return true;
    }

    public /* synthetic */ DataFrame(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012 \b\u0002\u0010\u0007\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bR)\u0010\u0007\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "orderBy", "direction", "", "aggregateOperation", "Lkotlin/Function1;", "", "", "(Ljetbrains/datalore/plot/base/DataFrame$Variable;Ljetbrains/datalore/plot/base/DataFrame$Variable;ILkotlin/jvm/functions/Function1;)V", "getAggregateOperation", "()Lkotlin/jvm/functions/Function1;", "getDirection", "()I", "getOrderBy", "()Ljetbrains/datalore/plot/base/DataFrame$Variable;", "getVariable", "plot-base-portable"})
    public static final class OrderSpec {
        @NotNull
        private final Variable variable;
        @NotNull
        private final Variable orderBy;
        private final int direction;
        @Nullable
        private final Function1<List<Double>, Double> aggregateOperation;

        public OrderSpec(@NotNull Variable variable, @NotNull Variable orderBy, int direction, @Nullable Function1<? super List<Double>, Double> aggregateOperation2) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
            this.variable = variable;
            this.orderBy = orderBy;
            this.direction = direction;
            this.aggregateOperation = aggregateOperation2;
        }

        public /* synthetic */ OrderSpec(Variable variable, Variable variable2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            this(variable, variable2, n, (Function1<? super List<Double>, Double>)function1);
        }

        @NotNull
        public final Variable getVariable() {
            return this.variable;
        }

        @NotNull
        public final Variable getOrderBy() {
            return this.orderBy;
        }

        public final int getDirection() {
            return this.direction;
        }

        @Nullable
        public final Function1<List<Double>, Double> getAggregateOperation() {
            return this.aggregateOperation;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "name", "", "source", "Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "label", "(Ljava/lang/String;Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;Ljava/lang/String;)V", "isOrigin", "", "()Z", "isStat", "isTransform", "getLabel", "()Ljava/lang/String;", "getName", "getSource", "()Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "toString", "toSummaryString", "Companion", "Source", "plot-base-portable"})
    public static final class Variable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Source source;
        @NotNull
        private final String label;

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.name = name;
            this.source = source;
            this.label = label;
        }

        public /* synthetic */ Variable(String string, Source source, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                source = Source.ORIGIN;
            }
            if ((n & 4) != 0) {
                string2 = string;
            }
            this(string, source, string2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Source getSource() {
            return this.source;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final boolean isOrigin() {
            return this.source == Source.ORIGIN;
        }

        public final boolean isStat() {
            return this.source == Source.STAT;
        }

        public final boolean isTransform() {
            return this.source == Source.TRANSFORM;
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final String toSummaryString() {
            return this.name + ", '" + this.label + "' [" + (Object)((Object)this.source) + ']';
        }

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            this(name, source, null, 4, null);
        }

        @JvmOverloads
        public Variable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name, null, null, 6, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "", "(Ljava/lang/String;I)V", "ORIGIN", "TRANSFORM", "STAT", "plot-base-portable"})
        public static final class Source
        extends Enum<Source> {
            public static final /* enum */ Source ORIGIN = new Source();
            public static final /* enum */ Source TRANSFORM = new Source();
            public static final /* enum */ Source STAT = new Source();
            private static final /* synthetic */ Source[] $VALUES;

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.ORIGIN, Source.TRANSFORM, Source.STAT};
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Companion;", "", "()V", "createOriginal", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "name", "", "label", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name, @NotNull String label) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                return new Variable(name, Source.ORIGIN, label);
            }

            public static /* synthetic */ Variable createOriginal$default(Companion companion, String string, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = string;
                }
                return companion.createOriginal(string, string2);
            }

            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return jetbrains.datalore.plot.base.DataFrame$Variable$Companion.createOriginal$default(this, name, null, 2, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Companion;", "", "()V", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000fJ\u0014\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\u0006\u0010\u001a\u001a\u00020\u0004J\u001a\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0014J\u001a\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0014J!\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0000\u00a2\u0006\u0002\b!J\u001e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u0014J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\bR0\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R8\u0010\u0013\u001a&\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0007j\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder;", "", "()V", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "(Ljetbrains/datalore/plot/base/DataFrame;)V", "myIsNumeric", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "getMyIsNumeric$plot_base_portable", "()Ljava/util/HashMap;", "myOrderSpecs", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/DataFrame$OrderSpec;", "Lkotlin/collections/ArrayList;", "getMyOrderSpecs$plot_base_portable", "()Ljava/util/ArrayList;", "myVectorByVar", "", "getMyVectorByVar$plot_base_portable", "addOrderSpec", "orderSpec", "addOrderSpecs", "orderSpecs", "build", "put", "variable", "v", "putDiscrete", "putIntern", "", "putIntern$plot_base_portable", "putNumeric", "", "remove", "Companion", "plot-base-portable"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HashMap<Variable, List<?>> myVectorByVar;
        @NotNull
        private final HashMap<Variable, Boolean> myIsNumeric;
        @NotNull
        private final ArrayList<OrderSpec> myOrderSpecs;

        @NotNull
        public final HashMap<Variable, List<?>> getMyVectorByVar$plot_base_portable() {
            return this.myVectorByVar;
        }

        @NotNull
        public final HashMap<Variable, Boolean> getMyIsNumeric$plot_base_portable() {
            return this.myIsNumeric;
        }

        @NotNull
        public final ArrayList<OrderSpec> getMyOrderSpecs$plot_base_portable() {
            return this.myOrderSpecs;
        }

        public Builder() {
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myOrderSpecs = new ArrayList();
        }

        public Builder(@NotNull DataFrame data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myOrderSpecs = new ArrayList();
            this.myVectorByVar.putAll(data.myVectorByVar);
            this.myIsNumeric.putAll(data.myIsNumeric);
            this.myOrderSpecs.addAll(data.myOrderSpecs);
        }

        @NotNull
        public final Builder put(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            this.myIsNumeric.remove(variable);
            return this;
        }

        @NotNull
        public final Builder putNumeric(@NotNull Variable variable, @NotNull List<Double> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            Map map2 = this.myIsNumeric;
            Boolean bl = true;
            boolean bl2 = false;
            map2.put(variable, bl);
            return this;
        }

        @NotNull
        public final Builder putDiscrete(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern$plot_base_portable(variable, v);
            Map map2 = this.myIsNumeric;
            Boolean bl = false;
            boolean bl2 = false;
            map2.put(variable, bl);
            return this;
        }

        public final void putIntern$plot_base_portable(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            Map map2 = this.myVectorByVar;
            ArrayList arrayList = new ArrayList(v);
            boolean bl = false;
            map2.put(variable, arrayList);
        }

        @NotNull
        public final Builder remove(@NotNull Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.myVectorByVar.remove(variable);
            this.myIsNumeric.remove(variable);
            return this;
        }

        @NotNull
        public final Builder addOrderSpecs(@NotNull List<OrderSpec> orderSpecs) {
            Intrinsics.checkNotNullParameter(orderSpecs, (String)"orderSpecs");
            Iterable $this$forEach$iv = orderSpecs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrderSpec p0 = (OrderSpec)element$iv;
                this.addOrderSpec(p0);
            }
            return this;
        }

        @NotNull
        public final Builder addOrderSpec(@NotNull OrderSpec orderSpec) {
            Object v0;
            boolean bl;
            Object object;
            block3: {
                Intrinsics.checkNotNullParameter((Object)orderSpec, (String)"orderSpec");
                object = this.myOrderSpecs;
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    OrderSpec it = (OrderSpec)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariable(), (Object)orderSpec.getVariable())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            OrderSpec currentOrderSpec = v0;
            object = currentOrderSpec;
            if ((object == null ? null : ((OrderSpec)object).getAggregateOperation()) == null) {
                object = this.myOrderSpecs;
                bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)object2).remove(currentOrderSpec);
                this.myOrderSpecs.add(orderSpec);
            }
            return this;
        }

        @NotNull
        public final DataFrame build() {
            return new DataFrame(this, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder$Companion;", "", "()V", "emptyFrame", "Ljetbrains/datalore/plot/base/DataFrame;", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFrame emptyFrame() {
                return new Builder().build();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

