/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.builder.PlotContainerPortable;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.config.PlotConfigClientSideUtil;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import jetbrains.datalore.vis.svgToString.SvgToString;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J3\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u000f\u001a\u00020\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u0011JL\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0013\u0012\u0004\u0012\u00020\u00180\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0018H\u0002\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon;", "", "()V", "buildGGBunchFromProcessedSpecs", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "bunchSpec", "", "", "buildPlotsFromProcessedSpecs", "plotSpec", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotMaxWidth", "", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;)Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildSinglePlotFromProcessedSpecs", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;)Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "buildSvgImagesFromRawSpecs", "", "svgToString", "Ljetbrains/datalore/vis/svgToString/SvgToString;", "computationMessagesHandler", "Lkotlin/Function1;", "", "createPlotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "config", "Ljetbrains/datalore/plot/config/PlotConfigClientSide;", "processRawSpecs", "frontendOnly", "", "throwTestingErrors", "PlotBuildInfo", "PlotsBuildResult", "plot-config-portable"})
public final class MonolithicCommon {
    @NotNull
    public static final MonolithicCommon INSTANCE = new MonolithicCommon();

    private MonolithicCommon() {
    }

    @NotNull
    public final List<String> buildSvgImagesFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @NotNull SvgToString svgToString, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        Map<String, Object> plotSpec2 = this.processRawSpecs(plotSpec, false);
        PlotsBuildResult buildResult = this.buildPlotsFromProcessedSpecs(plotSpec2, plotSize2, null);
        if (buildResult.isError()) {
            String errorMessage = ((PlotsBuildResult.Error)buildResult).getError();
            throw new RuntimeException(errorMessage);
        }
        PlotsBuildResult.Success success2 = (PlotsBuildResult.Success)buildResult;
        Iterable $this$flatMap$iv = success2.getBuildInfos();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PlotBuildInfo)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((PlotBuildInfo)it).getComputationMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List computationMessages = (List)destination$iv$iv;
        $this$flatMap$iv = computationMessages;
        $i$f$flatMap = false;
        if (!$this$flatMap$iv.isEmpty()) {
            computationMessagesHandler.invoke((Object)computationMessages);
        }
        Iterable $this$map$iv = success2.getBuildInfos();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (PlotBuildInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PlotAssembler assembler = ((PlotBuildInfo)it).getPlotAssembler();
            PlotSvgComponent plot2 = assembler.createPlot();
            PlotContainerPortable plotContainer = new PlotContainerPortable(plot2, ((PlotBuildInfo)it).getSize());
            plotContainer.ensureContentBuilt();
            object = plotContainer.getSvg();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SvgSvgElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = svgToString.render((SvgSvgElement)it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PlotsBuildResult buildPlotsFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth) {
        PlotsBuildResult plotsBuildResult;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        this.throwTestingErrors();
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            String errorMessage = PlotConfig.Companion.getErrorMessage(plotSpec);
            return new PlotsBuildResult.Error(errorMessage);
        }
        if (PlotConfig.Companion.isPlotSpec(plotSpec)) {
            plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)this.buildSinglePlotFromProcessedSpecs(plotSpec, plotSize2, plotMaxWidth)));
        } else if (PlotConfig.Companion.isGGBunchSpec(plotSpec)) {
            plotsBuildResult = this.buildGGBunchFromProcessedSpecs(plotSpec);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected plot spec kind: ", (Object)PlotConfig.Companion.specKind(plotSpec)));
        }
        return plotsBuildResult;
    }

    private final PlotsBuildResult buildGGBunchFromProcessedSpecs(Map<String, Object> bunchSpec) {
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            return new PlotsBuildResult.Error("No plots in the bunch");
        }
        ArrayList<PlotBuildInfo> buildInfos = new ArrayList<PlotBuildInfo>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            Map plotSpec = TypeIntrinsics.asMutableMap(bunchItem.getFeatureSpec());
            PlotBuildInfo buildInfo = this.buildSinglePlotFromProcessedSpecs(plotSpec, PlotSizeHelper.INSTANCE.bunchItemSize$plot_config_portable(bunchItem), null);
            buildInfo = new PlotBuildInfo(buildInfo.getPlotAssembler(), buildInfo.getProcessedPlotSpec(), new DoubleVector(bunchItem.getX(), bunchItem.getY()), buildInfo.getSize(), buildInfo.getComputationMessages());
            buildInfos.add(buildInfo);
        }
        return new PlotsBuildResult.Success((List<PlotBuildInfo>)buildInfos);
    }

    private final PlotBuildInfo buildSinglePlotFromProcessedSpecs(Map<String, Object> plotSpec, DoubleVector plotSize2, Double plotMaxWidth) {
        ArrayList<String> computationMessages = new ArrayList<String>();
        PlotConfigClientSide config2 = PlotConfigClientSide.Companion.create(plotSpec, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
            final /* synthetic */ ArrayList<String> $computationMessages;
            {
                this.$computationMessages = $computationMessages;
                super(1);
            }

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$computationMessages.addAll((Collection<String>)it);
            }
        }));
        DoubleVector preferredSize = PlotSizeHelper.INSTANCE.singlePlotSize(plotSpec, plotSize2, plotMaxWidth, config2.getFacets(), config2.getContainsLiveMap());
        PlotAssembler assembler = this.createPlotAssembler(config2);
        return new PlotBuildInfo(assembler, plotSpec, DoubleVector.Companion.getZERO(), preferredSize, (List<String>)computationMessages);
    }

    private final PlotAssembler createPlotAssembler(PlotConfigClientSide config2) {
        return PlotConfigClientSideUtil.INSTANCE.createPlotAssembler(config2);
    }

    private final void throwTestingErrors() {
    }

    @NotNull
    public final Map<String, Object> processRawSpecs(@NotNull Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : PlotConfigServerSide.Companion.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigClientSide.Companion.processTransform(plotSpec2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "", "()V", "isError", "", "()Z", "Error", "Success", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "plot-config-portable"})
    public static abstract class PlotsBuildResult {
        private final boolean isError = this instanceof Error;

        private PlotsBuildResult() {
        }

        public final boolean isError() {
            return this.isError;
        }

        public /* synthetic */ PlotsBuildResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Error;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "plot-config-portable"})
        public static final class Error
        extends PlotsBuildResult {
            @NotNull
            private final String error;

            public Error(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult$Success;", "Ljetbrains/datalore/plot/MonolithicCommon$PlotsBuildResult;", "buildInfos", "", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "(Ljava/util/List;)V", "getBuildInfos", "()Ljava/util/List;", "plot-config-portable"})
        public static final class Success
        extends PlotsBuildResult {
            @NotNull
            private final List<PlotBuildInfo> buildInfos;

            public Success(@NotNull List<PlotBuildInfo> buildInfos) {
                Intrinsics.checkNotNullParameter(buildInfos, (String)"buildInfos");
                super(null);
                this.buildInfos = buildInfos;
            }

            @NotNull
            public final List<PlotBuildInfo> getBuildInfos() {
                return this.buildInfos;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "", "plotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "processedPlotSpec", "", "", "origin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "size", "computationMessages", "", "(Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/util/List;)V", "getComputationMessages", "()Ljava/util/List;", "getOrigin", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getPlotAssembler", "()Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "getProcessedPlotSpec", "()Ljava/util/Map;", "getSize", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-config-portable"})
    public static final class PlotBuildInfo {
        @NotNull
        private final PlotAssembler plotAssembler;
        @NotNull
        private final Map<String, Object> processedPlotSpec;
        @NotNull
        private final DoubleVector origin;
        @NotNull
        private final DoubleVector size;
        @NotNull
        private final List<String> computationMessages;

        public PlotBuildInfo(@NotNull PlotAssembler plotAssembler, @NotNull Map<String, Object> processedPlotSpec, @NotNull DoubleVector origin, @NotNull DoubleVector size2, @NotNull List<String> computationMessages) {
            Intrinsics.checkNotNullParameter((Object)plotAssembler, (String)"plotAssembler");
            Intrinsics.checkNotNullParameter(processedPlotSpec, (String)"processedPlotSpec");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            Intrinsics.checkNotNullParameter(computationMessages, (String)"computationMessages");
            this.plotAssembler = plotAssembler;
            this.processedPlotSpec = processedPlotSpec;
            this.origin = origin;
            this.size = size2;
            this.computationMessages = computationMessages;
        }

        @NotNull
        public final PlotAssembler getPlotAssembler() {
            return this.plotAssembler;
        }

        @NotNull
        public final Map<String, Object> getProcessedPlotSpec() {
            return this.processedPlotSpec;
        }

        @NotNull
        public final DoubleVector getOrigin() {
            return this.origin;
        }

        @NotNull
        public final DoubleVector getSize() {
            return this.size;
        }

        @NotNull
        public final List<String> getComputationMessages() {
            return this.computationMessages;
        }

        @NotNull
        public final DoubleRectangle bounds() {
            return new DoubleRectangle(this.origin, this.size);
        }
    }
}

