/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.stringFormat;

import java.util.List;
import jetbrains.datalore.base.dateFormat.DateTimeFormat;
import jetbrains.datalore.base.dateFormat.Pattern;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import jetbrains.datalore.base.numberFormat.NumberFormat;
import jetbrains.datalore.base.stringFormat.StringFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001J\u0014\u0010\u000e\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\fJ$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat;", "", "pattern", "", "formatType", "Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "(Ljava/lang/String;Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;)V", "argsNumber", "", "getArgsNumber", "()I", "myFormatters", "", "Lkotlin/Function1;", "format", "value", "values", "initFormatter", "formatPattern", "Companion", "FormatType", "base-portable"})
public final class StringFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final FormatType formatType;
    @NotNull
    private final List<Function1<Object, String>> myFormatters;
    private final int argsNumber;
    @NotNull
    private static final Regex BRACES_REGEX = new Regex("(?![^{]|\\{\\{)(\\{([^{}]*)\\})(?=[^}]|\\}\\}|$)");
    private static final int TEXT_IN_BRACES = 2;

    private StringFormat(String pattern2, FormatType formatType) {
        List list2;
        this.pattern = pattern2;
        this.formatType = formatType;
        FormatType formatType2 = this.formatType;
        int n = WhenMappings.$EnumSwitchMapping$0[formatType2.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                list2 = CollectionsKt.listOf(this.initFormatter(this.pattern, this.formatType));
                break;
            }
            case 3: {
                list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)BRACES_REGEX, (CharSequence)this.pattern, (int)0, (int)2, null), (Function1)1.INSTANCE), (Function1)((Function1)new Function1<String, Function1<? super Object, ? extends String>>(){

                    @NotNull
                    public final Function1<Object, String> invoke(@NotNull String format2) {
                        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
                        FormatType formatType = Companion.detectFormatType(format2);
                        boolean bl = formatType == FormatType.NUMBER_FORMAT || formatType == FormatType.DATETIME_FORMAT;
                        StringFormat stringFormat = this;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!bl) {
                            boolean bl4 = false;
                            String string = "Can't detect type of pattern '" + format2 + "' used in string pattern '" + stringFormat.pattern + '\'';
                            boolean bl5 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        return this.initFormatter(format2, formatType);
                    }
                })));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.myFormatters = list2;
        this.argsNumber = this.myFormatters.size();
    }

    public final int getArgsNumber() {
        return this.argsNumber;
    }

    @NotNull
    public final String format(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.format(CollectionsKt.listOf((Object)value));
    }

    @NotNull
    public final String format(@NotNull List<? extends Object> values2) {
        String string;
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (this.argsNumber != values2.size()) {
            String string2 = "Can't format values " + values2 + " with pattern '" + this.pattern + "'. Wrong number of arguments: expected " + this.argsNumber + " instead of " + values2.size();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        FormatType formatType = this.formatType;
        int n = WhenMappings.$EnumSwitchMapping$0[formatType.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                boolean bl = this.myFormatters.size() == 1;
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string3 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                string = (String)((Function1)CollectionsKt.single(this.myFormatters)).invoke(CollectionsKt.single(values2));
                break;
            }
            case 3: {
                Ref.IntRef index = new Ref.IntRef();
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)BRACES_REGEX.replace((CharSequence)this.pattern, (Function1)new Function1<MatchResult, CharSequence>(values2, index, this){
                    final /* synthetic */ List<Object> $values;
                    final /* synthetic */ Ref.IntRef $index;
                    final /* synthetic */ StringFormat this$0;
                    {
                        this.$values = $values;
                        this.$index = $index;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull MatchResult it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object originalValue = this.$values.get(this.$index.element);
                        int n = this.$index.element;
                        this.$index.element = n + 1;
                        Function1 formatter2 = (Function1)StringFormat.access$getMyFormatters$p(this.this$0).get(n);
                        return (CharSequence)formatter2.invoke(originalValue);
                    }
                }), (String)"{{", (String)"{", (boolean)false, (int)4, null), (String)"}}", (String)"}", (boolean)false, (int)4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final Function1<Object, String> initFormatter(String formatPattern, FormatType formatType) {
        Object object = formatPattern;
        int n = 0;
        if (object.length() == 0) {
            return initFormatter.1.INSTANCE;
        }
        object = formatType;
        n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                NumberFormat numberFormatter = new NumberFormat(formatPattern);
                return (Function1)new Function1<Object, String>(numberFormatter){
                    final /* synthetic */ NumberFormat $numberFormatter;
                    {
                        this.$numberFormatter = $numberFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Object object = value;
                        if (object instanceof Number) {
                            string = this.$numberFormatter.apply((Number)value);
                        } else if (object instanceof String) {
                            String string2;
                            Float f = StringsKt.toFloatOrNull((String)((String)value));
                            if (f == null) {
                                string2 = null;
                            } else {
                                Float f2 = f;
                                NumberFormat numberFormat = this.$numberFormatter;
                                boolean bl = false;
                                boolean bl2 = false;
                                Number p0 = f2;
                                boolean bl3 = false;
                                string2 = numberFormat.apply(p0);
                            }
                            String string3 = string2;
                            string = string3 == null ? (String)value : string3;
                        } else {
                            String string4 = "Failed to format value with type " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ". Supported types are Number and String.";
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string4.toString());
                        }
                        return string;
                    }
                };
            }
            case 2: {
                DateTimeFormat dateTimeFormatter2 = new DateTimeFormat(formatPattern);
                return (Function1)new Function1<Object, String>(dateTimeFormatter2){
                    final /* synthetic */ DateTimeFormat $dateTimeFormatter;
                    {
                        this.$dateTimeFormatter = $dateTimeFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        boolean bl = value instanceof Number;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!bl) {
                            boolean bl4 = false;
                            String string = "Value '" + value + "' to be formatted as DateTime expected to be a Number, but was " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName();
                            boolean bl5 = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        long l = ((Number)value).longValue();
                        bl2 = false;
                        bl3 = false;
                        long p0 = l;
                        boolean bl6 = false;
                        Comparable<Instant> comparable = new Instant(p0);
                        Object object = TimeZone.Companion.getUTC();
                        bl3 = false;
                        boolean bl7 = false;
                        Instant p02 = comparable;
                        boolean bl8 = false;
                        comparable = ((TimeZone)object).toDateTime(p02);
                        object = this.$dateTimeFormatter;
                        bl3 = false;
                        bl7 = false;
                        p02 = comparable;
                        boolean bl9 = false;
                        return ((DateTimeFormat)object).apply((DateTime)((Object)p02));
                    }
                };
            }
        }
        String string = Intrinsics.stringPlus((String)"Undefined format pattern ", (Object)formatPattern);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public static final /* synthetic */ List access$getMyFormatters$p(StringFormat $this) {
        return $this.myFormatters;
    }

    public /* synthetic */ StringFormat(String pattern2, FormatType formatType, DefaultConstructorMarker $constructor_marker) {
        this(pattern2, formatType);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "", "(Ljava/lang/String;I)V", "NUMBER_FORMAT", "DATETIME_FORMAT", "STRING_FORMAT", "base-portable"})
    public static final class FormatType
    extends Enum<FormatType> {
        public static final /* enum */ FormatType NUMBER_FORMAT = new FormatType();
        public static final /* enum */ FormatType DATETIME_FORMAT = new FormatType();
        public static final /* enum */ FormatType STRING_FORMAT = new FormatType();
        private static final /* synthetic */ FormatType[] $VALUES;

        public static FormatType[] values() {
            return (FormatType[])$VALUES.clone();
        }

        public static FormatType valueOf(String value) {
            return Enum.valueOf(FormatType.class, value);
        }

        static {
            $VALUES = formatTypeArray = new FormatType[]{FormatType.NUMBER_FORMAT, FormatType.DATETIME_FORMAT, FormatType.STRING_FORMAT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nJ&\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/base/stringFormat/StringFormat$Companion;", "", "()V", "BRACES_REGEX", "Lkotlin/text/Regex;", "TEXT_IN_BRACES", "", "create", "Ljetbrains/datalore/base/stringFormat/StringFormat;", "pattern", "", "type", "Ljetbrains/datalore/base/stringFormat/StringFormat$FormatType;", "formatFor", "expectedArgs", "create$base_portable", "detectFormatType", "forNArgs", "argCount", "forOneArg", "valueInLinePattern", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String valueInLinePattern() {
            return "{}";
        }

        @NotNull
        public final StringFormat forOneArg(@NotNull String pattern2, @Nullable FormatType type, @Nullable String formatFor) {
            Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
            return this.create$base_portable(pattern2, type, formatFor, 1);
        }

        public static /* synthetic */ StringFormat forOneArg$default(Companion companion, String string, FormatType formatType, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                formatType = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.forOneArg(string, formatType, string2);
        }

        @NotNull
        public final StringFormat forNArgs(@NotNull String pattern2, int argCount, @Nullable String formatFor) {
            Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
            return this.create$base_portable(pattern2, FormatType.STRING_FORMAT, formatFor, argCount);
        }

        public static /* synthetic */ StringFormat forNArgs$default(Companion companion, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            return companion.forNArgs(string, n, string2);
        }

        private final FormatType detectFormatType(String pattern2) {
            return NumberFormat.Companion.isValidPattern(pattern2) ? FormatType.NUMBER_FORMAT : (Pattern.Companion.isDateTimeFormat(pattern2) ? FormatType.DATETIME_FORMAT : FormatType.STRING_FORMAT);
        }

        @NotNull
        public final StringFormat create$base_portable(@NotNull String pattern2, @Nullable FormatType type, @Nullable String formatFor, int expectedArgs) {
            Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
            Object object = type;
            FormatType formatType = object == null ? this.detectFormatType(pattern2) : object;
            object = new StringFormat(pattern2, formatType, null);
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            if (expectedArgs > 0) {
                boolean bl4 = ((StringFormat)it).getArgsNumber() == expectedArgs;
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    String string;
                    boolean bl7 = false;
                    String string2 = formatFor;
                    if (string2 == null) {
                        string = "";
                    } else {
                        String string3 = string2;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        String it2 = string3;
                        boolean bl10 = false;
                        String string4 = "to format '" + formatFor + '\'';
                        string = string4 == null ? "" : string4;
                    }
                    String formatFor2 = string;
                    String string5 = "Wrong number of arguments in pattern '" + pattern2 + "' " + formatFor2 + ". Expected " + expectedArgs + ' ' + (expectedArgs > 1 ? "arguments" : "argument") + " instead of " + ((StringFormat)it).getArgsNumber();
                    throw (Throwable)new IllegalArgumentException(string5.toString());
                }
            }
            return object;
        }

        public static /* synthetic */ StringFormat create$base_portable$default(Companion companion, String string, FormatType formatType, String string2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                formatType = null;
            }
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                n = -1;
            }
            return companion.create$base_portable(string, formatType, string2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormatType.values().length];
            nArray[FormatType.NUMBER_FORMAT.ordinal()] = 1;
            nArray[FormatType.DATETIME_FORMAT.ordinal()] = 2;
            nArray[FormatType.STRING_FORMAT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

