/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/LinearRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "(Ljava/util/List;Ljava/util/List;D)V", "beta0", "beta1", "meanX", "n", "", "sumXX", "sy", "tcritical", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "value", "plot-base-portable"})
public final class LinearRegression
extends RegressionEvaluator {
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double beta1;
    private final double beta0;
    private final double sy;
    private final double tcritical;

    /*
     * WARNING - void declaration
     */
    public LinearRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel) {
        void $this$_init__u24lambda_u2d4;
        LinearRegression $this$_init__u24lambda_u2d3;
        double d;
        int n;
        boolean bl;
        double d2;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        Pair<double[], double[]> pair = RegressionUtilKt.allFinite(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        this.meanX = ArraysKt.average((double[])xVals);
        double[] dArray = xVals;
        LinearRegression linearRegression = this;
        boolean bl2 = false;
        double d3 = 0.0;
        double[] dArray2 = dArray;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            void it22;
            double d4;
            double d5 = d4 = dArray2[i];
            d2 = d3;
            boolean bl3 = false;
            void var20_30 = it22 - this.meanX;
            int n3 = 2;
            bl = false;
            double d6 = Math.pow((double)var20_30, n3);
            d3 = d2 + d6;
        }
        linearRegression.sumXX = d2 = d3;
        double meanY = ArraysKt.average((double[])yVals);
        dArray2 = yVals;
        n2 = 0;
        double d7 = 0.0;
        double[] dArray3 = dArray2;
        int it22 = dArray3.length;
        for (int i = 0; i < it22; ++i) {
            void it;
            double bl3;
            double d8 = bl3 = dArray3[i];
            double d9 = d7;
            boolean bl4 = false;
            void var24_45 = it - meanY;
            n = 2;
            boolean bl5 = false;
            d = Math.pow((double)var24_45, n);
            d7 = d9 + d;
        }
        double sumYY = d7;
        Object object = ArraysKt.zip((double[])xVals, (double[])yVals);
        boolean bl6 = false;
        double d10 = 0.0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void $dstr$x$y;
            Object bl3 = iterator.next();
            Pair pair2 = (Pair)bl3;
            double d11 = d10;
            boolean bl7 = false;
            double x = ((Number)$dstr$x$y.component1()).doubleValue();
            double y = ((Number)$dstr$x$y.component2()).doubleValue();
            d = (x - this.meanX) * (y - meanY);
            d10 = d11 + d;
        }
        double sumXY = d10;
        this.beta1 = sumXY / this.sumXX;
        this.beta0 = meanY - this.beta1 * this.meanX;
        object = this;
        bl6 = false;
        boolean bl8 = false;
        LinearRegression it22 = (LinearRegression)object;
        linearRegression = this;
        boolean bl9 = false;
        double bl3 = 0.0;
        double d12 = sumYY - sumXY * sumXY / $this$_init__u24lambda_u2d3.sumXX;
        bl = false;
        double sse = Math.max(bl3, d12);
        bl3 = sse / (double)($this$_init__u24lambda_u2d3.n - 2);
        n = 0;
        d2 = Math.sqrt(bl3);
        linearRegression.sy = d2;
        object = this;
        bl6 = false;
        bl8 = false;
        $this$_init__u24lambda_u2d3 = (LinearRegression)object;
        linearRegression = this;
        boolean bl10 = false;
        double alpha = 1.0 - confidenceLevel;
        d2 = new TDistribution((double)$this$_init__u24lambda_u2d4.n - 2.0, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        linearRegression.tcritical = d2;
    }

    private final double value(double x) {
        return this.beta1 * x + this.beta0;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        LinearRegression linearRegression = this;
        boolean bl = false;
        boolean bl2 = false;
        LinearRegression $this$evalX_u24lambda_u2d5 = linearRegression;
        boolean bl3 = false;
        double d = x - $this$evalX_u24lambda_u2d5.meanX;
        int n = 2;
        boolean bl4 = false;
        double dxSquare = Math.pow(d, n);
        d = 1.0 / (double)$this$evalX_u24lambda_u2d5.n + dxSquare / $this$evalX_u24lambda_u2d5.sumXX;
        n = 0;
        double se = $this$evalX_u24lambda_u2d5.sy * Math.sqrt(d);
        double halfConfidenceInterval = this.tcritical * se;
        double yHat = this.value(x);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }
}

