/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSUnit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSimpleValueWithUnit
implements Serializable {
    private BigDecimal m_aValue;
    private ECSSUnit m_eUnit;

    public CSSSimpleValueWithUnit(@Nonnull BigDecimal bigDecimal, @Nonnull ECSSUnit eCSSUnit) {
        this.setValue(bigDecimal);
        this.setUnit(eCSSUnit);
    }

    public CSSSimpleValueWithUnit(double d, @Nonnull ECSSUnit eCSSUnit) {
        this(BigDecimal.valueOf(d), eCSSUnit);
    }

    @Nonnull
    public CSSSimpleValueWithUnit setValue(@Nonnull BigDecimal bigDecimal) {
        this.m_aValue = (BigDecimal)ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        return this;
    }

    @Nonnull
    public CSSSimpleValueWithUnit setValue(double d) {
        return this.setValue(BigDecimal.valueOf(d));
    }

    @Nonnull
    public BigDecimal getAsBigDecimalValue() {
        return this.m_aValue;
    }

    public double getValue() {
        return this.m_aValue.doubleValue();
    }

    public int getAsIntValue() {
        return this.m_aValue.intValue();
    }

    public long getAsLongValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public CSSSimpleValueWithUnit setUnit(@Nonnull ECSSUnit eCSSUnit) {
        this.m_eUnit = (ECSSUnit)ValueEnforcer.notNull((Object)eCSSUnit, (String)"Unit");
        return this;
    }

    @Nonnull
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Nonnull
    @Nonempty
    public String getFormatted() {
        return this.m_eUnit.format(this.m_aValue);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit add(@Nonnull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.add(bigDecimal), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit add(double d) {
        return this.add(BigDecimal.valueOf(d));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit substract(@Nonnull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.subtract(bigDecimal), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit substract(double d) {
        return this.substract(BigDecimal.valueOf(d));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit multiply(@Nonnull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.multiply(bigDecimal), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit multiply(double d) {
        return this.multiply(BigDecimal.valueOf(d));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(@Nonnull BigDecimal bigDecimal, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return new CSSSimpleValueWithUnit(this.m_aValue.divide(bigDecimal, n, roundingMode), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(@Nonnull BigDecimal bigDecimal) {
        return this.divide(bigDecimal, 16, RoundingMode.HALF_UP);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(double d) {
        return this.divide(BigDecimal.valueOf(d));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSimpleValueWithUnit cSSSimpleValueWithUnit = (CSSSimpleValueWithUnit)object;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)cSSSimpleValueWithUnit.m_aValue) && this.m_eUnit.equals(cSSSimpleValueWithUnit.m_eUnit);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValue).append((Enum)this.m_eUnit).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("value", (Object)this.m_aValue).append("unit", (Enum)this.m_eUnit).getToString();
    }
}

