/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.delegate.LayoutManagerDelegate;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.spinner.DarkSpinnerListener;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import com.github.weisj.darklaf.ui.spinner.SpinnerIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class DarkSpinnerUI
extends BasicSpinnerUI
implements SpinnerConstants {
    protected DarkSpinnerListener spinnerListener;
    protected Color arrowBackground;
    protected Color background;
    protected Icon arrowDownIcon;
    protected Color inactiveBackground;
    protected int arc;
    protected int borderSize;
    protected Icon arrowUpIcon;
    protected Icon plusIcon;
    protected Icon minusIcon;
    protected Icon arrowDownInactiveIcon;
    protected Icon arrowUpInactiveIcon;
    protected Icon plusInactiveIcon;
    protected Icon minusInactiveIcon;
    private JComponent editor;
    private JButton prevButton;
    private Component editorComponent;
    private JButton nextButton;

    public static ComponentUI createUI(JComponent c) {
        return new DarkSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arc = UIManager.getInt("Spinner.arc");
        this.borderSize = UIManager.getInt("Spinner.borderThickness");
        this.background = UIManager.getColor("Spinner.activeBackground");
        this.inactiveBackground = UIManager.getColor("Spinner.inactiveBackground");
        this.arrowBackground = UIManager.getColor("Spinner.arrowBackground");
        this.arrowDownIcon = UIManager.getIcon("Spinner.arrowDown.icon");
        this.arrowUpIcon = UIManager.getIcon("Spinner.arrowUp.icon");
        this.minusIcon = UIManager.getIcon("Spinner.minus.icon");
        this.plusIcon = UIManager.getIcon("Spinner.plus.icon");
        this.arrowDownInactiveIcon = UIManager.getIcon("Spinner.arrowDownInactive.icon");
        this.arrowUpInactiveIcon = UIManager.getIcon("Spinner.arrowUpInactive.icon");
        this.minusInactiveIcon = UIManager.getIcon("Spinner.minusInactive.icon");
        this.plusInactiveIcon = UIManager.getIcon("Spinner.plusInactive.icon");
        LookAndFeel.installProperty(this.spinner, "opaque", false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.spinnerListener = this.createSpinnerListener();
        this.spinner.addMouseListener(this.spinnerListener);
        this.spinner.addPropertyChangeListener(this.spinnerListener);
    }

    protected DarkSpinnerListener createSpinnerListener() {
        return new DarkSpinnerListener(this.spinner, this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.editor != null && this.editor.getComponents().length > 0) {
            this.editor.getComponents()[0].removeFocusListener(this.spinnerListener);
        }
        this.spinner.removeMouseListener(this.spinnerListener);
        this.spinner.removePropertyChangeListener(this.spinnerListener);
        this.spinnerListener = null;
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){
            private Component editor;
            {
                this.editor = null;
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
                super.addLayoutComponent(name, comp);
                if ("Editor".equals(name)) {
                    this.editor = comp;
                }
            }

            protected void adjustButton(JComponent button, int adj) {
                Rectangle bounds = button.getBounds();
                bounds.x += adj;
                button.setBounds(bounds);
            }

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (SpinnerConstants.isTreeOrTableCellEditor(DarkSpinnerUI.this.spinner)) {
                    int adj = DarkSpinnerUI.this.borderSize / 2;
                    if (!DarkSpinnerUI.this.spinner.getComponentOrientation().isLeftToRight()) {
                        adj *= -1;
                    }
                    this.adjustButton(DarkSpinnerUI.this.prevButton, adj);
                    this.adjustButton(DarkSpinnerUI.this.nextButton, adj);
                }
                if (this.editor != null && !DarkSpinnerUI.this.spinner.getComponentOrientation().isLeftToRight()) {
                    Rectangle bounds = this.editor.getBounds();
                    bounds.x += DarkSpinnerUI.this.borderSize;
                    bounds.width -= DarkSpinnerUI.this.borderSize;
                    this.editor.setBounds(bounds);
                }
            }
        };
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createArrow(5);
        this.prevButton.setName("Spinner.previousButton");
        this.prevButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.prevButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = this.createArrow(1);
        this.nextButton.setName("Spinner.nextButton");
        this.nextButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.nextButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installNextButtonListeners(this.nextButton);
        return this.nextButton;
    }

    @Override
    protected JComponent createEditor() {
        this.editor = super.createEditor();
        this.editorComponent = this.editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)this.editor).getTextField() : this.editor;
        this.editorComponent.addFocusListener(this.spinnerListener);
        return this.editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.editor = newEditor;
        if (oldEditor != null && oldEditor.getComponents().length > 0) {
            oldEditor.getComponents()[0].removeFocusListener(this.spinnerListener);
        }
        if (newEditor != null && newEditor.getComponents().length > 0) {
            Component comp = newEditor.getComponents()[0];
            comp.addFocusListener(this.spinnerListener);
        }
    }

    private JButton createArrow(int direction) {
        int buttonPad = UIManager.getInt("Spinner.buttonPad");
        Insets insets = new Insets(0, buttonPad, 0, buttonPad);
        JButton button = ArrowButton.createUpDownArrow(this.spinner, this.getArrowIcon(direction), this.getArrowInactiveIcon(direction), direction, false, true, insets);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            button.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            button.setBorder(buttonBorder);
        }
        button.setInheritsPopupMenu(true);
        return button;
    }

    protected SpinnerIcon getArrowIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownIcon, this.minusIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpIcon, this.plusIcon);
    }

    protected SpinnerIcon getArrowInactiveIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownInactiveIcon, this.minusInactiveIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpInactiveIcon, this.plusInactiveIcon);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null && parent.isOpaque() && !c.isEnabled()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            return;
        }
        int size = this.borderSize;
        int width = c.getWidth();
        int height = c.getHeight();
        JComponent editor = this.spinner.getEditor();
        if (this.editorComponent != null) {
            this.editorComponent.setBackground(this.getBackground(c));
            g.setColor(this.editorComponent.getBackground());
        } else {
            g.setColor(this.getBackground(c));
        }
        if (!SpinnerConstants.isTreeOrTableCellEditor(c)) {
            PaintUtil.fillRoundRect((Graphics2D)g, size, size, width - 2 * size, height - 2 * size, this.arc);
        } else {
            g.fillRect(0, 0, width, height);
        }
        if (editor != null) {
            this.paintSpinBackground((Graphics2D)g, width, height, size, this.arc);
        }
    }

    protected void paintSpinBackground(Graphics2D g, int width, int height, int bSize, int arc) {
        Rectangle arrowBounds = this.prevButton.getBounds();
        boolean leftToRight = this.spinner.getComponentOrientation().isLeftToRight();
        Shape oldClip = g.getClip();
        g.setColor(this.getArrowBackground(this.spinner));
        if (leftToRight) {
            g.clipRect(arrowBounds.x, 0, width - arrowBounds.x, height);
        } else {
            g.clipRect(0, 0, arrowBounds.x + arrowBounds.width, height);
        }
        if (SpinnerConstants.isTreeOrTableCellEditor(this.spinner)) {
            g.fillRect(0, 0, width, height);
        } else {
            PaintUtil.fillRoundRect(g, bSize, bSize, width - 2 * bSize, height - 2 * bSize, arc);
        }
        g.setClip(oldClip);
    }

    protected Color getBackground(JComponent c) {
        return c == null ? this.inactiveBackground : c.getBackground();
    }

    protected Color getArrowBackground(JComponent c) {
        return c == null || !c.isEnabled() ? this.inactiveBackground : this.arrowBackground;
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }

    public JComponent getEditor() {
        return this.editor;
    }
}

