/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ViewPropertyChangeListener
implements PropertyChangeListener {
    private final JScrollPane scrollPane;
    private final PropertyChangeListener listener;
    private final ContainerListener containerListener = new ContainerAdapter(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (ViewPropertyChangeListener.this.currentView != null) {
                ViewPropertyChangeListener.this.currentView.removePropertyChangeListener(ViewPropertyChangeListener.this.listener);
            }
            ViewPropertyChangeListener.this.currentView = e.getChild();
            if (ViewPropertyChangeListener.this.currentView != null) {
                ViewPropertyChangeListener.this.currentView.addPropertyChangeListener(ViewPropertyChangeListener.this.listener);
            }
        }
    };
    private Component currentView;

    public ViewPropertyChangeListener(JScrollPane scrollPane, PropertyChangeListener listener) {
        this.scrollPane = scrollPane;
        this.listener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String key = e.getPropertyName();
        Object source = e.getSource();
        if (source == this.scrollPane && "viewport".equals(key)) {
            Object old = e.getOldValue();
            Object newVal = e.getNewValue();
            if (old instanceof JViewport) {
                ((JViewport)old).addContainerListener(this.containerListener);
            }
            if (newVal instanceof JViewport) {
                ((JViewport)newVal).removeContainerListener(this.containerListener);
            }
        }
    }

    public void install() {
        this.scrollPane.addPropertyChangeListener(this);
        JViewport viewport = this.scrollPane.getViewport();
        if (viewport != null) {
            viewport.addContainerListener(this.containerListener);
            Component view = viewport.getView();
            if (view != null) {
                view.addPropertyChangeListener(this.listener);
            }
        }
    }

    public void uninstall() {
        this.scrollPane.removePropertyChangeListener(this);
        JViewport viewport = this.scrollPane.getViewport();
        if (viewport != null) {
            viewport.removeContainerListener(this.containerListener);
            Component view = viewport.getView();
            if (view != null) {
                view.removePropertyChangeListener(this.listener);
            }
        }
    }
}

